/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.15.0 2013-09-22
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef MESSAGE_LOG_CYBOI_MODEL_CONSTANT_SOURCE
#define MESSAGE_LOG_CYBOI_MODEL_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

//
// Array log messages.
//

/** The "Could not create array. The type is null." message log cyboi model. */
static wchar_t COULD_NOT_CREATE_ARRAY_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'C', L'o', L'u', L'l', L'd', L' ', L'n', L'o', L't', L' ', L'c', L'r', L'e', L'a', L't', L'e', L' ', L'a', L'r', L'r', L'a', L'y', L'.', L' ', L'T', L'h', L'e', L' ', L't', L'y', L'p', L'e', L' ', L'i', L's', L' ', L'n', L'u', L'l', L'l', L'.'};
static wchar_t* COULD_NOT_CREATE_ARRAY_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL = COULD_NOT_CREATE_ARRAY_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* COULD_NOT_CREATE_ARRAY_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_41_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Could not destroy array. The type is null." message log cyboi model. */
static wchar_t COULD_NOT_DESTROY_ARRAY_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'C', L'o', L'u', L'l', L'd', L' ', L'n', L'o', L't', L' ', L'd', L'e', L's', L't', L'r', L'o', L'y', L' ', L'a', L'r', L'r', L'a', L'y', L'.', L' ', L'T', L'h', L'e', L' ', L't', L'y', L'p', L'e', L' ', L'i', L's', L' ', L'n', L'u', L'l', L'l', L'.'};
static wchar_t* COULD_NOT_DESTROY_ARRAY_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL = COULD_NOT_DESTROY_ARRAY_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* COULD_NOT_DESTROY_ARRAY_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_42_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Could not resize array. The type is null." message log cyboi model. */
static wchar_t COULD_NOT_RESIZE_ARRAY_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'C', L'o', L'u', L'l', L'd', L' ', L'n', L'o', L't', L' ', L'r', L'e', L's', L'i', L'z', L'e', L' ', L'a', L'r', L'r', L'a', L'y', L'.', L' ', L'T', L'h', L'e', L' ', L't', L'y', L'p', L'e', L' ', L'i', L's', L' ', L'n', L'u', L'l', L'l', L'.'};
static wchar_t* COULD_NOT_RESIZE_ARRAY_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL = COULD_NOT_RESIZE_ARRAY_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* COULD_NOT_RESIZE_ARRAY_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_41_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Could not compare array elements. The type is null." message log cyboi model. */
static wchar_t COULD_NOT_COMPARE_ARRAY_ELEMENTS_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'C', L'o', L'u', L'l', L'd', L' ', L'n', L'o', L't', L' ', L'c', L'o', L'm', L'p', L'a', L'r', L'e', L' ', L'a', L'r', L'r', L'a', L'y', L' ', L'e', L'l', L'e', L'm', L'e', L'n', L't', L's', L'.', L' ', L'T', L'h', L'e', L' ', L't', L'y', L'p', L'e', L' ', L'i', L's', L' ', L'n', L'u', L'l', L'l', L'.'};
static wchar_t* COULD_NOT_COMPARE_ARRAY_ELEMENTS_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL = COULD_NOT_COMPARE_ARRAY_ELEMENTS_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* COULD_NOT_COMPARE_ARRAY_ELEMENTS_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_51_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Could not set array elements. The type is null." message log cyboi model. */
static wchar_t COULD_NOT_SET_ARRAY_ELEMENTS_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'C', L'o', L'u', L'l', L'd', L' ', L'n', L'o', L't', L' ', L's', L'e', L't', L' ', L'a', L'r', L'r', L'a', L'y', L' ', L'e', L'l', L'e', L'm', L'e', L'n', L't', L's', L'.', L' ', L'T', L'h', L'e', L' ', L't', L'y', L'p', L'e', L' ', L'i', L's', L' ', L'n', L'u', L'l', L'l', L'.'};
static wchar_t* COULD_NOT_SET_ARRAY_ELEMENTS_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL = COULD_NOT_SET_ARRAY_ELEMENTS_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* COULD_NOT_SET_ARRAY_ELEMENTS_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_47_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Could not remove array elements. The type is null." message log cyboi model. */
static wchar_t COULD_NOT_REMOVE_ARRAY_ELEMENTS_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'C', L'o', L'u', L'l', L'd', L' ', L'n', L'o', L't', L' ', L'r', L'e', L'm', L'o', L'v', L'e', L' ', L'a', L'r', L'r', L'a', L'y', L' ', L'e', L'l', L'e', L'm', L'e', L'n', L't', L's', L'.', L' ', L'T', L'h', L'e', L' ', L't', L'y', L'p', L'e', L' ', L'i', L's', L' ', L'n', L'u', L'l', L'l', L'.'};
static wchar_t* COULD_NOT_REMOVE_ARRAY_ELEMENTS_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL = COULD_NOT_REMOVE_ARRAY_ELEMENTS_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* COULD_NOT_REMOVE_ARRAY_ELEMENTS_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_50_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Could not get array elements. The type is null." message log cyboi model. */
static wchar_t COULD_NOT_GET_ARRAY_ELEMENTS_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'C', L'o', L'u', L'l', L'd', L' ', L'n', L'o', L't', L' ', L'g', L'e', L't', L' ', L'a', L'r', L'r', L'a', L'y', L' ', L'e', L'l', L'e', L'm', L'e', L'n', L't', L's', L'.', L' ', L'T', L'h', L'e', L' ', L't', L'y', L'p', L'e', L' ', L'i', L's', L' ', L'n', L'u', L'l', L'l', L'.'};
static wchar_t* COULD_NOT_GET_ARRAY_ELEMENTS_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL = COULD_NOT_GET_ARRAY_ELEMENTS_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* COULD_NOT_GET_ARRAY_ELEMENTS_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_47_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Could not get array elements index. The type is null." message log cyboi model. */
static wchar_t COULD_NOT_GET_ARRAY_ELEMENTS_INDEX_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'C', L'o', L'u', L'l', L'd', L' ', L'n', L'o', L't', L' ', L'g', L'e', L't', L' ', L'a', L'r', L'r', L'a', L'y', L' ', L'e', L'l', L'e', L'm', L'e', L'n', L't', L's', L' ', L'i', L'n', L'd', L'e', L'x', L'.', L' ', L'T', L'h', L'e', L' ', L't', L'y', L'p', L'e', L' ', L'i', L's', L' ', L'n', L'u', L'l', L'l', L'.'};
static wchar_t* COULD_NOT_GET_ARRAY_ELEMENTS_INDEX_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL = COULD_NOT_GET_ARRAY_ELEMENTS_INDEX_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* COULD_NOT_GET_ARRAY_ELEMENTS_INDEX_THE_TYPE_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_53_INTEGER_STATE_CYBOI_MODEL_ARRAY;

//
// Operation log messages.
//

/** The "Create operation." message log cyboi model. */
static wchar_t CREATE_OPERATION_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'C', L'r', L'e', L'a', L't', L'e', L' ', L'o', L'p', L'e', L'r', L'a', L't', L'i', L'o', L'n', L'.'};
static wchar_t* CREATE_OPERATION_MESSAGE_LOG_CYBOI_MODEL = CREATE_OPERATION_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* CREATE_OPERATION_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_17_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Destroy operation." message log cyboi model. */
static wchar_t DESTROY_OPERATION_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'D', L'e', L's', L't', L'r', L'o', L'y', L' ', L'o', L'p', L'e', L'r', L'a', L't', L'i', L'o', L'n', L'.'};
static wchar_t* DESTROY_OPERATION_MESSAGE_LOG_CYBOI_MODEL = DESTROY_OPERATION_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* DESTROY_OPERATION_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_18_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Initialise operation." message log cyboi model. */
static wchar_t INITIALIZE_OPERATION_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'I', L'n', L'i', L't', L'i', L'a', L'l', L'i', L'z', L'e', L' ', L'o', L'p', L'e', L'r', L'a', L't', L'i', L'o', L'n', L'.'};
static wchar_t* INITIALIZE_OPERATION_MESSAGE_LOG_CYBOI_MODEL = INITIALIZE_OPERATION_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* INITIALIZE_OPERATION_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_21_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Finalise operation." message log cyboi model. */
static wchar_t FINALIZE_OPERATION_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'F', L'i', L'n', L'a', L'l', L'i', L'z', L'e', L' ', L'o', L'p', L'e', L'r', L'a', L't', L'i', L'o', L'n', L'.'};
static wchar_t* FINALIZE_OPERATION_MESSAGE_LOG_CYBOI_MODEL = FINALIZE_OPERATION_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* FINALIZE_OPERATION_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_19_INTEGER_STATE_CYBOI_MODEL_ARRAY;

//
// Signal memory log messages.
//

/** The "Create signal memory." message log cyboi model. */
static wchar_t CREATE_SIGNAL_MEMORY_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'C', L'r', L'e', L'a', L't', L'e', L' ', L's', L'i', L'g', L'n', L'a', L'l', L' ', L'm', L'e', L'm', L'o', L'r', L'y', L'.'};
static wchar_t* CREATE_SIGNAL_MEMORY_MESSAGE_LOG_CYBOI_MODEL = CREATE_SIGNAL_MEMORY_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* CREATE_SIGNAL_MEMORY_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_21_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Destroy signal memory." message log cyboi model. */
static wchar_t DESTROY_SIGNAL_MEMORY_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'D', L'e', L's', L't', L'r', L'o', L'y', L' ', L's', L'i', L'g', L'n', L'a', L'l', L' ', L'm', L'e', L'm', L'o', L'r', L'y', L'.'};
static wchar_t* DESTROY_SIGNAL_MEMORY_MESSAGE_LOG_CYBOI_MODEL = DESTROY_SIGNAL_MEMORY_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* DESTROY_SIGNAL_MEMORY_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_22_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Handle part." message log cyboi model. */
static wchar_t HANDLE_PART_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'H', L'a', L'n', L'd', L'l', L'e', L' ', L'p', L'a', L'r', L't', L'.'};
static wchar_t* HANDLE_PART_MESSAGE_LOG_CYBOI_MODEL = HANDLE_PART_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* HANDLE_PART_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_12_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Handle operation." message log cyboi model. */
static wchar_t HANDLE_OPERATION_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'H', L'a', L'n', L'd', L'l', L'e', L' ', L'o', L'p', L'e', L'r', L'a', L't', L'i', L'o', L'n', L'.'};
static wchar_t* HANDLE_OPERATION_MESSAGE_LOG_CYBOI_MODEL = HANDLE_OPERATION_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* HANDLE_OPERATION_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_17_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Set shutdown flag." message log cyboi model. */
static wchar_t SET_SHUTDOWN_FLAG_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'S', L'e', L't', L' ', L's', L'h', L'u', L't', L'd', L'o', L'w', L'n', L' ', L'f', L'l', L'a', L'g', L'.'};
static wchar_t* SET_SHUTDOWN_FLAG_MESSAGE_LOG_CYBOI_MODEL = SET_SHUTDOWN_FLAG_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* SET_SHUTDOWN_FLAG_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_18_INTEGER_STATE_CYBOI_MODEL_ARRAY;

//
// Cyboi log messages.
//

/** The "Check for signals." message log cyboi model. */
static wchar_t CHECK_FOR_SIGNALS_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'C', L'h', L'e', L'c', L'k', L' ', L'f', L'o', L'r', L' ', L's', L'i', L'g', L'n', L'a', L'l', L's', L'.'};
static wchar_t* CHECK_FOR_SIGNALS_MESSAGE_LOG_CYBOI_MODEL = CHECK_FOR_SIGNALS_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* CHECK_FOR_SIGNALS_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_17_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Could not handle signal. The signal type is unknown." message log cyboi model. */
static wchar_t COULD_NOT_HANDLE_SIGNAL_THE_SIGNAL_TYPE_IS_UNKNOWN_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'C', L'o', L'u', L'l', L'd', L' ', L'n', L'o', L't', L' ', L'h', L'a', L'n', L'd', L'l', L'e', L' ', L's', L'i', L'g', L'n', L'a', L'l', L'.', L' ', L'T', L'h', L'e', L' ', L's', L'i', L'g', L'n', L'a', L'l', L' ', L'a', L'b', L's', L't', L'r', L'a', L'c', L't', L'i', L'o', L'n', L' ', L'i', L's', L' ', L'u', L'n', L'k', L'n', L'o', L'w', L'n', L'.'};
static wchar_t* COULD_NOT_HANDLE_SIGNAL_THE_SIGNAL_TYPE_IS_UNKNOWN_MESSAGE_LOG_CYBOI_MODEL = COULD_NOT_HANDLE_SIGNAL_THE_SIGNAL_TYPE_IS_UNKNOWN_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* COULD_NOT_HANDLE_SIGNAL_THE_SIGNAL_TYPE_IS_UNKNOWN_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_59_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Could not check for signals. The internal is null." message log cyboi model. */
static wchar_t COULD_NOT_CHECK_FOR_SIGNALS_THE_INTERNAL_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'C', L'o', L'u', L'l', L'd', L' ', L'n', L'o', L't', L' ', L'c', L'h', L'e', L'c', L'k', L' ', L'f', L'o', L'r', L' ', L's', L'i', L'g', L'n', L'a', L'l', L's', L'.', L' ', L'T', L'h', L'e', L' ', L'i', L'n', L't', L'e', L'r', L'n', L'a', L'l', L' ', L'i', L's', L' ', L'n', L'u', L'l', L'l', L'.'};
static wchar_t* COULD_NOT_CHECK_FOR_SIGNALS_THE_INTERNAL_IS_NULL_MESSAGE_LOG_CYBOI_MODEL = COULD_NOT_CHECK_FOR_SIGNALS_THE_INTERNAL_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* COULD_NOT_CHECK_FOR_SIGNALS_THE_INTERNAL_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_50_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Exit CYBOI normally." message log cyboi model. */
static wchar_t EXIT_CYBOI_NORMALLY_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'E', L'x', L'i', L't', L' ', L'C', L'Y', L'B', L'O', L'I', L' ', L'n', L'o', L'r', L'm', L'a', L'l', L'l', L'y', L'.'};
static wchar_t* EXIT_CYBOI_NORMALLY_MESSAGE_LOG_CYBOI_MODEL = EXIT_CYBOI_NORMALLY_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* EXIT_CYBOI_NORMALLY_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_20_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The "Could not execute CYBOI. The command line argument vector is null." message log cyboi model. */
static wchar_t COULD_NOT_EXECUTE_CYBOI_THE_COMMAND_LINE_ARGUMENT_VECTOR_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY[] = {L'C', L'o', L'u', L'l', L'd', L' ', L'n', L'o', L't', L' ', L'e', L'x', L'e', L'c', L'u', L't', L'e', L' ', L'C', L'Y', L'B', L'O', L'I', L'.', L' ', L'T', L'h', L'e', L' ', L'c', L'o', L'm', L'm', L'a', L'n', L'd', L' ', L'l', L'i', L'n', L'e', L' ', L'a', L'r', L'g', L'u', L'm', L'e', L'n', L't', L' ', L'v', L'e', L'c', L't', L'o', L'r', L' ', L'i', L's', L' ', L'n', L'u', L'l', L'l', L'.'};
static wchar_t* COULD_NOT_EXECUTE_CYBOI_THE_COMMAND_LINE_ARGUMENT_VECTOR_IS_NULL_MESSAGE_LOG_CYBOI_MODEL = COULD_NOT_EXECUTE_CYBOI_THE_COMMAND_LINE_ARGUMENT_VECTOR_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_ARRAY;
static int* COULD_NOT_EXECUTE_CYBOI_THE_COMMAND_LINE_ARGUMENT_VECTOR_IS_NULL_MESSAGE_LOG_CYBOI_MODEL_COUNT = NUMBER_66_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* MESSAGE_LOG_CYBOI_MODEL_CONSTANT_SOURCE */
#endif
