/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.15.0 2013-09-22
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef INDICATE_ACCESS_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define INDICATE_ACCESS_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The result indicate access logic cybol name. */
static wchar_t RESULT_INDICATE_ACCESS_LOGIC_CYBOL_NAME_ARRAY[] = {L'r', L'e', L's', L'u', L'l', L't'};
static wchar_t* RESULT_INDICATE_ACCESS_LOGIC_CYBOL_NAME = RESULT_INDICATE_ACCESS_LOGIC_CYBOL_NAME_ARRAY;
static int* RESULT_INDICATE_ACCESS_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The part indicate access logic cybol name. */
static wchar_t PART_INDICATE_ACCESS_LOGIC_CYBOL_NAME_ARRAY[] = {L'p', L'a', L'r', L't'};
static wchar_t* PART_INDICATE_ACCESS_LOGIC_CYBOL_NAME = PART_INDICATE_ACCESS_LOGIC_CYBOL_NAME_ARRAY;
static int* PART_INDICATE_ACCESS_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* INDICATE_ACCESS_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif
