/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.15.0 2013-09-22
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef COMPARISON_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define COMPARISON_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The result comparison logic cybol name. */
static wchar_t RESULT_COMPARISON_LOGIC_CYBOL_NAME_ARRAY[] = {L'r', L'e', L's', L'u', L'l', L't'};
static wchar_t* RESULT_COMPARISON_LOGIC_CYBOL_NAME = RESULT_COMPARISON_LOGIC_CYBOL_NAME_ARRAY;
static int* RESULT_COMPARISON_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The left comparison logic cybol name. */
static wchar_t LEFT_COMPARISON_LOGIC_CYBOL_NAME_ARRAY[] = {L'l', L'e', L'f', L't'};
static wchar_t* LEFT_COMPARISON_LOGIC_CYBOL_NAME = LEFT_COMPARISON_LOGIC_CYBOL_NAME_ARRAY;
static int* LEFT_COMPARISON_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The right comparison logic cybol name. */
static wchar_t RIGHT_COMPARISON_LOGIC_CYBOL_NAME_ARRAY[] = {L'r', L'i', L'g', L'h', L't'};
static wchar_t* RIGHT_COMPARISON_LOGIC_CYBOL_NAME = RIGHT_COMPARISON_LOGIC_CYBOL_NAME_ARRAY;
static int* RIGHT_COMPARISON_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The type comparison logic cybol name. */
static wchar_t TYPE_COMPARISON_LOGIC_CYBOL_NAME_ARRAY[] = {L't', L'y', L'p', L'e'};
static wchar_t* TYPE_COMPARISON_LOGIC_CYBOL_NAME = TYPE_COMPARISON_LOGIC_CYBOL_NAME_ARRAY;
static int* TYPE_COMPARISON_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The selection comparison logic cybol name. */
static wchar_t SELECTION_COMPARISON_LOGIC_CYBOL_NAME_ARRAY[] = {L's', L'e', L'l', L'e', L'c', L't', L'i', L'o', L'n'};
static wchar_t* SELECTION_COMPARISON_LOGIC_CYBOL_NAME = SELECTION_COMPARISON_LOGIC_CYBOL_NAME_ARRAY;
static int* SELECTION_COMPARISON_LOGIC_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* COMPARISON_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif
