/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.15.0 2013-09-22
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef GUI_STATE_CYBOL_NAME_CONSTANT_SOURCE
#define GUI_STATE_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The background gui state cybol name. */
static wchar_t BACKGROUND_GUI_STATE_CYBOL_NAME_ARRAY[] = {L'b', L'a', L'c', L'k', L'g', L'r', L'o', L'u', L'n', L'd'};
static wchar_t* BACKGROUND_GUI_STATE_CYBOL_NAME = BACKGROUND_GUI_STATE_CYBOL_NAME_ARRAY;
static int* BACKGROUND_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_10_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The cell gui state cybol name. */
static wchar_t CELL_GUI_STATE_CYBOL_NAME_ARRAY[] = {L'c', L'e', L'l', L'l'};
static wchar_t* CELL_GUI_STATE_CYBOL_NAME = CELL_GUI_STATE_CYBOL_NAME_ARRAY;
static int* CELL_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The foreground gui state cybol name. */
static wchar_t FOREGROUND_GUI_STATE_CYBOL_NAME_ARRAY[] = {L'f', L'o', L'r', L'e', L'g', L'r', L'o', L'u', L'n', L'd'};
static wchar_t* FOREGROUND_GUI_STATE_CYBOL_NAME = FOREGROUND_GUI_STATE_CYBOL_NAME_ARRAY;
static int* FOREGROUND_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_10_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The icon gui state cybol name. */
static wchar_t ICON_GUI_STATE_CYBOL_NAME_ARRAY[] = {L'i', L'c', L'o', L'n'};
static wchar_t* ICON_GUI_STATE_CYBOL_NAME = ICON_GUI_STATE_CYBOL_NAME_ARRAY;
static int* ICON_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The layout gui state cybol name. */
static wchar_t LAYOUT_GUI_STATE_CYBOL_NAME_ARRAY[] = {L'l', L'a', L'y', L'o', L'u', L't'};
static wchar_t* LAYOUT_GUI_STATE_CYBOL_NAME = LAYOUT_GUI_STATE_CYBOL_NAME_ARRAY;
static int* LAYOUT_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The position gui state cybol name. */
static wchar_t POSITION_GUI_STATE_CYBOL_NAME_ARRAY[] = {L'p', L'o', L's', L'i', L't', L'i', L'o', L'n'};
static wchar_t* POSITION_GUI_STATE_CYBOL_NAME = POSITION_GUI_STATE_CYBOL_NAME_ARRAY;
static int* POSITION_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The size gui state cybol name. */
static wchar_t SIZE_GUI_STATE_CYBOL_NAME_ARRAY[] = {L's', L'i', L'z', L'e'};
static wchar_t* SIZE_GUI_STATE_CYBOL_NAME = SIZE_GUI_STATE_CYBOL_NAME_ARRAY;
static int* SIZE_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The title gui state cybol name. */
static wchar_t TITLE_GUI_STATE_CYBOL_NAME_ARRAY[] = {L't', L'i', L't', L'l', L'e'};
static wchar_t* TITLE_GUI_STATE_CYBOL_NAME = TITLE_GUI_STATE_CYBOL_NAME_ARRAY;
static int* TITLE_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The window gui state cybol name. */
static wchar_t WINDOW_GUI_STATE_CYBOL_NAME_ARRAY[] = {L'w', L'i', L'n', L'd', L'o', L'w'};
static wchar_t* WINDOW_GUI_STATE_CYBOL_NAME = WINDOW_GUI_STATE_CYBOL_NAME_ARRAY;
static int* WINDOW_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* GUI_STATE_CYBOL_NAME_CONSTANT_SOURCE */
#endif
