/*
 * Copyright (C) 1999-2013. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.15.0 2013-09-22
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef OFFSET_VALUE_MANIPULATOR_SOURCE
#define OFFSET_VALUE_MANIPULATOR_SOURCE

#include "../../constant/model/cyboi/log/level_log_cyboi_model.c"
#include "../../constant/model/cyboi/log/message_log_cyboi_model.c"
#include "../../executor/manipulator/value_manipulator.c"
#include "../../logger/logger.c"

/**
 * Manipulates the bit at the given position.
 * Uses the given index to calculate an offset.
 *
 * @param p0 the value
 * @param p1 the bit position
 * @param p2 the operation type
 * @param p3 the operand type
 * @param p4 the index
 */
void manipulate_value_offset(void* p0, void* p1, void* p2, void* p3, void* p4) {

    log_message_terminated((void*) DEBUG_LEVEL_LOG_CYBOI_MODEL, (void*) L"Manipulate value offset.");

    // The value.
    // CAUTION! It HAS TO BE initialised with p0,
    // since an offset is added below.
    void* v = p0;

    // Add offset to value.
    add_offset((void*) &v, p3, p4);

    // Manipulate value.
    manipulate_value(v, p1, p2, p3);
}

/* OFFSET_VALUE_MANIPULATOR_SOURCE */
#endif
