/*
 * Copyright (C) 1999-2014. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.16.0 2014-03-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef CAST_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define CAST_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The destination cast logic cybol name. */
static wchar_t DESTINATION_CAST_LOGIC_CYBOL_NAME_ARRAY[] = {L'd', L'e', L's', L't', L'i', L'n', L'a', L't', L'i', L'o', L'n'};
static wchar_t* DESTINATION_CAST_LOGIC_CYBOL_NAME = DESTINATION_CAST_LOGIC_CYBOL_NAME_ARRAY;
static int* DESTINATION_CAST_LOGIC_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The source cast logic cybol name. */
static wchar_t SOURCE_CAST_LOGIC_CYBOL_NAME_ARRAY[] = {L's', L'o', L'u', L'r', L'c', L'e'};
static wchar_t* SOURCE_CAST_LOGIC_CYBOL_NAME = SOURCE_CAST_LOGIC_CYBOL_NAME_ARRAY;
static int* SOURCE_CAST_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The type cast logic cybol name. */
static wchar_t TYPE_CAST_LOGIC_CYBOL_NAME_ARRAY[] = {L't', L'y', L'p', L'e'};
static wchar_t* TYPE_CAST_LOGIC_CYBOL_NAME = TYPE_CAST_LOGIC_CYBOL_NAME_ARRAY;
static int* TYPE_CAST_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* CAST_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif
