/*
 * Copyright (C) 1999-2014. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.16.0 2014-03-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/**
 * The path for the word count file logic cybol name.
 *
 * It indicates the path of a file for word count
 */
static wchar_t PATH_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'p', L'a', L't', 'h'};
static wchar_t* PATH_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME = PATH_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* PATH_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The byte option for word count file logic cybol name.
 *
 * It outputs the number of bytes
 */
static wchar_t BYTE_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'b', L'y', L't', L'e', L's'};
static wchar_t* BYTE_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME = BYTE_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* BYTE_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The char option for word count file logic cybol name.
 *
 * It outputs the number of chars
 */
static wchar_t CHAR_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'c', L'h', L'a', L'r', L's'};
static wchar_t* CHAR_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME = CHAR_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* CHAR_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The line option for word count file logic cybol name.
 *
 * It outputs the number of lines
 */
static wchar_t LINE_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'l', L'i', L'n', L'e', L's'};
static wchar_t* LINE_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME = LINE_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* LINE_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The max-line-length option for word count file logic cybol name.
 *
 * It outputs the length of the longest line
 */
static wchar_t MAX_LINE_LENGTH_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'm', L'a', L'x', L'-', L'l', L'i', L'n', L'e', L'-', L'l',L'e', L'n', L'g', L't', L'h'};
static wchar_t* MAX_LINE_LENGTH_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME = MAX_LINE_LENGTH_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* MAX_LINE_LENGTH_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_15_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The word option for word count file logic cybol name.
 *
 * It outputs the number of words
 */
static wchar_t WORD_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'w', L'o', L'r', L'd', L's'};
static wchar_t* WORD_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME = WORD_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* WORD_WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* WORD_COUNT_FILE_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif
 
