/*
 * Copyright (C) 1999-2014. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.16.0 2014-03-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The channel startup maintenance logic cybol name. */
static wchar_t CHANNEL_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_ARRAY[] = {L'c', L'h', L'a', L'n', L'n', L'e', L'l'};
static wchar_t* CHANNEL_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME = CHANNEL_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_ARRAY;
static int* CHANNEL_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The filename serial port startup maintenance logic cybol name. */
static wchar_t FILENAME_SERIAL_PORT_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_ARRAY[] = {L'f', L'i', L'l', L'e', L'n', L'a', L'm', L'e'};
static wchar_t* FILENAME_SERIAL_PORT_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME = FILENAME_SERIAL_PORT_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_ARRAY;
static int* FILENAME_SERIAL_PORT_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The baudrate serial port startup maintenance logic cybol name. */
static wchar_t BAUDRATE_SERIAL_PORT_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_ARRAY[] = {L'b', L'a', L'u', L'd', L'r', L'a', L't', L'e'};
static wchar_t* BAUDRATE_SERIAL_PORT_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME = BAUDRATE_SERIAL_PORT_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_ARRAY;
static int* BAUDRATE_SERIAL_PORT_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The namespace socket startup maintenance logic cybol name. */
static wchar_t NAMESPACE_SOCKET_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_ARRAY[] = {L'n', L'a', L'm', L'e', L's', L'p', L'a', L'c', L'e'};
static wchar_t* NAMESPACE_SOCKET_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME = NAMESPACE_SOCKET_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_ARRAY;
static int* NAMESPACE_SOCKET_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The style socket startup maintenance logic cybol name. */
static wchar_t STYLE_SOCKET_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_ARRAY[] = {L's', L't', L'y', L'l', L'e'};
static wchar_t* STYLE_SOCKET_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME = STYLE_SOCKET_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_ARRAY;
static int* STYLE_SOCKET_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The address socket startup maintenance logic cybol name. */
static wchar_t ADDRESS_SOCKET_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_ARRAY[] = {L'a', L'd', L'd', L'r', L'e', L's', L's'};
static wchar_t* ADDRESS_SOCKET_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME = ADDRESS_SOCKET_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_ARRAY;
static int* ADDRESS_SOCKET_STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* STARTUP_MAINTENANCE_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif
