/*
 * Copyright (C) 1999-2014. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.16.0 2014-03-31
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef EVENT_GUI_STATE_CYBOL_NAME_CONSTANT_SOURCE
#define EVENT_GUI_STATE_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The enter-notify event gui state cybol name. */
static wchar_t ENTER_NOTIFY_EVENT_GUI_STATE_CYBOL_NAME_ARRAY[] = {L'e', L'n', L't', L'e', L'r', L'-', L'n', L'o', L't', L'i', L'f', L'y'};
static wchar_t* ENTER_NOTIFY_EVENT_GUI_STATE_CYBOL_NAME = ENTER_NOTIFY_EVENT_GUI_STATE_CYBOL_NAME_ARRAY;
static int* ENTER_NOTIFY_EVENT_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_12_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The expose event gui state cybol name. */
static wchar_t EXPOSE_EVENT_GUI_STATE_CYBOL_NAME_ARRAY[] = {L'e', L'x', L'p', L'o', L's', L'e'};
static wchar_t* EXPOSE_EVENT_GUI_STATE_CYBOL_NAME = EXPOSE_EVENT_GUI_STATE_CYBOL_NAME_ARRAY;
static int* EXPOSE_EVENT_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The leave-notify event gui state cybol name. */
static wchar_t LEAVE_NOTIFY_EVENT_GUI_STATE_CYBOL_NAME_ARRAY[] = {L'l', L'e', L'a', L'v', L'e', L'-', L'n', L'o', L't', L'i', L'f', L'y'};
static wchar_t* LEAVE_NOTIFY_EVENT_GUI_STATE_CYBOL_NAME = LEAVE_NOTIFY_EVENT_GUI_STATE_CYBOL_NAME_ARRAY;
static int* LEAVE_NOTIFY_EVENT_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_12_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* EVENT_GUI_STATE_CYBOL_NAME_CONSTANT_SOURCE */
#endif
