/*
 * Copyright (C) 1999-2015. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.17.0 2015-04-20
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The destination overwrite modification logic cybol name. */
static wchar_t DESTINATION_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'd', L'e', L's', L't', L'i', L'n', L'a', L't', L'i', L'o', L'n'};
static wchar_t* DESTINATION_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME = DESTINATION_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* DESTINATION_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The source overwrite modification logic cybol name. */
static wchar_t SOURCE_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L's', L'o', L'u', L'r', L'c', L'e'};
static wchar_t* SOURCE_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME = SOURCE_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* SOURCE_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The type overwrite modification logic cybol name. */
static wchar_t TYPE_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L't', L'y', L'p', L'e'};
static wchar_t* TYPE_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME = TYPE_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* TYPE_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The count overwrite modification logic cybol name. */
static wchar_t COUNT_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'c', L'o', L'u', L'n', L't'};
static wchar_t* COUNT_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME = COUNT_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* COUNT_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The destination_index overwrite modification logic cybol name. */
static wchar_t DESTINATION_INDEX_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'd', L'e', L's', L't', L'i', L'n', L'a', L't', L'i', L'o', L'n', L'_', L'i', L'n', L'd', L'e', L'x'};
static wchar_t* DESTINATION_INDEX_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME = DESTINATION_INDEX_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* DESTINATION_INDEX_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_17_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The source_index overwrite modification logic cybol name. */
static wchar_t SOURCE_INDEX_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L's', L'o', L'u', L'r', L'c', L'e', L'_', L'i', L'n', L'd', L'e', L'x'};
static wchar_t* SOURCE_INDEX_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME = SOURCE_INDEX_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* SOURCE_INDEX_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_12_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The adjust overwrite modification logic cybol name. */
static wchar_t ADJUST_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_ARRAY[] = {L'a', L'd', L'j', L'u', L's', L't'};
static wchar_t* ADJUST_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME = ADJUST_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_ARRAY;
static int* ADJUST_OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* OVERWRITE_MODIFICATION_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif
