/*
 * Copyright (C) 1999-2015. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.17.0 2015-04-20
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef TUI_STATE_CYBOL_NAME_CONSTANT_SOURCE
#define TUI_STATE_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The background tui state cybol name. */
static wchar_t BACKGROUND_TUI_STATE_CYBOL_NAME_ARRAY[] = {L'b', L'a', L'c', L'k', L'g', L'r', L'o', L'u', L'n', L'd'};
static wchar_t* BACKGROUND_TUI_STATE_CYBOL_NAME = BACKGROUND_TUI_STATE_CYBOL_NAME_ARRAY;
static int* BACKGROUND_TUI_STATE_CYBOL_NAME_COUNT = NUMBER_10_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The blink tui state cybol name. */
static wchar_t BLINK_TUI_STATE_CYBOL_NAME_ARRAY[] = {L'b', L'l', L'i', L'n', L'k'};
static wchar_t* BLINK_TUI_STATE_CYBOL_NAME = BLINK_TUI_STATE_CYBOL_NAME_ARRAY;
static int* BLINK_TUI_STATE_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The bold tui state cybol name. */
static wchar_t BOLD_TUI_STATE_CYBOL_NAME_ARRAY[] = {L'b', L'o', L'l', L'd'};
static wchar_t* BOLD_TUI_STATE_CYBOL_NAME = BOLD_TUI_STATE_CYBOL_NAME_ARRAY;
static int* BOLD_TUI_STATE_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The border tui state cybol name. */
static wchar_t BORDER_TUI_STATE_CYBOL_NAME_ARRAY[] = {L'b', L'o', L'r', L'd', L'e', L'r'};
static wchar_t* BORDER_TUI_STATE_CYBOL_NAME = BORDER_TUI_STATE_CYBOL_NAME_ARRAY;
static int* BORDER_TUI_STATE_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The foreground tui state cybol name. */
static wchar_t FOREGROUND_TUI_STATE_CYBOL_NAME_ARRAY[] = {L'f', L'o', L'r', L'e', L'g', L'r', L'o', L'u', L'n', L'd'};
static wchar_t* FOREGROUND_TUI_STATE_CYBOL_NAME = FOREGROUND_TUI_STATE_CYBOL_NAME_ARRAY;
static int* FOREGROUND_TUI_STATE_CYBOL_NAME_COUNT = NUMBER_10_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The hidden tui state cybol name. */
static wchar_t HIDDEN_TUI_STATE_CYBOL_NAME_ARRAY[] = {L'h', L'i', L'd', L'd', L'e', L'n'};
static wchar_t* HIDDEN_TUI_STATE_CYBOL_NAME = HIDDEN_TUI_STATE_CYBOL_NAME_ARRAY;
static int* HIDDEN_TUI_STATE_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The intense tui state cybol name. */
static wchar_t INTENSE_TUI_STATE_CYBOL_NAME_ARRAY[] = {L'i', L'n', L't', L'e', L'n', L's', L'e'};
static wchar_t* INTENSE_TUI_STATE_CYBOL_NAME = INTENSE_TUI_STATE_CYBOL_NAME_ARRAY;
static int* INTENSE_TUI_STATE_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The inverse tui state cybol name. */
static wchar_t INVERSE_TUI_STATE_CYBOL_NAME_ARRAY[] = {L'i', L'n', L'v', L'e', L'r', L's', L'e'};
static wchar_t* INVERSE_TUI_STATE_CYBOL_NAME = INVERSE_TUI_STATE_CYBOL_NAME_ARRAY;
static int* INVERSE_TUI_STATE_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The position tui state cybol name. */
static wchar_t POSITION_TUI_STATE_CYBOL_NAME_ARRAY[] = {L'p', L'o', L's', L'i', L't', L'i', L'o', L'n'};
static wchar_t* POSITION_TUI_STATE_CYBOL_NAME = POSITION_TUI_STATE_CYBOL_NAME_ARRAY;
static int* POSITION_TUI_STATE_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The size tui state cybol name. */
static wchar_t SIZE_TUI_STATE_CYBOL_NAME_ARRAY[] = {L's', L'i', L'z', L'e'};
static wchar_t* SIZE_TUI_STATE_CYBOL_NAME = SIZE_TUI_STATE_CYBOL_NAME_ARRAY;
static int* SIZE_TUI_STATE_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The underline tui state cybol name. */
static wchar_t UNDERLINE_TUI_STATE_CYBOL_NAME_ARRAY[] = {L'u', L'n', L'd', L'e', L'r', L'l', L'i', L'n', L'e'};
static wchar_t* UNDERLINE_TUI_STATE_CYBOL_NAME = UNDERLINE_TUI_STATE_CYBOL_NAME_ARRAY;
static int* UNDERLINE_TUI_STATE_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* TUI_STATE_CYBOL_NAME_CONSTANT_SOURCE */
#endif
