/*
 * Copyright (C) 1999-2015. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.17.0 2015-04-20
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef PROCESS_TYPE_SIZE_GLOBALISER_SOURCE
#define PROCESS_TYPE_SIZE_GLOBALISER_SOURCE

#include <sys/types.h>

#include "../../../variable/type_size/process_type_size.c"

#ifdef _MSC_VER
    #include "../../../windows/cyboi_win_mapper.h"
#else
    #include <unistd.h>
#endif

/**
 * Initialises process type size global variables.
 */
void globalise_type_size_process() {

    *IDENTIFICATION_PROCESS_TYPE_SIZE = sizeof (pid_t);
}

/* PROCESS_TYPE_SIZE_GLOBALISER_SOURCE */
#endif
