/*
 * Copyright (C) 1999-2016. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.18.0 2016-12-21
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef HOSTNAME_SOURCE
#define HOSTNAME_SOURCE

#include "../../constant/model/cyboi/log/level_log_cyboi_model.c"
#include "../../constant/model/cyboi/log/message_log_cyboi_model.c"
#include "../../constant/model/cyboi/state/integer_state_cyboi_model.c"
#include "../../constant/model/cyboi/state/pointer_state_cyboi_model.c"
#include "../../constant/name/cybol/logic/commander/hostname_commander_logic_cybol_name.c"
#include "../../constant/type/cyboi/state_cyboi_type.c"
#include "../../executor/accessor/getter/part/name_part_getter.c"
#include "../../executor/commander/hostname_commander.c"
#include "../../logger/logger.c"

#ifndef _MSC_VER
    #include <unistd.h>
#endif

/**
 * shows the hostname
 *
 * Expected parametres:
 * - none
 * 
 * Options: d, f, i, I, s
 *
 * Constraints:
 * @param p0 the parametres data
 * @param p1 the parametres count
 * @param p2 the knowledge memory part
 */
void apply_hostname(void* p0, void* p1, void* p2, void* p3) {

       log_message_terminated((void*) INFORMATION_LEVEL_LOG_CYBOI_MODEL, (void*) L"Apply hostname.");

    // The dns part.
    void* d = *NULL_POINTER_STATE_CYBOI_MODEL;
    // The fqdn part.
    void* f = *NULL_POINTER_STATE_CYBOI_MODEL;
    // The ip part.
    void* i = *NULL_POINTER_STATE_CYBOI_MODEL;
    // The allip part.
    void* a = *NULL_POINTER_STATE_CYBOI_MODEL;
    // The short part.
    void* s = *NULL_POINTER_STATE_CYBOI_MODEL;

    // The dns part model item.
    void* dm = *NULL_POINTER_STATE_CYBOI_MODEL;
    // The fqdn part model item.
    void* fm = *NULL_POINTER_STATE_CYBOI_MODEL;
    // The ip part model item.
    void* im = *NULL_POINTER_STATE_CYBOI_MODEL;
    // The allip part model item.
    void* am = *NULL_POINTER_STATE_CYBOI_MODEL;
    // The short part model item.
    void* sm = *NULL_POINTER_STATE_CYBOI_MODEL;



    // The dns part model item data and count.
    void* dmd = *NULL_POINTER_STATE_CYBOI_MODEL;
    // The fqdn part model item data and count.
    void* fmd = *NULL_POINTER_STATE_CYBOI_MODEL;
    // The ip part model item data and count.
    void* imd = *NULL_POINTER_STATE_CYBOI_MODEL;
    // The allip part model item data and count.
    void* amd = *NULL_POINTER_STATE_CYBOI_MODEL;
    // The short part model item data and count.
    void* smd = *NULL_POINTER_STATE_CYBOI_MODEL;


    // Get dns part.
    get_part_name((void*) &d, p0, (void*) DNS_HOSTNAME_COMMANDER_LOGIC_CYBOL_NAME, (void*) DNS_HOSTNAME_COMMANDER_LOGIC_CYBOL_NAME_COUNT, p1, p2, p3);
    // Get fqdn part.
    get_part_name((void*) &f, p0, (void*) FQDN_HOSTNAME_COMMANDER_LOGIC_CYBOL_NAME, (void*) FQDN_HOSTNAME_COMMANDER_LOGIC_CYBOL_NAME_COUNT, p1, p2, p3);
    // Get ip part.
    get_part_name((void*) &i, p0, (void*) IP_HOSTNAME_COMMANDER_LOGIC_CYBOL_NAME, (void*) IP_HOSTNAME_COMMANDER_LOGIC_CYBOL_NAME_COUNT, p1, p2, p3);
    // Get allip part.
    get_part_name((void*) &a, p0, (void*) ALLIP_HOSTNAME_COMMANDER_LOGIC_CYBOL_NAME, (void*) ALLIP_HOSTNAME_COMMANDER_LOGIC_CYBOL_NAME_COUNT, p1, p2, p3);
    // Get short part.
    get_part_name((void*) &s, p0, (void*) SHORT_HOSTNAME_COMMANDER_LOGIC_CYBOL_NAME, (void*) SHORT_HOSTNAME_COMMANDER_LOGIC_CYBOL_NAME_COUNT, p1, p2, p3);

    // Get dns part model item.
    copy_array_forward((void*) &dm, d, (void*) POINTER_STATE_CYBOI_TYPE, (void*) PRIMITIVE_STATE_CYBOI_MODEL_COUNT, (void*) VALUE_PRIMITIVE_STATE_CYBOI_NAME, (void*) MODEL_PART_STATE_CYBOI_NAME);
    // Get fqdn part model item.
    copy_array_forward((void*) &fm, f, (void*) POINTER_STATE_CYBOI_TYPE, (void*) PRIMITIVE_STATE_CYBOI_MODEL_COUNT, (void*) VALUE_PRIMITIVE_STATE_CYBOI_NAME, (void*) MODEL_PART_STATE_CYBOI_NAME);
    // Get ip part model item.
    copy_array_forward((void*) &im, i, (void*) POINTER_STATE_CYBOI_TYPE, (void*) PRIMITIVE_STATE_CYBOI_MODEL_COUNT, (void*) VALUE_PRIMITIVE_STATE_CYBOI_NAME, (void*) MODEL_PART_STATE_CYBOI_NAME);
    // Get allip part model item.
    copy_array_forward((void*) &am, a, (void*) POINTER_STATE_CYBOI_TYPE, (void*) PRIMITIVE_STATE_CYBOI_MODEL_COUNT, (void*) VALUE_PRIMITIVE_STATE_CYBOI_NAME, (void*) MODEL_PART_STATE_CYBOI_NAME);
    // Get short part model item.
    copy_array_forward((void*) &sm, s, (void*) POINTER_STATE_CYBOI_TYPE, (void*) PRIMITIVE_STATE_CYBOI_MODEL_COUNT, (void*) VALUE_PRIMITIVE_STATE_CYBOI_NAME, (void*) MODEL_PART_STATE_CYBOI_NAME);

    // Get path part model item data and count.
    copy_array_forward((void*) &dmd, dm, (void*) POINTER_STATE_CYBOI_TYPE, (void*) PRIMITIVE_STATE_CYBOI_MODEL_COUNT, (void*) VALUE_PRIMITIVE_STATE_CYBOI_NAME, (void*) DATA_ITEM_STATE_CYBOI_NAME);
    // Get reference part model item data and count.
    copy_array_forward((void*) &fmd, fm, (void*) POINTER_STATE_CYBOI_TYPE, (void*) PRIMITIVE_STATE_CYBOI_MODEL_COUNT, (void*) VALUE_PRIMITIVE_STATE_CYBOI_NAME, (void*) DATA_ITEM_STATE_CYBOI_NAME);
    // Get timestamp part model item data and count.
    copy_array_forward((void*) &imd, im, (void*) POINTER_STATE_CYBOI_TYPE, (void*) PRIMITIVE_STATE_CYBOI_MODEL_COUNT, (void*) VALUE_PRIMITIVE_STATE_CYBOI_NAME, (void*) DATA_ITEM_STATE_CYBOI_NAME);
    // Get timestamp part model item data and count.
    copy_array_forward((void*) &amd, am, (void*) POINTER_STATE_CYBOI_TYPE, (void*) PRIMITIVE_STATE_CYBOI_MODEL_COUNT, (void*) VALUE_PRIMITIVE_STATE_CYBOI_NAME, (void*) DATA_ITEM_STATE_CYBOI_NAME);
    // Get timestamp part model item data and count.
    copy_array_forward((void*) &smd, sm, (void*) POINTER_STATE_CYBOI_TYPE, (void*) PRIMITIVE_STATE_CYBOI_MODEL_COUNT, (void*) VALUE_PRIMITIVE_STATE_CYBOI_NAME, (void*) DATA_ITEM_STATE_CYBOI_NAME);

    command_hostname(dmd, fmd, imd, amd, smd);
}


/* HOSTNAME_SOURCE */
#endif
