/*
 * Copyright (C) 1999-2016. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.18.0 2016-12-21
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef BOOLEAN_STATE_CYBOL_MODEL_CONSTANT_SOURCE
#define BOOLEAN_STATE_CYBOL_MODEL_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The false boolean state cybol model. */
static wchar_t FALSE_BOOLEAN_STATE_CYBOL_MODEL_ARRAY[] = {L'f', L'a', L'l', L's', L'e'};
static wchar_t* FALSE_BOOLEAN_STATE_CYBOL_MODEL = FALSE_BOOLEAN_STATE_CYBOL_MODEL_ARRAY;
static int* FALSE_BOOLEAN_STATE_CYBOL_MODEL_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The true boolean state cybol model. */
static wchar_t TRUE_BOOLEAN_STATE_CYBOL_MODEL_ARRAY[] = {L't', L'r', L'u', L'e'};
static wchar_t* TRUE_BOOLEAN_STATE_CYBOL_MODEL = TRUE_BOOLEAN_STATE_CYBOL_MODEL_ARRAY;
static int* TRUE_BOOLEAN_STATE_CYBOL_MODEL_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* BOOLEAN_STATE_CYBOL_MODEL_CONSTANT_SOURCE */
#endif
