/*
 * Copyright (C) 1999-2016. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.18.0 2016-12-21
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The path_1 parameter for the compare files logic in cybol. */
static wchar_t PATH_1_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'p', L'a', L't', L'h', L'1'};
static wchar_t* PATH_1_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME = PATH_1_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* PATH_1_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The path_2 parameter for the compare files logic in cybol. */
static wchar_t PATH_2_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'p', L'a', L't', L'h', L'2'};
static wchar_t* PATH_2_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME = PATH_2_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* PATH_2_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The print differing chars option for the compare files logic in cybol. */
static wchar_t PRINT_DIFFERING_CHARS_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'p', L'r', L'i', L'n', L't', L'-', L'd', L'i', L'f', L'f', L'e', L'r', L'i', L'n', L'g', L'-', L'c', L'h', L'a', L'r', L's'};
static wchar_t* PRINT_DIFFERING_CHARS_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME = PRINT_DIFFERING_CHARS_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* PRINT_DIFFERING_CHARS_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_21_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The print offset option for the compare files logic in cybol. */
static wchar_t PRINT_OFFSET_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'p', L'r', L'i', L'n', L't', L'-', L'o', L'f', L'f', L's', L'e', L't'};
static wchar_t* PRINT_OFFSET_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME = PRINT_OFFSET_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* PRINT_OFFSET_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_12_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The print nothing option for the compare files logic in cybol. */
static wchar_t SILENT_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L's', L'i', L'l', L'e', L'n', L't'};
static wchar_t* SILENT_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME = SILENT_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* SILENT_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;


/** The Case insensitive option for the compare files logic in cybol. */
static wchar_t CASE_INSENSITIVE_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'c', L'a', L's', L'e', L'-', L'i', L'n', L's', L'e', L'n', L's', L'i', L't', L'i', L'v', L'e'};
static wchar_t* CASE_INSENSITIVE_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME = CASE_INSENSITIVE_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* CASE_INSENSITIVE_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_16_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The compare unicode option for the compare files logic in cybol. */
static wchar_t UNICODE_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'u', L'n', L'i', L'c', L'o', L'd', L'e'};
static wchar_t* UNICODE_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME = UNICODE_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* UNICODE_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The compare ascii option for the compare files logic in cybol. */
static wchar_t ASCII_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'a', L's', L'c', L'i', L'i'};
static wchar_t* ASCII_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME = ASCII_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* ASCII_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The display line numbers option for the compare files logic in cybol. */
static wchar_t DISPLAY_LINE_NUMBERS_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'l', L'i', L'n', L'e', L'-', L'n', L'u', L'm', L'b', L'e', L'r', L's'};
static wchar_t* DISPLAY_LINE_NUMBERS_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME = DISPLAY_LINE_NUMBERS_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* DISPLAY_LINE_NUMBERS_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_12_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The compress whitespace option for the compare files logic in cybol. */
static wchar_t COMPRESS_WHITESPACE_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'c', L'o', L'm', L'p', L'r', L'e', L's', L's', L'-', L'w', L'h', L'i', L't', L'e', L's', L'p', L'a', L'c', L'e'};
static wchar_t* COMPRESS_WHITESPACE_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME = COMPRESS_WHITESPACE_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* COMPRESS_WHITESPACE_COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_19_INTEGER_STATE_CYBOI_MODEL_ARRAY;


/* COMPARE_FILES_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif
 
 
