/*
 * Copyright (C) 1999-2016. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.18.0 2016-12-21
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The list uid option for the list open files logic in cybol. */
static wchar_t LIST_UID_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'l', L'i', L's', L't', L'u', L'i', L'd'};
static wchar_t* LIST_UID_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME = LIST_UID_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* LIST_UID_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The list file size option for the list open files logic in cybol. */
static wchar_t LIST_FILE_SIZE_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'l', L'i', L's', L't', L'f', L'i', L'l', L'e', L's', L'i', L'z', L'e'};
static wchar_t* LIST_FILE_SIZE_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME = LIST_FILE_SIZE_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* LIST_FILE_SIZE_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_12_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The list tasks for the list open files logic in cybol. */
static wchar_t LIST_TASKS_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'l', L'i', L's', L't', L't', L'a', L's', L'k', L's'};
static wchar_t* LIST_TASKS_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME = LIST_TASKS_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* LIST_TASKS_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The disable tcp option for the list open files logic in cybol. */
static wchar_t DISABLE_TCP_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'd', L'i', L's', L'a', L'b', L'l', L'e', L't', L'c', L'p'};
static wchar_t* DISABLE_TCP_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME = DISABLE_TCP_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* DISABLE_TCP_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_10_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The terse listing option for the list open files logic in cybol. */
static wchar_t TERSE_LISTING_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L't', L'e', L'r', L's', L'e', L'l', L'i', L's', L't', L'i', L'n', L'g'};
static wchar_t* TERSE_LISTING_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME = TERSE_LISTING_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* TERSE_LISTING_LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_12_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* LIST_OPEN_FILES_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif

