/*
 * Copyright (C) 1999-2016. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.18.0 2016-12-21
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef PWD_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define PWD_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The logical option for the present working directory logic in cybol. */
static wchar_t LOGICAL_PWD_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'l', L'o', L'g', L'i', L'c', L'a', L'l'};
static wchar_t* LOGICAL_PWD_COMMANDER_LOGIC_CYBOL_NAME = LOGICAL_PWD_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* LOGICAL_PWD_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The physical option for the present working directory logic in cybol. */
static wchar_t PHYSICAL_PWD_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'p', L'h', L'y', L's', L'i', L'c', L'a', L'l'};
static wchar_t* PHYSICAL_PWD_COMMANDER_LOGIC_CYBOL_NAME = PHYSICAL_PWD_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* PHYSICAL_PWD_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* PWD_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif

