/*
 * Copyright (C) 1999-2016. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.18.0 2016-12-21
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The path parameter for the spellcheck logic in cybol. */
static wchar_t PATH_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'p', L'a', L't', L'h'};
static wchar_t* PATH_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME = PATH_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* PATH_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The mode parameter for the spellcheck logic in cybol. */
static wchar_t MODE_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'm', L'o', L'd', L'e'};
static wchar_t* MODE_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME = MODE_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* MODE_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The suggestion mode parameter for the spellcheck logic in cybol. */
static wchar_t SUG_MODE_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L's', L'u', L'g', L'-', L'm', L'o', L'd', L'e'};
static wchar_t* SUG_MODE_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME = SUG_MODE_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* SUG_MODE_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The language parameter for the spellcheck logic in cybol. */
static wchar_t LANGUAGE_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'l', L'a', L'n', L'g', L'u', L'a', L'g', L'e'};
static wchar_t* LANGUAGE_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME = LANGUAGE_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* LANGUAGE_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The encoding parameter for the spellcheck logic in cybol. */
static wchar_t ENCODING_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'e', L'n', L'c', L'o', L'd', L'i', L'n', L'g'};
static wchar_t* ENCODING_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME = ENCODING_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* ENCODING_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The master parameter for the spellcheck logic in cybol. */
static wchar_t MASTER_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'm', L'a', L's', L't', L'e', L'r'};
static wchar_t* MASTER_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME = MASTER_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* MASTER_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The keymapping parameter for the spellcheck logic in cybol. */
static wchar_t KEYMAPPING_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'l', L'a', L'n', L'g', L'u', L'a', L'g', L'e'};
static wchar_t* KEYMAPPING_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME = KEYMAPPING_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* KEYMAPPING_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The dont backup option for the spellcheck logic in cybol. */
static wchar_t DONT_BACKUP_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_ARRAY[] = {L'd', L'o', L'n', L't', L'-', L'b', L'a', L'c', L'k', L'u', L'p'};
static wchar_t* DONT_BACKUP_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME = DONT_BACKUP_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_ARRAY;
static int* DONT_BACKUP_SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* SPELLCHECK_COMMANDER_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif
