#
# The project-specific variables.
#
set(CPACK_PACKAGE_NAME "cybop")
set(CPACK_PACKAGE_CONTACT "christian.heller@tuxtax.de")
set(CPACK_PACKAGE_DESCRIPTION_FILE "${ROOT_DIR}/README")
set(CPACK_PACKAGE_DESCRIPTION_SUMMARY "Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>")
set(CPACK_RESOURCE_FILE_LICENSE "${ROOT_DIR}/COPYING")

#
# The version information.
#
SET(CPACK_PACKAGE_VERSION_MAJOR "0")
SET(CPACK_PACKAGE_VERSION_MINOR "19")
SET(CPACK_PACKAGE_VERSION_PATCH "0")
SET(CPACK_PACKAGE_VERSION "${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}.${CPACK_PACKAGE_VERSION_PATCH}")

#
# The components.
#
# The files to be added to the release,
# distributed in specific components.
# One can include directories and files using file patterns.
#

# The cyboi component.
INSTALL(DIRECTORY ${ROOT_DIR}/build/cmake/ DESTINATION build/cmake)
INSTALL(DIRECTORY ${ROOT_DIR}/build/doxygen/ DESTINATION build/doxygen)
INSTALL(DIRECTORY ${ROOT_DIR}/build/icon/ DESTINATION build/icon)
INSTALL(FILES ${ROOT_DIR}/build/manpage/cyboi.1.gz DESTINATION build/manpage)
INSTALL(FILES ${ROOT_DIR}/build/.clang-format DESTINATION build)
INSTALL(FILES ${ROOT_DIR}/build/CMakeLists.txt DESTINATION build)
INSTALL(DIRECTORY ${ROOT_DIR}/src/ DESTINATION src)

# The cybol component.
INSTALL(FILES ${ROOT_DIR}/build/manpage/cybol.5.gz DESTINATION build/manpage)
INSTALL(DIRECTORY ${ROOT_DIR}/doc/books/cybol/api/ DESTINATION doc/books/cybol/api)
INSTALL(DIRECTORY ${ROOT_DIR}/doc/books/cybol/schema/ DESTINATION doc/books/cybol/schema)
INSTALL(DIRECTORY ${ROOT_DIR}/doc/books/cybol/syntax/ DESTINATION doc/books/cybol/syntax)
INSTALL(FILES ${ROOT_DIR}/doc/books/cybol/api.html DESTINATION doc/books/cybol)
INSTALL(FILES ${ROOT_DIR}/doc/books/cybol/api.css DESTINATION doc/books/cybol)
INSTALL(FILES ${ROOT_DIR}/doc/books/cybol/cybol_2007-07-31.pdf DESTINATION doc/books/cybol)
INSTALL(DIRECTORY ${ROOT_DIR}/examples/ DESTINATION examples)

# The cybop component.
INSTALL(FILES ${ROOT_DIR}/build/manpage/cybop.7.gz DESTINATION build/manpage)
INSTALL(FILES ${ROOT_DIR}/doc/books/cybop/cybop.pdf DESTINATION doc/books/cybop)
INSTALL(FILES ${ROOT_DIR}/doc/lightning_talk/cybop.pdf DESTINATION doc/lightning_talk)
#INSTALL(DIRECTORY ${ROOT_DIR}/doc/lightning_talk/ DESTINATION doc/lightning_talk COMPONENT cybop FILES_MATCHING PATTERN "*.pdf")
INSTALL(FILES ${ROOT_DIR}/doc/manual/manual-de.pdf DESTINATION doc/manual)
INSTALL(FILES ${ROOT_DIR}/doc/manual/manual-en.pdf DESTINATION doc/manual)
INSTALL(FILES ${ROOT_DIR}/AUTHORS DESTINATION .)
INSTALL(FILES ${ROOT_DIR}/ChangeLog DESTINATION .)
INSTALL(FILES ${ROOT_DIR}/COPYING DESTINATION .)
INSTALL(FILES ${ROOT_DIR}/INSTALL DESTINATION .)
INSTALL(FILES ${ROOT_DIR}/NEWS DESTINATION .)
INSTALL(FILES ${ROOT_DIR}/README DESTINATION .)

# Setup packaging configuration.
if(UNIX AND NOT APPLE)
    set(CPACK_GENERATOR "TGZ")
elseif (APPLE)
    set(CPACK_GENERATOR "TGZ")
else()
    message( SEND_ERROR "Windows is not supported yet" )
endif()

# Load global setting file.
include(CPack)

add_custom_target(
        adjustcopyright
        COMMAND ${ROOT_DIR}/build/cmake/adjustcopyright.py ${ROOT_DIR} ${CPACK_PACKAGE_VERSION}
)
