/*
 * Copyright (C) 1999-2017. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.19.0 2017-04-10
 * @author Christian Heller <christian.heller@tuxtax.de>
 */

#ifndef SERIALISE_REPRESENTATION_LOGIC_CYBOL_NAME_CONSTANT_SOURCE
#define SERIALISE_REPRESENTATION_LOGIC_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The destination serialise representation logic cybol name. */
static wchar_t* DESTINATION_SERIALISE_REPRESENTATION_LOGIC_CYBOL_NAME = L"destination";
static int* DESTINATION_SERIALISE_REPRESENTATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The source serialise representation logic cybol name. */
static wchar_t* SOURCE_SERIALISE_REPRESENTATION_LOGIC_CYBOL_NAME = L"source";
static int* SOURCE_SERIALISE_REPRESENTATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The format serialise representation logic cybol name. */
static wchar_t* FORMAT_SERIALISE_REPRESENTATION_LOGIC_CYBOL_NAME = L"format";
static int* FORMAT_SERIALISE_REPRESENTATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The indentation send communication logic cybol name. */
static wchar_t* INDENTATION_SERIALISE_REPRESENTATION_LOGIC_CYBOL_NAME = L"indentation";
static int* INDENTATION_SERIALISE_REPRESENTATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The language serialise representation logic cybol name. */
static wchar_t* LANGUAGE_SERIALISE_REPRESENTATION_LOGIC_CYBOL_NAME = L"language";
static int* LANGUAGE_SERIALISE_REPRESENTATION_LOGIC_CYBOL_NAME_COUNT = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* SERIALISE_REPRESENTATION_LOGIC_CYBOL_NAME_CONSTANT_SOURCE */
#endif
