/*
 * Copyright (C) 1999-2020. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.21.0 2020-07-29
 * @author Christian Heller <christian.heller@cybop.org>
 */

#ifndef DISK_USAGE_UNIX_COMMAND_OPTION_NAME_CONSTANT_SOURCE
#define DISK_USAGE_UNIX_COMMAND_OPTION_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The human disk usage unix command option name. */
static wchar_t* HUMAN_DISK_USAGE_UNIX_COMMAND_OPTION_NAME = L"-h";
static int* HUMAN_DISK_USAGE_UNIX_COMMAND_OPTION_NAME_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The summarize disk usage unix command option name. */
static wchar_t* SUMMARIZE_DISK_USAGE_UNIX_COMMAND_OPTION_NAME = L"-s";
static int* SUMMARIZE_DISK_USAGE_UNIX_COMMAND_OPTION_NAME_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The all disk usage unix command option name. */
static wchar_t* ALL_DISK_USAGE_UNIX_COMMAND_OPTION_NAME = L"-a";
static int* ALL_DISK_USAGE_UNIX_COMMAND_OPTION_NAME_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The bytes disk usage unix command option name. */
static wchar_t* BYTES_DISK_USAGE_UNIX_COMMAND_OPTION_NAME = L"-b";
static int* BYTES_DISK_USAGE_UNIX_COMMAND_OPTION_NAME_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The total disk usage unix command option name. */
static wchar_t* TOTAL_DISK_USAGE_UNIX_COMMAND_OPTION_NAME = L"-c";
static int* TOTAL_DISK_USAGE_UNIX_COMMAND_OPTION_NAME_COUNT = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* DISK_USAGE_UNIX_COMMAND_OPTION_NAME_CONSTANT_SOURCE */
#endif
