/*
 * Copyright (C) 1999-2020. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.21.0 2020-07-29
 * @author Christian Heller <christian.heller@cybop.org>
 */

#ifndef PART_STATE_CYBOI_NAME_CONSTANT_SOURCE
#define PART_STATE_CYBOI_NAME_CONSTANT_SOURCE

#include "../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The references part state cyboi name. */
static int* REFERENCES_PART_STATE_CYBOI_NAME = NUMBER_0_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The name part state cyboi name. */
static int* NAME_PART_STATE_CYBOI_NAME = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The channel part state cyboi name. */
static int* CHANNEL_PART_STATE_CYBOI_NAME = NUMBER_2_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The encoding part state cyboi name. */
static int* ENCODING_PART_STATE_CYBOI_NAME = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The language part state cyboi name. */
static int* LANGUAGE_PART_STATE_CYBOI_NAME = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The format part state cyboi name. */
static int* FORMAT_PART_STATE_CYBOI_NAME = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The type part state cyboi name. */
static int* TYPE_PART_STATE_CYBOI_NAME = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The model part state cyboi name. */
static int* MODEL_PART_STATE_CYBOI_NAME = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The properties part state cyboi name. */
static int* PROPERTIES_PART_STATE_CYBOI_NAME = NUMBER_8_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* PART_STATE_CYBOI_NAME_CONSTANT_SOURCE */
#endif
