/*
 * Copyright (C) 1999-2020. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.21.0 2020-07-29
 * @author Christian Heller <christian.heller@cybop.org>
 */

#ifndef ACTION_GUI_STATE_CYBOL_NAME_CONSTANT_SOURCE
#define ACTION_GUI_STATE_CYBOL_NAME_CONSTANT_SOURCE

#include <stddef.h> // wchar_t

#include "../../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

/** The button action gui state cybol name. */
static wchar_t* BUTTON_ACTION_GUI_STATE_CYBOL_NAME = L"button";
static int* BUTTON_ACTION_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The event action gui state cybol name. */
static wchar_t* EVENT_ACTION_GUI_STATE_CYBOL_NAME = L"event";
static int* EVENT_ACTION_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_5_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The exposed_height action gui state cybol name. */
static wchar_t* EXPOSED_HEIGHT_ACTION_GUI_STATE_CYBOL_NAME = L"exposed_height";
static int* EXPOSED_HEIGHT_ACTION_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_14_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The exposed_width action gui state cybol name. */
static wchar_t* EXPOSED_WIDTH_ACTION_GUI_STATE_CYBOL_NAME = L"exposed_width";
static int* EXPOSED_WIDTH_ACTION_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_13_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The exposed_x action gui state cybol name. */
static wchar_t* EXPOSED_X_ACTION_GUI_STATE_CYBOL_NAME = L"exposed_x";
static int* EXPOSED_X_ACTION_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The exposed_y action gui state cybol name. */
static wchar_t* EXPOSED_Y_ACTION_GUI_STATE_CYBOL_NAME = L"exposed_y";
static int* EXPOSED_Y_ACTION_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_9_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The keycode action gui state cybol name. */
static wchar_t* KEYCODE_ACTION_GUI_STATE_CYBOL_NAME = L"keycode";
static int* KEYCODE_ACTION_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The mask action gui state cybol name. */
static wchar_t* MASK_ACTION_GUI_STATE_CYBOL_NAME = L"mask";
static int* MASK_ACTION_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The mode action gui state cybol name. */
static wchar_t* MODE_ACTION_GUI_STATE_CYBOL_NAME = L"mode";
static int* MODE_ACTION_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The window action gui state cybol name. */
static wchar_t* WINDOW_ACTION_GUI_STATE_CYBOL_NAME = L"window";
static int* WINDOW_ACTION_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The x action gui state cybol name. */
static wchar_t* X_ACTION_GUI_STATE_CYBOL_NAME = L"x";
static int* X_ACTION_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The y action gui state cybol name. */
static wchar_t* Y_ACTION_GUI_STATE_CYBOL_NAME = L"y";
static int* Y_ACTION_GUI_STATE_CYBOL_NAME_COUNT = NUMBER_1_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* ACTION_GUI_STATE_CYBOL_NAME_CONSTANT_SOURCE */
#endif
