/*
 * Copyright (C) 1999-2022. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.22.0 2022-02-22
 * @author Christian Heller <christian.heller@cybop.org>
 */

#ifndef LEXICOGRAPHICAL_COMPARATOR_SOURCE
#define LEXICOGRAPHICAL_COMPARATOR_SOURCE

#include "../../constant/model/cyboi/log/level_log_cyboi_model.c"
#include "../../constant/model/cyboi/state/boolean_state_cyboi_model.c"
#include "../../executor/comparator/integer/equal_integer_comparator.c"
#include "../../executor/comparator/scalar_count_comparator.c"
#include "../../executor/comparator/vector_count_comparator.c"
#include "../../logger/logger.c"

/**
 * Tests if the lexicographical flag is set and calls the corresponding function.
 *
 * @param p0 the result array (number 1 if true; unchanged otherwise)
 * @param p1 the left data
 * @param p2 the right data
 * @param p3 the operation type
 * @param p4 the operand type
 * @param p5 the count
 * @param p6 the left index
 * @param p7 the right index
 * @param p8 the left count
 * @param p9 the right count
 * @param p10 the result count
 * @param p11 the lexicographical flag
 */
void compare_lexicographical(void* p0, void* p1, void* p2, void* p3, void* p4, void* p5, void* p6, void* p7, void* p8, void* p9, void* p10, void* p11) {

    log_message_terminated((void*) DEBUG_LEVEL_LOG_CYBOI_MODEL, (void*) L"Compare lexicographical.");

    // The comparison result.
    int r = *FALSE_BOOLEAN_STATE_CYBOI_MODEL;

    compare_integer_equal((void*) &r, p11, (void*) FALSE_BOOLEAN_STATE_CYBOI_MODEL);

    if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

        //
        // The lexicographical flag is FALSE.
        // Apply standard comparison with MANY return values in a vector.
        // The vector count is given by parametre p7.
        //

        compare_count_vector(p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10);

    } else {

        //
        // The lexicographical flag is TRUE.
        // Apply lexicographical comparison with only ONE scalar return value.
        // The left and right count are given by parametres p3 and p4.
        //

        compare_count_scalar(p0, p1, p2, p8, p9, p3, p4, p10);
    }
}

/* LEXICOGRAPHICAL_COMPARATOR_SOURCE */
#endif
