/*
 * Copyright (C) 1999-2022. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.22.0 2022-02-22
 * @author Christian Heller <christian.heller@cybop.org>
 */

#ifndef PIPE_OPENER_SOURCE
#define PIPE_OPENER_SOURCE

#include "../../../../constant/model/cyboi/log/level_log_cyboi_model.c"
#include "../../../../logger/logger.c"

#if defined(__linux__) || defined(__unix__)
    #include "../../../../executor/dispatcher/opener/unix_pipe/unix_pipe_opener.c"
#elif defined(__APPLE__) && defined(__MACH__)
    #include "../../../../executor/dispatcher/opener/unix_pipe/unix_pipe_opener.c"
// Use __CYGWIN__ too, if _WIN32 is not known to mingw.
#elif defined(_WIN32) || defined(__CYGWIN__)
    #include "../../../../executor/dispatcher/opener/win32_pipe/win32_pipe_opener.c"
#else
    #error "Could not compile system. The operating system is not supported. Check out defined preprocessor macros!"
#endif

/**
 * Opens up a pipeline (pipe), also called "anonymous pipe".
 *
 * The reading and writing ends of the pipe are stored in the array.
 * An easy way to remember that the input end comes first is that
 * file descriptor 0 is standard input, and file descriptor 1 is standard output.
 *
 * @param p0 the file descriptor array
 */
void open_pipe(void* p0) {

    log_message_terminated((void*) INFORMATION_LEVEL_LOG_CYBOI_MODEL, (void*) L"Open pipe.");

#if defined(__linux__) || defined(__unix__)
    open_unix_pipe(p0);
#elif defined(__APPLE__) && defined(__MACH__)
    open_unix_pipe(p0);
// Use __CYGWIN__ too, if _WIN32 is not known to mingw.
#elif defined(_WIN32) || defined(__CYGWIN__)
    open_win32_pipe(p0);
#else
    #error "Could not compile system. The operating system is not supported. Check out defined preprocessor macros!"
#endif
}

/* PIPE_OPENER_SOURCE */
#endif
