/*
 * Copyright (C) 1999-2022. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.23.0 2022-09-04
 * @author Christian Heller <christian.heller@cybop.org>
 */

#ifndef SORT_LOGIC_CYBOL_FORMAT_CONSTANT_SOURCE
#define SORT_LOGIC_CYBOL_FORMAT_CONSTANT_SOURCE

#include <stddef.h> // wchar_t

#include "../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

//
// Sort
//
// IANA media type: not defined
// Self-defined media type: sort
// This media type is a CYBOL extension.
//

/**
 * The sort/bubble logic cybol format.
 *
 * Sort numbers via bubblesort-algorithm.
 *
 * This is a CYBOL extension.
 *
 * Expected parametres:
 * - part (required): the knowledge model to be sorted
 * - criterion (optional): the comparison criterion used for sorting parts
 * - descending (optional; the default is "false"): the sort direction flag;
 *   false = ascending sort order;
 *   true = descending sort order
 */
static wchar_t* BUBBLE_SORT_LOGIC_CYBOL_FORMAT = L"sort/bubble";
static int* BUBBLE_SORT_LOGIC_CYBOL_FORMAT_COUNT = NUMBER_11_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The sort/insertion logic cybol format.
 *
 * Sort numbers via insertionsort-algorithm.
 *
 * This is a CYBOL extension.
 *
 * Expected parametres:
 * - part (required): the knowledge model to be sorted
 * - criterion (optional): the comparison criterion used for sorting parts
 * - descending (optional; the default is "false"): the sort direction flag;
 *   false = ascending sort order;
 *   true = descending sort order
 */
static wchar_t* INSERTION_SORT_LOGIC_CYBOL_FORMAT = L"sort/insertion";
static int* INSERTION_SORT_LOGIC_CYBOL_FORMAT_COUNT = NUMBER_14_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The sort/quick logic cybol format.
 *
 * Sort numbers via quicksort-algorithm.
 *
 * This is a CYBOL extension.
 *
 * Expected parametres:
 * - part (required): the knowledge model to be sorted
 * - criterion (optional): the comparison criterion used for sorting parts
 * - descending (optional; the default is "false"): the sort direction flag;
 *   false = ascending sort order;
 *   true = descending sort order
 */
static wchar_t* QUICK_SORT_LOGIC_CYBOL_FORMAT = L"sort/quick";
static int* QUICK_SORT_LOGIC_CYBOL_FORMAT_COUNT = NUMBER_10_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/**
 * The sort/selection logic cybol format.
 *
 * Sort numbers via selectionsort-algorithm.
 *
 * This is a CYBOL extension.
 *
 * Expected parametres:
 * - part (required): the knowledge model to be sorted
 * - criterion (optional): the comparison criterion used for sorting parts
 * - descending (optional; the default is "false"): the sort direction flag;
 *   false = ascending sort order;
 *   true = descending sort order
 */
static wchar_t* SELECTION_SORT_LOGIC_CYBOL_FORMAT = L"sort/selection";
static int* SELECTION_SORT_LOGIC_CYBOL_FORMAT_COUNT = NUMBER_14_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* SORT_LOGIC_CYBOL_FORMAT_CONSTANT_SOURCE */
#endif
