/*
 * Copyright (C) 1999-2022. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.23.0 2022-09-04
 * @author Christian Heller <christian.heller@cybop.org>
 */

#ifndef GENERAL_HEADER_HTTP_NAME_CONSTANT_SOURCE
#define GENERAL_HEADER_HTTP_NAME_CONSTANT_SOURCE

#include <stddef.h>

#include "../../../../constant/model/cyboi/state/integer_state_cyboi_model.c"

//
// The following constants are taken from the HTTP 1.1 RFC 2616 specification:
// http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14
// They are sorted alphabetically here.
//

/** The Cache-Control general header http name. */
static unsigned char* CACHE_CONTROL_GENERAL_HEADER_HTTP_NAME = "Cache-Control";
static int* CACHE_CONTROL_GENERAL_HEADER_HTTP_NAME_COUNT = NUMBER_13_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The Connection general header http name. */
static unsigned char* CONNECTION_GENERAL_HEADER_HTTP_NAME = "Connection";
static int* CONNECTION_GENERAL_HEADER_HTTP_NAME_COUNT = NUMBER_10_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The Date general header http name. */
static unsigned char* DATE_GENERAL_HEADER_HTTP_NAME = "Date";
static int* DATE_GENERAL_HEADER_HTTP_NAME_COUNT = NUMBER_4_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The Pragma general header http name. */
static unsigned char* PRAGMA_GENERAL_HEADER_HTTP_NAME = "Pragma";
static int* PRAGMA_GENERAL_HEADER_HTTP_NAME_COUNT = NUMBER_6_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The Trailer general header http name. */
static unsigned char* TRAILER_GENERAL_HEADER_HTTP_NAME = "Trailer";
static int* TRAILER_GENERAL_HEADER_HTTP_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The Transfer-Encoding general header http name. */
static unsigned char* TRANSFER_ENCODING_GENERAL_HEADER_HTTP_NAME = "Transfer-Encoding";
static int* TRANSFER_ENCODING_GENERAL_HEADER_HTTP_NAME_COUNT = NUMBER_17_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The Upgrade general header http name. */
static unsigned char* UPGRADE_GENERAL_HEADER_HTTP_NAME = "Upgrade";
static int* UPGRADE_GENERAL_HEADER_HTTP_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The Via general header http name. */
static unsigned char* VIA_GENERAL_HEADER_HTTP_NAME = "Via";
static int* VIA_GENERAL_HEADER_HTTP_NAME_COUNT = NUMBER_3_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/** The Warning general header http name. */
static unsigned char* WARNING_GENERAL_HEADER_HTTP_NAME = "Warning";
static int* WARNING_GENERAL_HEADER_HTTP_NAME_COUNT = NUMBER_7_INTEGER_STATE_CYBOI_MODEL_ARRAY;

/* GENERAL_HEADER_HTTP_NAME_CONSTANT_SOURCE */
#endif
