/*
 * Copyright (C) 1999-2022. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.24.0 2022-12-24
 * @author Christian Heller <christian.heller@cybop.org>
 */

#ifndef INTEGER_ASSEMBLER_NUMERAL_DESERIALISER_SOURCE
#define INTEGER_ASSEMBLER_NUMERAL_DESERIALISER_SOURCE

#include "../../../../../constant/model/cyboi/log/level_log_cyboi_model.c"
#include "../../../../../executor/calculator/integer/multiply_integer_calculator.c"
#include "../../../../../executor/copier/integer_copier.c"
#include "../../../../../logger/logger.c"

/**
 * Assembles the integer from the given values.
 *
 * @param p0 the destination integer
 * @param p1 the algebraic sign
 * @param p2 the value
 */
void deserialise_numeral_assembler_integer(void* p0, void* p1, void* p2) {

    log_message_terminated((void*) DEBUG_LEVEL_LOG_CYBOI_MODEL, (void*) L"Deserialise numeral assembler integer.");
    //?? fwprintf(stdout, L"Debug: Deserialise numeral assembler integer. value p2: %i\n", p2);
    //?? fwprintf(stdout, L"Debug: Deserialise numeral assembler integer. value *p2: %i\n", *((int*) p2));

    // Copy value to destination integer.
    copy_integer(p0, p2);

    // Multiplicate integer with algebraic sign factor.
    calculate_integer_multiply(p0, p1);
}

/* INTEGER_ASSEMBLER_NUMERAL_DESERIALISER_SOURCE */
#endif
