/*
 * Copyright (C) 1999-2023. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.25.0 2023-03-01
 * @author Christian Heller <christian.heller@cybop.org>
 */

#ifndef IDENTIFICATION_FIELD_XDT_DESERIALISER_SOURCE
#define IDENTIFICATION_FIELD_XDT_DESERIALISER_SOURCE

#include "../../../../../constant/model/cyboi/log/level_log_cyboi_model.c"
#include "../../../../../constant/model/cyboi/state/boolean_state_cyboi_model.c"
#include "../../../../../constant/type/cyboi/state_cyboi_type.c"
#include "../../../../../executor/calculator/integer/add_integer_calculator.c"
#include "../../../../../executor/comparator/integer/greater_or_equal_integer_comparator.c"
#include "../../../../../executor/copier/pointer_copier.c"
#include "../../../../../executor/mover/mover.c"
#include "../../../../../logger/logger.c"

/**
 * Deserialises xdt field identification.
 *
 * @param p0 the destination field identification data (pointer reference)
 * @param p1 the destination field identification count
 * @param p2 the source data position (pointer reference)
 * @param p3 the source count remaining
 * @param p4 the element count
 */
void deserialise_xdt_field_identification(void* p0, void* p1, void* p2, void* p3, void* p4) {

    log_message_terminated((void*) DEBUG_LEVEL_LOG_CYBOI_MODEL, (void*) L"Deserialise xdt field identification.");

    // The comparison result.
    int r = *FALSE_BOOLEAN_STATE_CYBOI_MODEL;

    // Initialise field identification data.
    copy_pointer(p0, p2);

    // Ensure that array boundaries are not crossed.
    compare_integer_greater_or_equal((void*) &r, p3, p4);

    if (r != *FALSE_BOOLEAN_STATE_CYBOI_MODEL) {

        // Increment destination field identification count.
        calculate_integer_add(p1, p4);
    }

    move(p2, p3, (void*) WIDE_CHARACTER_TEXT_STATE_CYBOI_TYPE, p4, (void*) FALSE_BOOLEAN_STATE_CYBOI_MODEL);
}

/* IDENTIFICATION_FIELD_XDT_DESERIALISER_SOURCE */
#endif
