/*
 * Copyright (C) 1999-2023. Christian Heller.
 *
 * This file is part of the Cybernetics Oriented Interpreter (CYBOI).
 *
 * CYBOI is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published
 * by the Free Software Foundation, either version 3 of the License,
 * or (at your option) any later version.
 *
 * CYBOI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CYBOI. If not, see <http://www.gnu.org/licenses/>.
 *
 * Cybernetics Oriented Programming (CYBOP) <http://www.cybop.org/>
 * CYBOP Developers <cybop-developers@nongnu.org>
 *
 * @version CYBOP 0.26.0 2023-04-04
 * @author Christian Heller <christian.heller@cybop.org>
 */

#ifndef XDT_LIBRARY_SOURCE
#define XDT_LIBRARY_SOURCE

//
// xdt
//

#include "../../../executor/representer/deserialiser/xdt/bdt/bdt_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/bdt/compound_field_bdt_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/bdt/field_bdt_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/bdt/fields_bdt_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/bdt/record_bdt_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/bdt/records_bdt_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/datetime/ddmmyyyy/ddmmyyyy_datetime_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/datetime/ddmmyyyy/elements_ddmmyyyy_datetime_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/datetime/mmyy/elements_mmyy_datetime_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/datetime/mmyy/mmyy_datetime_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/datetime/qyyyy/elements_qyyyy_datetime_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/datetime/qyyyy/quarter_qyyyy_datetime_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/datetime/qyyyy/qyyyy_datetime_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/duration/ddmmyyyyddmmyyyy/ddmmyyyyddmmyyyy_duration_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/duration/hhmmhhmm/hhmmhhmm_duration_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/duration/yyyy/yyyy_duration_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/field/constraints_field_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/field/content_field_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/field/field_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/field/format_field_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/field/identification_field_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/field/line_field_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/field/lines_field_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/field/model_field_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/field/part_field_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/field/size_field_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/field/type_field_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/gdt/gdt_xdt_deserialiser.c"
//?? #include "../../../executor/representer/deserialiser/xdt/hierarchy_field_xdt_deserialiser_FUTURE_BDT_4.c"
#include "../../../executor/representer/deserialiser/xdt/ldt/ldt_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/record/field_record_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/record/fields_record_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/record/part_record_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/record/record_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/standard_xdt_deserialiser.c"
#include "../../../executor/representer/deserialiser/xdt/xdt_deserialiser.c"

#include "../../../executor/representer/serialiser/xdt/datetime/ddmmyyyy/ddmmyyyy_datetime_xdt_serialiser.c"
#include "../../../executor/representer/serialiser/xdt/datetime/mmyy/mmyy_datetime_xdt_serialiser.c"
#include "../../../executor/representer/serialiser/xdt/datetime/qyyyy/quarter_qyyyy_datetime_xdt_serialiser.c"
#include "../../../executor/representer/serialiser/xdt/datetime/qyyyy/qyyyy_datetime_xdt_serialiser.c"
#include "../../../executor/representer/serialiser/xdt/duration/ddmmyyyyddmmyyyy/ddmmyyyyddmmyyyy_duration_xdt_serialiser.c"
#include "../../../executor/representer/serialiser/xdt/duration/hhmmhhmm/hhmmhhmm_duration_xdt_serialiser.c"
#include "../../../executor/representer/serialiser/xdt/duration/yyyy/yyyy_duration_xdt_serialiser.c"
#include "../../../executor/representer/serialiser/xdt/field/model_field_xdt_serialiser.c"
#include "../../../executor/representer/serialiser/xdt/xdt_serialiser.c"
#include "../../../executor/representer/serialiser/xdt_field_description/xdt_field_description_serialiser.c"

#include "../../../executor/selector/xdt/bdt/end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1210_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1250_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1271_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1290_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1297_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1298_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1299_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1301_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1303_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1305_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1330_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1400_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1500_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1502_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1503_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1600_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1702_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_1800_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_2002_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_201_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_203_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_207_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_212_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_213_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_250_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_252_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_2803_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_300_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_301_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_302_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_304_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3050_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_307_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3101_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3120_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3301_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3310_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3399_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3423_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3425_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3454_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3465_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3472_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3501_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3504_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3505_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3510_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3511_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3515_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3528_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3531_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3541_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3602_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3622_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3623_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3632_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3637_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3649_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3650_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3651_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3652_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3653_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3655_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3656_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3657_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3658_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3659_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3660_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3661_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3662_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3669_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3672_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3673_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3689_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3700_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_3702_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_4217_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_4218_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_4234_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_4235_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_4244_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_5000_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_5001_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_5012_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_5020_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_5035_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_5042_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6000_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6001_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6007_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6011_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6200_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6201_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6202_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6206_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6207_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6208_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6210_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6212_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6226_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6228_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6230_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6235_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6285_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6290_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6300_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6302_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6306_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6310_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6312_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6325_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6330_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_6332_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_8000_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_8010_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_80_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_8401_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_8410_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_8411_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_8430_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_8445_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_8510_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_8520_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_919_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_920_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_925_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_9260_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_9801_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_9802_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_9806_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/number_9900_end_compound_field_bdt_xdt_selector.c"
#include "../../../executor/selector/xdt/bdt/record_bdt_xdt_selector.c"
//?? #include "../../../executor/selector/xdt/hierarchy_field_xdt_selector_FUTURE_BDT_4.c"
#include "../../../executor/selector/xdt/record/record_xdt_selector.c"

/* XDT_LIBRARY_SOURCE */
#endif
