<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if($rechte["admin"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");

if(!isset($_GET["type"]))
{
    // bersicht ber die installierten module anzeigen
    ?>
    <h3>Installierte Module</h3>
    <table class="maintable">
    <tr class="rowberschrift">
        <td>ID</td><td>Name</td><td>Aktionen</td>
    </tr>
    <?php
    $fh = opendir("./modules");
    
    $zeile = 2;
    
    while(false !== ($dirname = readdir($fh)))
    {
        if($dirname != "." and $dirname != "..")
        {
            ?>
            <tr class="row<?php echo $zeile ?>">
            <?php
            $module = sql_select("*", "module", "WHERE name='".$dirname."'");
            if(sql_num_rows($module) == 1)
            {
                $modul = sql_fetch_assoc($module);
                ?>
                <td class="liste"><?php echo $modul["id"] ?></td><td class="liste"><a href="index.php?action=admincp&amp;show=module&amp;type=bearbeiten&amp;id=<?php echo $modul["id"] ?>"><b><?php echo $modul["name"] ?></b></a></td><td class="liste"><a href="index.php?action=admincp&amp;show=module&amp;type=uninstall&amp;id=<?php echo $modul["id"] ?>">deinstallieren</a></td>
                <?php
            }
            else
            {
                ?>
                <td class="liste">&nbsp;</td><td class="liste"><?php echo $dirname ?></td><td class="liste"><a href="index.php?action=admincp&amp;show=module&amp;type=install&amp;name=<?php echo $dirname ?>">installieren</a></td>
                <?php
            }
            ?>
            </tr>
            <?php
            
            $zeile++;
            if ($zeile > 2) $zeile = 1;
        }
    }
    closedir($fh);
    ?>
    </table>
    <?php
}
else
{
    if($_GET["type"] == "install")
    {
        // neues modul installieren
        // existieren die wichtigsten modul-dateien?
        $name = trim($_GET["name"]);
        if(!is_readable("./modules/".$name."/links.php"))   fehler("Die Datei links.php des Moduls ist nicht vorhanden!");
        if(!is_readable("./modules/".$name."/loader.php"))  fehler("Die Datei loader.php des Moduls ist nicht vorhanden!");
        if(!is_readable("./modules/".$name."/install.php")) fehler("Die Datei install.php des Moduls ist nicht vorhanden!");
        if(!is_readable("./modules/".$name."/nav_bar.php")) fehler("Die Datei nav_bar.php des Moduls ist nicht vorhanden!");
        
        // ist das modul schon installiert?
        if(sql_num_rows(sql_select("*", "module", "WHERE name='".$name."'")) != 0) fehler("Das Modul ist bereits installiert!");
        
        // in db einfgen
        $werte = array(
            "name" => $name
            );
        sql_insert("module", $werte);
        
        include("./modules/".$name."/install.php");
        
        redir("index.php?action=admincp&show=module", "Das Modul wurde installiert!");
    }
    if($_GET["type"] == "bearbeiten")
    {
        // modul und zugriffsrechte bearbeiten
        if(!isset($_POST["bearbeiten"]))
        {
            $modul = sql_fetch_assoc(sql_select("*", "module", "WHERE id=".$_GET["id"]));
            ?>
            <h3>Modul bearbeiten</h3>
            <form method="POST" action="index.php?action=admincp&amp;show=module&amp;type=bearbeiten&amp;id=<?php echo $_GET["id"] ?>">
            <table class="maintable">
            <tr class="rowberschrift">
                <td colspan="2">Zugriffrechte</td>
            </tr>
            <?php
            $gruppen = sql_select("id, titel", "gruppen", "ORDER BY id ASC");
            while($gruppe = sql_fetch_assoc($gruppen))
            {
                $modulrecht = sql_num_rows(sql_select("*", "modulrechte", "WHERE gruppe_id=".$gruppe["id"]." AND modul_id=".$modul["id"]));
                ?>
                <tr class="row2">
                    <td><?php echo $gruppe["titel"] ?>:</td><td><input name="gruppe[<?php echo $gruppe["id"] ?>]" type="radio" value="1" <?php if($modulrecht == 1) echo "checked " ?>/>Ja <input name="gruppe[<?php echo $gruppe["id"] ?>]" type="radio" value="0" <?php if($modulrecht == 0) echo "checked " ?>/>Nein</td>
                </tr>
                <?php
            }
            ?>
            <tr class="row2">
                <td colspan="2"><input name="bearbeiten" type="submit" value="bearbeiten" /></td>
            </tr>
            </table>
            </form>
            <?php
        }
        if(isset($_POST["bearbeiten"]))
        {
            // db aktualisieren
            foreach($_POST["gruppe"] as $gruppe_id => $zugriff)
            {
                // ist schon ein eintrag mit dieser gruppe und diesem modul vorhanden?
                if($zugriff == 0)
                {
                    // eintrag aus modulrechte lschen, falls vorhanden
                    sql_delete("modulrechte", "WHERE gruppe_id=".$gruppe_id." AND modul_id=".$_GET["id"]);
                }
                else
                {
                    // eintrag in modulrechte einfgen, falls noch nicht vorhanden
                    if(sql_num_rows(sql_select("*", "modulrechte", "WHERE gruppe_id=".$gruppe_id." AND modul_id=".$_GET["id"])) == 0)
                    {
                        $werte = array(
                            "gruppe_id" => $gruppe_id,
                            "modul_id"  => $_GET["id"]
                            );
                        sql_insert("modulrechte", $werte);
                    }
                }
            }
            redir("index.php?action=admincp&show=module", "Die Einstellungen wurden gespeichert!");
        }
    }
    if($_GET["type"] == "uninstall")
    {
        // modul deinstallieren
        $modul = sql_fetch_assoc(sql_select("*", "module", "WHERE id=".$_GET["id"]));
        
        if(!isset($_POST["deinstallieren_bestaetigen"]))
        {
            ?>
            <h3>Modul deinstallieren</h3>
            <form method="POST" action="index.php?action=admincp&amp;show=module&amp;type=uninstall&amp;id=<?php echo $modul["id"] ?>">
            Sind Sie sicher, dass Sie das Modul "<?php echo $modul["name"] ?>" deinstallieren wollen?<br />
            Alle zu diesem Modul gespeicherten Daten gehen verloren!<br />
            <input name="deinstallieren_bestaetigen" type="submit" value="deinstallieren" />
            </form>
            <?php
        }
        else
        {
            // modul-rechte entfernen
            sql_delete("modulrechte", "WHERE modul_id=".$modul["id"]);
            
            // modul-tabellen entfernen
            include("./modules/".$modul["name"]."/install.php");
            
            // modul aus module-tabelle entfernen
            sql_delete("module", "WHERE id=".$modul["id"]);
            
            redir("index.php?action=admincp&show=module", "Das Modul wurde deinstalliert!");
        }
    }
}
?>