<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// rechte berprfen (in den kategorien ist es immer erlaubt)
if(isset($aktboard))
{
  $boardrechte = getboardrechte($aktboard["id"]);
  if($boardrechte["lesen"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");
}

// BB-Code-Parser laden
include("./bbcode_parser.php");
$parser = new HTML_BBCodeParser;

// Smilie-Parser
include("./smilie_parser.php");

$announcement["titel"] = sanitize_html_string($aktannouncement["titel"]);

if($aktannouncement["bbcode"] == 1)
{
  $parser->setText(sanitize_html_string($aktannouncement["nachricht"]));
  $parser->parse();
  $nachricht = $parser->getParsed();
}
else
{
  $nachricht = sanitize_html_string($aktannouncement["nachricht"]);
}
if($aktannouncement["smilies"] == 1)
{
  $nachricht = parse_smilies($nachricht);
}
$announcement["nachricht"] = str_replace("\n", "<br />\n", $nachricht);

include("layouts/".$layout."/announcement.php");
?>