<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

//****************************** editpost **************************************
if($_GET["type"]=="editpost")
{
  //benutzer-rechte?
  $boardrechte = getboardrechte($aktboard["id"]);
  if($boardrechte["moderieren"] == false and ($user["id"] != $aktpost["autor_id"] or $user["id"] == 1)) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");
  if(!isset($_POST["bearbeiten_knopf"]) and !isset($_POST["loeschen_knopf"]) and !isset($_POST["loeschen_bestaetigen"]))
  {
    // formular anzeigen
    ?>
    <h3>Post bearbeiten</h3>
    <form name="form1" method="POST" action="index.php?action=moderate&amp;type=editpost&amp;id=<?php echo $aktpost["id"] ?>">
    <table class="maintable">
    <tr class="rowberschrift">
      <td colspan="2">Nachricht</td>
    </tr>
    <tr class="row2">
      <td>Benutzername:</td><td><?php
      if($boardrechte["moderieren"] == true)
      {
        ?>
        <input class="inputtext" name="autor_name" type="text" value="<?php
        echo sanitize_html_string($aktpost["autor_name"]);
        ?>" size="<?php
        //ist der Autor registriert?
        $autorresult = sql_select("*", "users", "WHERE id=".$aktpost["autor_id"]);
        $autor = sql_fetch_assoc($autorresult);
        if(sql_num_rows($autorresult)==0)
        {
          // Autor wurde gelscht
          ?>35" /> <i>gelschter Benutzer</i><?php
        }
        if($autor["id"]==1)
        {
          // der Autor ist nicht registriert
          ?>35" /> <i>Gast</i><?php
        }
        else
        {
          // der Autor ist registriert
          ?>40" /><?php
        }
      }
      else
      {
        // der Autor-Name darf nicht gendert werden
        echo "<b>".sanitize_html_string($aktpost["autor_name"])."</b><input name=\"autor_name\" type=\"hidden\" value=\"".sanitize_html_string($aktpost["autor_name"])."\" />";
      }
      ?></td>
    </tr>
    <tr class="row2">
      <td>Titel:</td><td><input class="inputtext" name="titel" type="text" size="40" value="<?php echo sanitize_html_string($aktpost["titel"]) ?>" /></td>
    </tr>
    <tr class="row2">
      <td>BB-Code:</td><td><?php $formname = "form1"; $textname = "nachricht"; include("./bbcode_inputs.php") ?></td>
    </tr>
    <tr class="row2">
      <td>Nachricht:</td><td><textarea class="inputtext" name="nachricht" cols="30" rows="15"><?php echo sanitize_html_string($aktpost["nachricht"]) ?></textarea></td>
    </tr>
    <tr class="rowberschrift">
      <td colspan="2">Optionen</td>
    </tr>
    <tr class="row2">
      <td>BB-Code aktivieren</td><td><input name="bbcode" type="radio" value="1"<?php if($aktpost["bbcode"] == 1) echo " checked" ?> />Ja <input name="bbcode" type="radio" value="0"<?php if($aktpost["bbcode"] == 0) echo " checked" ?> />Nein</td>
    </tr>
    <tr class="row2">
      <td>Smilies aktivieren</td><td><input name="smilies" type="radio" value="1"<?php if($aktpost["smilies"] == 1) echo " checked" ?> />Ja <input name="smilies" type="radio" value="0"<?php if($aktpost["smilies"] == 0) echo " checked" ?> />Nein</td>
    </tr>
    <tr class="row2">
      <td>Signatur anhngen</td><td><input name="signatur" type="radio" value="1"<?php if($aktpost["signatur"] == 1) echo " checked" ?> />Ja <input name="signatur" type="radio" value="0"<?php if($aktpost["signatur"] == 0) echo " checked" ?> />Nein</td>
    </tr>
    <tr class="row2">
      <td>&nbsp</td><td><input name="bearbeiten_knopf" type="submit" value="bearbeiten" /> <input name="loeschen_knopf" type="submit" value="lschen" /></td>
    </tr>
    </table>
    </form>
    <?php
  }
  if(isset($_POST["bearbeiten_knopf"]))
  {
    //alles speichern
    if(trim($_POST["autor_name"]) =="") fehler("Jeder Name muss Zeichen enthalten!");
    if($boardrechte["moderieren"] == true)
    {
        $postedit["autor_name"] = $_POST["autor_name"];
        $autorresult = sql_select("*", "users", "WHERE username='".sanitize_sql_string($_POST["autor_name"])."'");
        $autor = sql_fetch_assoc($autorresult);
        if(sql_num_rows($autorresult) == 0 or $autor["id"] == 1)
        {
          // der Autor ist nicht registriert
          $postedit["autor_id"] = 1; // Gast
        }
        else
        {
          $postedit["autor_id"] = $autor["id"];
        }
    }
    else
    {
        $postedit["autor_name"] == $aktpost["autor_name"];
        $postedit["autor_id"]   == $aktpost["autor_id"];
    }
    if($user["id"] == $aktpost["autor_id"] and $boardrechte["moderieren"] == false)
    {
      // der Autor hat seinen Beitrag selbst bearbeitet
      $editmsg = "Bearbeitet vom Autor am ".date("d.m.Y, H:i:s", time());
    }
    else
    {
      // vom Mod bearbeitet
      $mod = sql_fetch_assoc(sql_select("*", "users", "WHERE id=".$user["id"]));
      $editmsg = "Bearbeitet vom Moderator (".sanitize_html_string($mod["username"]).") am ".date("d.m.Y, H:i:s", time())." (Server-Zeit)";
    }
    $postedit["nachricht"] = $_POST["nachricht"]."\n\n".$editmsg;
    $werte = array(
        "titel"      => sanitize_sql_string($_POST["titel"]),
        "autor_id"   => $postedit["autor_id"],
        "autor_name" => trim(sanitize_sql_string($postedit["autor_name"])),
        "nachricht"  => sanitize_sql_string($postedit["nachricht"]),
        "bbcode"     => sanitize_int($_POST["bbcode"]),
        "smilies"    => sanitize_int($_POST["smilies"]),
        "signatur"   => sanitize_int($_POST["signatur"])
        );
    sql_update("posts", $werte, "WHERE id=".$aktpost["id"]);

    redir("index.php?action=viewthread&id=".$aktpost["thread"]."#".$aktpost["id"], "Der Post wurde bearbeitet!");
  }
  if(isset($_POST["loeschen_knopf"]))
  {
    // Besttigung holen
    ?>
    <h3>Post lschen</h3>
    Wollen Sie den Post Nr. <?php echo $aktpost["id"] ?> wirklich lschen?<br />
    <form method="POST" action="index.php?action=moderate&amp;type=editpost&amp;id=<?php echo $aktpost["id"] ?>">
    <input name="loeschen_bestaetigen" type="submit" value="lschen" />
    </form>
    <?php
  }
  if(isset($_POST["loeschen_bestaetigen"]))
  {
    // post lschen
    sql_delete("posts", "WHERE id=".$aktpost["id"]);

    redir("index.php?action=viewthread&id=".$aktthread["id"], "Der Post wurde gelscht!");
  }
}
//***************************** editthread *************************************
if($_GET["type"]=="editthread")
{
  //benutzer-rechte?
  $boardrechte = getboardrechte($aktboard["id"]);
  if($boardrechte["moderieren"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");

  if(!isset($_POST["loeschen_knopf"]) and !isset($_POST["loeschen_bestaetigen"]) and !isset($_POST["bearbeiten_knopf"]) and !isset($_POST["anhaengen_knopf"]) and !isset($_POST["anhaengen_bestaetigen"]) and !isset($_POST["teilen_knopf"]) and !isset($_POST["teilen_bestaetigen"]))
  {
    // Formular anzeigen
    ?>
    <h3>Thread bearbeiten</h3>
    <form method="POST" action="index.php?action=moderate&amp;type=editthread&amp;id=<?php echo $aktthread["id"] ?>">
    <table class="maintable">
    <tr class="rowberschrift">
      <td colspan="2">Thread</td>
    </tr>
    <tr class="row2">
      <td>Titel:</td><td><input class="inputtext" name="titel" type="text" size="40" value="<?php echo sanitize_html_string($aktthread["titel"]) ?>" /></td>
    </tr>
    <tr class="row2">
      <td>Autor:</td><td><input class="inputtext" name="autor_name" type="text" value="<?php
      echo sanitize_html_string($aktthread["autor_name"]);
      ?>" size="<?php
      // ist der Autor registriert?
      $autorresult = sql_select("*", "users", "WHERE id=".$aktthread["autor_id"]);
      $autor = sql_fetch_assoc($autorresult);
      if(sql_num_rows($autorresult)==0)
      {
        // Autor wurde gelscht
        ?>35" /> <i>gelschter Benutzer</i><?php
      }
      if($autor["id"]==1)
      {
        // der Autor ist nicht registriert
        ?>35" /> <i>Gast</i><?php
      }
      else
      {
        // der Autor ist registriert
        ?>40" /><?php
      }
      ?></td>
    </tr>
    <tr class="row2">
      <td>Status</td><td><select class="inputtext" name="status" size="1">
      <option value="0"<?php if($aktthread["status"]==0) echo " selected" ?>>geschlossen</option>
      <option value="1"<?php if($aktthread["status"]==1) echo " selected" ?>>offen</option>
      </select></td>
    </tr>
    <tr class="row2">
      <td>Sticky Thread:</td><td><input name="sticky" type="radio" value="1" <?php if($aktthread["sticky"] == 1) echo "checked " ?>/> Ja <input name="sticky" type="radio" value="0" <?php if($aktthread["sticky"] == 0) echo "checked " ?>/> Nein</td>
    </tr>
    <tr class="row2">
      <td>Board:</td><td><select class="inputtext" name="board" size="1">
      <?php
      $boardresult = sql_select("*", "boards", "");
      while($board = sql_fetch_assoc($boardresult))
      {
        echo "<option value=\"".$board["id"]."\"";
        if($board["id"]==$aktboard["id"]) echo " selected";
        echo " />".$board["id"]." - ".$board["titel"]."</option>\n";
      }
      ?>
      </select></td>
    </tr>
    <tr class="row2">
      <td>&nbsp</td><td><input name="bearbeiten_knopf" type="submit" value="bearbeiten" /></td>
    </tr>
    <tr class="rowberschrift">
      <td colspan="2">andere Aktionen:</td>
    </tr>
    <tr class="row2">
      <td>Lschen:</td><td><input name="loeschen_knopf" type="submit" value="lschen" /></td>
    </tr>
    <tr class="row2">
      <td>Anhngen:</td><td><input name="anhaengen_knopf" type="submit" value="anhngen" /></td>
    </tr>
    <tr class="row2">
      <td>Teilen:</td><td><input name="teilen_knopf" type="submit" value="teilen" /></td>
    </tr>
    </table>
    </form>
    <?php
  }
  if(isset($_POST["bearbeiten_knopf"]))
  {
    if(trim($_POST["titel"]) == "") fehler("Jeder Thread muss einen Titel haben!");
    if(trim($_POST["autor_name"]) == "") fehler("Jeder Name muss Zeichen enthalten!");
    // datenbank-eintrag aktualisieren
    $autorresult = sql_select("*", "users", "WHERE username='".sanitize_sql_string($_POST["autor_name"])."'");
    $autor = sql_fetch_assoc($autorresult);
    if(sql_num_rows($autorresult)==0 or $autor["id"]==1)
    {
      // der Autor ist nicht registriert
      $autorid = 1; //Gast
    }
    else
    {
      $autorid = $autor["id"];
    }
    $werte = array(
        "titel"      => sanitize_sql_string($_POST["titel"]),
        "autor_name" => sanitize_sql_string($_POST["autor_name"]),
        "autor_id"   => $autorid,
        "status"     => sanitize_int($_POST["status"]),
        "board"      => sanitize_int($_POST["board"]),
        "sticky"     => sanitize_int($_POST["sticky"])
        );
    sql_update("threads", $werte, "WHERE id=".$aktthread["id"]);

    redir("index.php?action=viewboard&id=".$aktboard["id"], "Der Thread wurde bearbeitet!");
  }
  if(isset($_POST["loeschen_knopf"]))
  {
    // besttigung holen
    ?>
    <h3>Thread lschen</h3>
    Wollen Sie den Thread Nr. <?php echo $aktthread["id"] ?> wirklich lschen?<br />
    <form method="POST" action="index.php?action=moderate&amp;type=editthread&amp;id=<?php echo $aktthread["id"] ?>">
    <input name="loeschen_bestaetigen" type="submit" value="lschen" />
    </form>
    <?php
  }
  if(isset($_POST["loeschen_bestaetigen"]))
  {
    // thread und alle enthaltenen Posts lschen
    sql_delete("posts", "WHERE thread=".$aktthread["id"]);
    sql_delete("threads", "WHERE id=".$aktthread["id"]);
    // evtl. umfrage lschen
    $delumfrageresult = sql_select("*", "umfragen", "WHERE thread=".$aktthread["id"]);
    if(sql_num_rows($delumfrageresult) != 0)
    {
      $delumfrage = sql_fetch_assoc($delumfrageresult);
      sql_delete("antworten", "WHERE umfrage=".$delumfrage["id"]);
      sql_delete("umfragen", "WHERE thread=".$aktthread["id"]);
    }

    redir("index.php?action=viewboard&id=".$aktboard["id"], "Der Thread wurde gelscht!");
  }
  if(isset($_POST["anhaengen_knopf"]))
  {
    // an welchen thread anhngen?
    ?>
    <h3>Thread anhngen</h3>
    <form method="POST" action="index.php?action=moderate&amp;type=editthread&amp;id=<?php echo $aktthread["id"] ?>">
    An diesen Thread anhngen: <select class="inputtext" name="attachthread" size="1">
    <?php
    $threadlistresult = sql_select("*", "threads", "WHERE board=".$aktboard["id"]);
    while($threadlist = sql_fetch_assoc($threadlistresult))
    {
      if($threadlist["id"]!=$aktthread["id"])
      {
        echo "<option value=\"".$threadlist["id"]."\" />".$threadlist["id"]." - ".sanitize_html_string($threadlist["titel"])."</option>\n";
      }
    }
    ?>
    </select><br />
    <input class="inputtext" name="umfrage_anhaengen" type="checkbox" value="1" checked /> Umfrage anhngen (schon vorhandene Umfrage berschreiben)<br />
    <input name="anhaengen_bestaetigen" type="submit" value="anhngen" />
    </form>
    <?php
  }
  if(isset($_POST["anhaengen_bestaetigen"]))
  {
    // alle enthaltenen posts an den anderen thread anhngen
    $altepostsresult = sql_select("*", "posts", "WHERE thread=".$aktthread["id"]);
    while($alterpost = sql_fetch_assoc($altepostsresult))
    {
      // neuen post-eintrag mit den werten des alten erstellen
      $werte = array(
          "titel"      => $alterpost["titel"],
          "thread"     => sanitize_int($_POST["attachthread"]),
          "autor_id"   => $alterpost["autor_id"],
          "autor_name" => $alterpost["autor_name"],
          "create"     => $alterpost["created"],
          "nachricht"  => $alterpost["nachricht"]
          );
      sql_insert("posts", $werte);
    }
    sql_delete("posts", "WHERE thread=".$aktthread["id"]);
    sql_delete("threads", "WHERE id=".$aktthread["id"]);

    // umfrage anhaengen
    // hat der ziel-thread eine umfrage?
    $zielumfrageresult = sql_select("*", "umfragen", "WHERE thread=".sanitize_int($_POST["attachthread"]));
    if(sql_num_rows($zielumfrageresult) != 0)
    {
      // schon vorhandene umfrage lschen
      $zielumfrage = sql_fetch_assoc($zielumfrageresult);
      sql_delete("antworten", "WHERE umfrage=".$zielumfrage["id"]);
      sql_delete("umfragen", "WHERE id=".$zielumfrage["id"]);
    }
    // umfrage verschieben
    $werte = array("thread" => sanitize_int($_POST["attachthread"]));
    sql_update("umfragen", $werte, "WHERE thread=".$aktthread["id"]);

    redir("index.php?action=viewthread&id=".$_POST["attachthread"], "Der Thread wurde an einen anderen angehngt!");
  }
  if(isset($_POST["teilen_knopf"]))
  {
    // titel fr neuen thread erfragen, und ob er gleich geschlossen werden soll
    ?>
    <h3>Thread teilen</h3>
    <form method="POST" action="index.php?action=moderate&amp;type=editthread&amp;id=<?php echo $aktthread["id"] ?>">
    <table class="maintable">
    <tr class="rowberschrift">
      <td colspan="2">Teilen</td>
    </tr>
    <tr class="row2">
      <td>Teilen:</td><td>Thread nach dem <input class="inputtext" name="teilennach" type="text" size="4" />. Post teilen.</td>
    </tr>
    <tr class="rowberschrift">
      <td colspan="2">Neuer Thread</td>
    </tr>
    <tr>
      <td>Titel:</td><td><input class="inputtext" name="titel" type="text" size="40" /></td>
    </tr>
    <tr class="row2">
      <td>Status:</td><td><input class="inputtext" name="abschliessen" type="checkbox" value="1" /> Thread sofort abschlieen</td>
    </tr>
    <tr class="row2">
      <td>&nbsp</td><td><input name="teilen_bestaetigen" type="submit" value="teilen" /></td>
    </tr>
    </table>
    </form>
    <?php
  }
  if(isset($_POST["teilen_bestaetigen"]))
  {
    // thread teilen
    if(trim($_POST["titel"])=="") fehler("Jeder Thread muss einen Titel haben!");
    // neuen thread erstellen
    $firstpost = sql_fetch_assoc(sql_select("*", "posts", "WHERE thread=".$aktthread["id"]." ORDER BY id ASC LIMIT ".sanitize_int($_POST["teilennach"]).",-1"));

    if($_POST["abschliessen"]=="1")
    {
      $status .= "2";
    }
    else
    {
      $status .= "1";
    }
    $werte = array(
        "titel"      => sanitize_sql_string($_POST["titel"]),
        "status"     => $status,
        "board"      => sanitize_int($_GET["boardid"]),
        "autor_id"   => $firstpost["autor_id"],
        "autor_name" => $firstpost["autor_name"],
        "created"    => time(),
        "hits"       => 0
        );
    sql_insert("threads", $werte);

    // id des neuen threads herausfinden
    $newthread = sql_fetch_assoc(sql_select("*", "threads", "ORDER BY id DESC"));
    // posts in den neuen thread verschieben
    $movepostsresult = sql_select("*", "posts", "WHERE thread=".$aktthread["id"]." ORDER BY id ASC LIMIT ".sanitize_int($_POST["teilennach"]).", -1");
    while($movepost = sql_fetch_assoc($movepostsresult))
    {
      $werte = array("thread" => $newthread["id"]);
      sql_update("posts", $werte, "WHERE id=".$movepost["id"]);
    }

    redir("index.php?action=viewboard&id=".$aktboard["id"], "Der Thread wurde geteilt!");
  }
}
//******************************** editumfrage *********************************
if($_GET["type"]=="editumfrage")
{
  //benutzer-rechte?
  $boardrechte = getboardrechte($aktboard["id"]);
  if($boardrechte["moderieren"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");

  if(!isset($_POST["bearbeiten_button"]) and !isset($_POST["antwort_loeschen"]) and !isset($_POST["add_antwort"]) and !isset($_POST["umfrage_loeschen"]))
  {
    // formular anzeigen
    ?>
    <form method="POST" action="index.php?action=moderate&amp;type=editumfrage&amp;id=<?php echo $aktumfrage["id"] ?>">
    <table class="maintable">
    <tr class="rowberschrift">
      <td colspan="2">Allgemeines</td>
    </tr>
    <tr class="row2">
      <td>Frage:</td><td><input class="inputtext" name="frage" type="text" size="40" value="<?php echo sanitize_html_string($aktumfrage["frage"]) ?>" /></td>
    </tr>
    <tr class="row2">
      <td>Multiple Choice:</td><td><input class="inputtext" name="multiple" type="checkbox" value="1" <?php if($aktumfrage["multiple"]==1) echo "checked " ?>/> Mehrere Antworten erlauben</td>
    </tr>
    <tr class="row2">
      <td>Anonymitt:</td><td><input class="inputtext" name="public" type="checkbox" value="1" <?php if($aktumfrage["public"]==1) echo "checked " ?>/> Anzeigen wer wofr gestimmt hat</td>
    </tr>
    <tr class="row2">
      <td>Gltigkeit:</td><td><input class="inputtext" name="gueltigbis" type="text" size="40" value="<?php if($aktumfrage["gltig_bis"] == 0) { echo "0"; } else { echo date("d.m.Y, H:i:s", $aktumfrage["gltigbis"] + $zeitoffset); } ?>" /></td>
    </tr>
    <tr class="rowberschrift">
      <td colspan="2">Antworten & Stimmen</td>
    </tr>
    <?php
    $antworten = sql_select("*", "antworten", "WHERE umfrage=".$aktumfrage["id"]." ORDER BY id ASC");
    $i = 0;
    while($antwort = sql_fetch_assoc($antworten))
    {
      // zwei textfelder pro antwort ausgeben
      ?>
      <tr class="row2">
        <td colspan="2"><input class="inputtext" name="antwort[]" type="text" size="35" value="<?php echo sanitize_html_string($antwort["antwort"]) ?>" /> <input class="inputtext" name="stimmen[]" type="text" size="5" value="<?php echo $antwort["stimmen"] ?>" /> <input name="antwort_loeschen[<?php echo $antwort["id"] ?>]" type="submit" value="lschen" /></td>
      </tr>
      <?php
    }
    ?>
    <tr class="row2">
      <td colspan="2" align="center"><input name="umfrage_loeschen" type="submit" value="Umfrage lschen" /> <input name="add_antwort" type="submit" value="Antwort hinzufgen" /></td>
    </tr>
    <tr class="row2">
      <td colspan="2" align="center"><input name="bearbeiten_button" type="submit" value="bearbeiten" /></td>
    </tr>
    </table>
    </form>
    <?php
  }
  if(isset($_POST["bearbeiten_button"]))
  {
    // datenbank aktualisieren
    if(trim($_POST["frage"])=="") fehler("Jede Umfrage muss eine Frage haben!");
    function checkantworten($value, $key)
    {
      if(trim($value)=="") fehler("Jede Antwort muss Text enthalten!");
    }
    array_walk($_POST["antwort"],"checkantworten");

    $multiple = 0;
    if(isset($_POST["multiple"])) $multiple = 1;
    $public = 0;
    if(isset($_POST["public"])) $public = 1;
    if($_POST["gueltigbis"] == 0)
    {
      $gltigbis = 0;
    }
    else
    {
      $gltigbis = mktime(substr($_POST["gueltigbis"], 12, 2), substr($_POST["gueltigbis"], 15, 2), substr($_POST["gueltigbis"], 18, 2), substr($_POST["gueltigbis"], 3, 2), substr($_POST["gueltigbis"], 0, 2), substr($_POST["gueltigbis"], 6, 4)) - $zeitoffset;
    }
    $werte = array(
        "frage"         => sanitize_html_string($_POST["frage"]),
        "multiple"      => $multiple,
        "public"        => $public,
        "gltig_bis"    => $gltigbis,
        "moderiert_von" => $user["id"]
        );
    sql_update("umfragen", $werte, "WHERE id=".$aktumfrage["id"]);

    // antworten aktualisieren
    $antworten = sql_select("*", "antworten", "WHERE umfrage=".$aktumfrage["id"]." ORDER BY id ASC");
    function updateantworten($value, $key)
    {
      global $antworten;
      $antwort = sql_fetch_assoc($antworten);
      $werte = array("antwort" => sanitize_sql_string($value));
      sql_update("antworten", $werte, "WHERE id=".$antwort["id"]);
    }
    array_walk($_POST["antwort"],"updateantworten");

    // stimmen aktualisieren
    $antworten = sql_select("*", "antworten", "WHERE umfrage=".$aktumfrage["id"]." ORDER BY id ASC");
    function updatestimmen($value, $key)
    {
      global $antworten;
      $antwort = sql_fetch_assoc($antworten);
      $werte = array("stimmen" => sanitize_int($value));
      sql_update("antworten", $werte, "WHERE id=".$antwort["id"]);
    }
    array_walk($_POST["stimmen"],"updatestimmen");

    redir("index.php?action=viewthread&id=".$aktthread["id"], "Die Umfrage wurde bearbeitet!");
  }
  if(isset($_POST["antwort_loeschen"]))
  {
    // antwort aus datenbank lschen
    function deleteantwort($value, $key)
    {
      sql_delete("antworten", "WHERE id=".sanitize_int($key));
    }
    array_walk($_POST["antwort_loeschen"],"deleteantwort");

    $werte = array("moderiert_von" => $user["id"]);
    sql_update("umfragen", $werte, "WHERE id=".$aktumfrage["id"]);

    redir("index.php?action=viewthread&id=".$aktthread["id"], "Die Antwort wurde gelscht!");
  }
  if(isset($_POST["add_antwort"]))
  {
    // neue antwort anfgen
    $werte = array("umfrage" => $aktumfrage["id"], "antwort" => "Neue Antwort", "stimmen" => 0);
    sql_insert("antworten", $werte);

    $werte = array("moderiert_von" => $user["id"]);
    sql_update("umfragen", $werte, "WHERE id=".$aktumfrage["id"]);

    redir("index.php?action=moderate&type=editumfrage&id=".$aktumfrage["id"], "Eine neue Antwort wurde hinzugefgt!");
  }
  if(isset($_POST["umfrage_loeschen"]))
  {
    // umfrage und antworten aus der datenbank lschen
    sql_delete("antworten", "WHERE umfrage=".$aktumfrage["id"]);
    sql_delete("umfragen", "WHERE id=".$aktumfrage["id"]);

    redir("index.php?action=viewthread&id=".$aktthread["id"], "Die Umfrage wurde gelscht!");
  }
}
?>