<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if($rechte["memberlist"] == false) fehler("Sie besitzen nicht die ntigen Zugriffsrechte, um diese Seite zu betreten!");
$result = sql_select("*", "users", "WHERE id=".sanitize_int($_GET["id"]));
if(sql_num_rows($result)==0)
{
  ?>
  <h3>Benutzer-Info</h3>
  Der Benutzer mit der ID <b><?php echo sanitize_int($_GET["id"]) ?></b> existiert nicht in der Datenbank.<br />
  Wahrscheinlich wurde er gelscht.
  <?php
  die();
}

$ergebnis = sql_fetch_assoc($result);

$postresult = sql_select("*", "posts", "WHERE autor_id=".sanitize_int($_GET["id"])." ORDER BY created DESC");
$posts = sql_num_rows($postresult);
if($posts!=0)
{
  $lastpostergebnis = sql_fetch_assoc($postresult);
  $threadresult = sql_select("*", "threads", "WHERE id=".$lastpostergebnis["thread"]);
  $threadergebnis = sql_fetch_assoc($threadresult);
  $lastpost = date("d.m.Y - H:i:s",$lastpostergebnis["created"] + $zeitoffset)." in <a href=\"index.php?action=viewthread&amp;id=".$lastpostergebnis["thread"]."#".$lastpostergebnis["id"]."\">".sanitize_html_string($threadergebnis["titel"])."</a>";
}
else
{
  $lastpost = "-";
}

?>
<h3>Benutzer-Info</h3>
<table class="maintable" width="80%">
<tr class="rowberschrift">
    <td colspan="2"><b>Benutzer-Info fr <u><?php echo sanitize_html_string($ergebnis["username"]) ?></u></b></td>
</tr>
<tr class="row2">
    <td class="liste">Status:</td><td class="liste"><?php
    switch($ergebnis["status"])
    {
      case 0:
        echo "nicht aktiviert";
        break;
      case 1:
        echo "gebannt";
        break;
      case 2:
        echo "aktiviert";
        break;
      }
      ?></td>
</tr>
<?php
// benutzerrang?
$userposts = sql_num_rows(sql_select("*", "posts", "WHERE autor_id=".$ergebnis["id"]));
$userrank = sql_fetch_assoc(sql_select("*", "userranks", "WHERE minposts<=".$userposts." ORDER BY minposts DESC", 0, 1));
?>
<tr class="row2">
    <td class="liste">Benutzerrang:</td><td class="liste"><?php echo $userrank["titel"] ?> <img src="./gfx/userranks/<?php echo $userrank["icon"] ?>" /></td>
</tr>
<tr class="row2">
    <td class="liste">Beitrge:</td><td class="liste"><?php echo $posts ?></td>
</tr>
<tr class="row2">
    <td class="liste">Letzter Beitrag:</td><td class="liste"><?php echo $lastpost ?></td>
</tr>
<tr class="row2">
    <td class="liste">Registriert seit:</td><td class="liste"><?php echo date("d.m.Y - H:i:s",$ergebnis["reg_since"] + $zeitoffset) ?></td>
</tr>
<?php
if($rechte["sendmail"] == true)
{
  ?>
  <tr class="row2">
    <td class="liste">E-Mail:</td><td class="liste"><a href="index.php?action=sendmail&amp;id=<?php echo $ergebnis["id"] ?>"><?php echo $t_email ?></a></td>
  </tr>
  <?php
}
?>
<tr class="row2">
    <td class="liste">ICQ-Nummer:</td><td class="liste"><?php echo sanitize_int($ergebnis["icq"]) ?></td>
</tr>
<tr class="rowberschrift">
    <td align="right" colspan="2">
        <?php
        // modul-links anzeigen
        if(isset($modlinks["userlinks"]))
        {
            foreach($modlinks["userlinks"] as $modtitel => $modlink)
            {
                if($modlink["gast"] == true or $ergebnis["id"] != 1)
                {
                    ?>
                    <a href="<?php echo str_replace("{userid}", $ergebnis["id"], $modlink["link"]) ?>"><?php echo $modlink["text"] ?></a>
                    <?php
                }
            }
        }
        ?>
    </td>
</tr>
</table>
