/*
 * Decompiled with CFR 0.152.
 */
package gde.device.estner;

import gde.comm.DeviceCommPort;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.estner.AkkumatikDialog;
import gde.exception.TimeOutException;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AkkumatikSerialPort
extends DeviceCommPort {
    static final String $CLASS_NAME = AkkumatikSerialPort.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    final int timeout = this.device.getDeviceConfiguration().getReadTimeOut();
    final int stableIndex = this.device.getDeviceConfiguration().getReadStableIndex();
    final int maxRetryCount = 25;
    int retryCount = 0;

    public AkkumatikSerialPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
    }

    public synchronized byte[] getData() throws Exception {
        String $METHOD_NAME = "getData";
        byte[] data = new byte[Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO))];
        try {
            data = this.read(data, this.timeout, this.stableIndex);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINER, $CLASS_NAME, "getData", "0123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789");
                log.logp(Level.FINE, $CLASS_NAME, "getData", new String(data));
            }
            if (data.length < 69 || data.length > 129 || data[4] != 58 || data[7] != 58 || data[0] != 49 && data[0] != 50 || data[1] != -1 || data[data.length - 1] != 10 || data[data.length - 2] != 13) {
                if (data.length != 5) {
                    log.logp(Level.WARNING, $CLASS_NAME, "getData", "Serial comm error, data = " + new String(data));
                    ++this.retryCount;
                    if (this.retryCount > this.maxRetryCount) {
                        String msg = "Errors during serial communication, maximum of retries exceeded!";
                        this.retryCount = 0;
                        log.logp(Level.WARNING, $CLASS_NAME, "getData", "Errors during serial communication, maximum of retries exceeded!");
                    }
                    this.cleanInputStream();
                } else {
                    log.logp(Level.INFO, $CLASS_NAME, "getData", "Firmware '" + new String(data) + "'");
                }
                data = this.getData();
            }
        }
        catch (Exception e) {
            if (!(e instanceof TimeOutException)) {
                log.logp(Level.SEVERE, $CLASS_NAME, "getData", e.getMessage(), e);
            }
            throw e;
        }
        this.retryCount = 0;
        return data;
    }

    public String[] getDataArray(byte[] buffer) {
        String[] dataArray;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "  Read : " + StringHelper.byte2Hex2CharString((byte[])buffer, (int)buffer.length));
            log.log(Level.FINE, "0123456789|123456789|123456789|123456789|123456789|123456789|123456789|123456789");
            log.log(Level.FINE, "splitter = " + new String(new byte[]{-1}) + " - " + new String(buffer));
        }
        if ((dataArray = new String(buffer).split(new String(new byte[]{-1}))).length < 15) {
            log.log(Level.SEVERE, "array size = " + dataArray.length + " splitter = " + new String(new byte[]{-1}) + " - " + new String(buffer));
            log.log(Level.SEVERE, "splitter = " + new String(new byte[]{-1}) + " - " + new String(buffer));
        }
        if (dataArray.length < 15) {
            for (int i = 0; i < buffer.length; ++i) {
                if (buffer[i] != 255) continue;
                buffer[i] = 33;
            }
            log.log(Level.WARNING, "array size = " + dataArray.length + " splitter = " + new String(new byte[]{33}) + " - " + new String(buffer));
            dataArray = new String(buffer).split(new String(new byte[]{33}));
        }
        return dataArray;
    }

    public static byte[] getBytes2Write(String cmd) {
        ArrayList<Byte> bytes2Write = new ArrayList<Byte>();
        for (String token : cmd.split(" ")) {
            byte[] byArray = token.getBytes();
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                Byte b = byArray[i];
                bytes2Write.add(b);
            }
        }
        bytes2Write.add(0, (byte)2);
        bytes2Write.add((byte)64);
        bytes2Write.add((byte)3);
        byte[] bytes = new byte[bytes2Write.size()];
        for (int i = 0; i < bytes2Write.size(); ++i) {
            bytes[i] = (Byte)bytes2Write.get(i);
        }
        bytes[bytes.length - 2] = AkkumatikSerialPort.getChecksum(bytes);
        return bytes;
    }

    public static byte getChecksum(byte[] data) {
        byte chksum = 0;
        if (data[0] == 2 && data[data.length - 1] == 3) {
            for (int i = 0; i < data.length - 2; ++i) {
                chksum = (byte)(chksum ^ data[i] & 0xF);
            }
            chksum = (byte)(chksum | 0x40);
        }
        return chksum;
    }

    public static void main(String[] args) {
        String[] lines = new String[]{"310002000203000000003200320000000000", "310006000200000000006400640000000100", "3105020002000400>803>803>80300000100", "3105020002000400=007=007>80300000100", "3105020002000400=107=007>80300000100", "3105020002000400=207=007>80300000100", "3105020002000400=307=007>80300000100", "3105020002000400=407=007>80300000100", "3105020002000400=507=007>80300000100", "3105020002000400=607=007>80300000100", "3105020002000400=707=007>80300000100", "3105020002000400=807=007>80300000100", "3105020002000400=907=007>80300000100", "3105020002000400=:07=007>80300000100", "3105020002000400=;07=007>80300000100", "3105020002000400=<07=007>80300000100", "3105020002000400==07=007>80300000100", "3105020002000400=>07=007>80300000100", "3105020002000400=?07=007>80300000100", "3105020002000400>007=007>80300000100", "3105020002000400>107=007>80300000100", "3105020002000400>207=007>80300000100", "3105020002000400>307=007>80300000100", "310006000200000000006400640000000100", "3105020002000400>803>803>80300000100", "3105020002000400=007=007>80300000100", "3105020002000400=107=007>80300000100", "3105020002000400=207=007>80300000100", "3105020002000400=307=007>80300000100", "3105020002000400=407=007>80300000100", "3105020002000400=507=007>80300000100", "3105020002000400=607=007>80300000100", "3105020002000400=707=007>80300000100", "3105020002000400=807=007>80300000100", "3105020002000400=907=007>80300000100", "3105020002000400=:07=007>80300000100", "3105020002000400=;07=007>80300000100", "3105020002000400=<07=007>80300000100", "3105020002000400==07=007>80300000100", "3105020002000400=>07=007>80300000100", "3105020002000400=?07=007>80300000100", "3105020002000400>007=007>80300000100", "3105020002000400>107=007>80300000100", "3105020002000400>207=007>80300000100", "3105020002000400>307=007>80300000100", "3106020002000400=007=007>80300000100", "3106020002000400=107=007>80300000100", "3106020002000400=207=007>80300000100", "3106020002000400=307=007>80300000100", "3106020002000400=407=007>80300000100", "3106020002000400=507=007>80300000100", "3106020002000400=607=007>80300000100", "3106020002000400=707=007>80300000100", "3106020002000400=807=007>80300000100", "3106020002000400=907=007>80300000100", "3106020002000400=:07=007>80300000100", "3106020002000400=;07=007>80300000100", "3106020002000400=<07=007>80300000100", "3106020002000400==07=007>80300000100", "3106020002000400=>07=007>80300000100", "3106020002000400=?07=007>80300000100", "3106020002000400>007=007>80300000100", "3106020002000400>107=007>80300000100", "3106020002000400>207=007>80300000100", "3106020002000400>307=007>80300000100", "3106020002000400;80;=007>80300000100", "3106020002000400;90;=007>80300000100", "3106020002000400;:0;=007>80300000100", "3106020002000400;;0;=007>80300000100", "3106020002000400;<0;=007>80300000100", "3106020002000400;=0;=007>80300000100", "3106020002000400;>0;=007>80300000100", "3106020002000400;?0;=007>80300000100", "3106020002000400<00;=007>80300000100", "3106020002000400<10;=007>80300000100", "3106020002000400<20;=007>80300000100", "3101020002030400=007=007>80300000100", "3101020002030400=107=007>80300000100", "3101020002030400=207=007>80300000100", "3101020002030400=307=007>80300000100", "3101020002030400=407=007>80300000100", "3101020002030400=507=007>80300000100", "3101020002030400=607=007>80300000100", "3101020002030400=707=007>80300000100", "3101020002030400=807=007>80300000100", "3101020002030400=907=007>80300000100", "3101020002030400=:07=007>80300000100", "30", "44", "48", "41", "42"};
        AkkumatikDialog.initLogger();
        for (String line : lines) {
            byte[] bytes = AkkumatikSerialPort.getBytes2Write(line);
            bytes[bytes.length - 2] = AkkumatikSerialPort.getChecksum(bytes);
            log.log(gde.log.Level.OFF, new String(bytes));
            log.log(gde.log.Level.OFF, StringHelper.byte2Hex2CharString((byte[])bytes, (int)bytes.length));
            log.log(gde.log.Level.OFF, String.format("calculated checksum = %c (0x%02X)", bytes[bytes.length - 2], bytes[bytes.length - 2]));
        }
    }
}

