/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.device.DeviceConfiguration;
import gde.device.InputTypes;
import gde.device.graupner.Polaron;
import gde.io.DataParser;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;

public class PolaronEx1400
extends Polaron {
    public PolaronEx1400(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
    }

    public PolaronEx1400(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
    }

    @Override
    public Polaron.GraupnerDeviceType getDeviceTypeIdentifier() {
        return Polaron.GraupnerDeviceType.PolaronEx1400;
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int maxVotage = Integer.MIN_VALUE;
        int minVotage = Integer.MAX_VALUE;
        int deviceDataBufferSize = Math.abs(this.getDataBlockSize(InputTypes.SERIAL_IO));
        if (deviceDataBufferSize == dataBuffer.length && this.isLinkedMode(dataBuffer)) {
            try {
                int offset2 = 118;
                points[0] = DataParser.parse2Short((byte[])dataBuffer, (int)11);
                points[2] = DataParser.parse2Short((byte[])dataBuffer, (int)31);
                points[3] = DataParser.parse2Short((byte[])dataBuffer, (int)149);
                points[1] = points[2] + points[3];
                points[5] = DataParser.parse2Short((byte[])dataBuffer, (int)33);
                points[6] = DataParser.parse2Short((byte[])dataBuffer, (int)151);
                points[4] = points[5] + points[6];
                points[8] = DataParser.parse2Short((byte[])dataBuffer, (int)35);
                points[9] = DataParser.parse2Short((byte[])dataBuffer, (int)153);
                points[7] = points[8] + points[9];
                points[11] = Double.valueOf((double)(points[2] * points[5]) / 1000.0).intValue();
                points[12] = Double.valueOf((double)(points[3] * points[6]) / 1000.0).intValue();
                points[10] = points[11] + points[12];
                points[14] = Double.valueOf((double)(points[2] * points[8]) / 1000.0).intValue();
                points[15] = Double.valueOf((double)(points[3] * points[9]) / 1000.0).intValue();
                points[13] = points[14] + points[15];
                points[16] = DataParser.parse2Short((byte[])dataBuffer, (int)37);
                if (DataParser.parse2Short((byte[])dataBuffer, (int)39) == 0) {
                    points[16] = -1 * points[16];
                }
                points[17] = DataParser.parse2Short((byte[])dataBuffer, (int)155);
                if (DataParser.parse2Short((byte[])dataBuffer, (int)39) == 0) {
                    points[17] = -1 * points[17];
                }
                points[18] = 0;
                int i = 0;
                int j = 0;
                while (i < 8) {
                    points[i + 19] = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 45));
                    if (points[i + 19] > 0) {
                        maxVotage = points[i + 19] > maxVotage ? points[i + 19] : maxVotage;
                        minVotage = points[i + 19] < minVotage ? points[i + 19] : minVotage;
                    }
                    ++i;
                    j += 2;
                }
                i = 0;
                j = 0;
                while (i < 8) {
                    points[i + 27] = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 45 + 118));
                    if (points[i + 27] > 0) {
                        maxVotage = points[i + 27] > maxVotage ? points[i + 27] : maxVotage;
                        minVotage = points[i + 27] < minVotage ? points[i + 27] : minVotage;
                    }
                    ++i;
                    j += 2;
                }
                points[18] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                points[35] = DataParser.parse2Short((byte[])dataBuffer, (int)95) + DataParser.parse2Short((byte[])dataBuffer, (int)213);
                i = 0;
                j = 0;
                while (i < 8) {
                    points[i + 36] = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 61));
                    ++i;
                    j += 2;
                }
                i = 0;
                j = 0;
                while (i < 8) {
                    points[i + 44] = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 61 + 118));
                    ++i;
                    j += 2;
                }
            }
            catch (NumberFormatException e) {
                Polaron.log.log(Level.WARNING, e.getMessage(), e);
            }
        } else {
            try {
                points[0] = DataParser.parse2Short((byte[])dataBuffer, (int)11);
                points[1] = DataParser.parse2Short((byte[])dataBuffer, (int)31);
                points[2] = DataParser.parse2Short((byte[])dataBuffer, (int)33);
                points[3] = DataParser.parse2Short((byte[])dataBuffer, (int)35);
                points[4] = Double.valueOf((double)(points[1] * points[2]) / 1000.0).intValue();
                points[5] = Double.valueOf((double)(points[1] * points[3]) / 1000.0).intValue();
                points[6] = DataParser.parse2Short((byte[])dataBuffer, (int)37);
                if (DataParser.parse2Short((byte[])dataBuffer, (int)39) == 0) {
                    points[6] = -1 * points[6];
                }
                points[7] = 0;
                int i = 0;
                int j = 0;
                while (i < 8) {
                    points[i + 8] = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 45));
                    if (points[i + 8] > 0) {
                        maxVotage = points[i + 8] > maxVotage ? points[i + 8] : maxVotage;
                        minVotage = points[i + 8] < minVotage ? points[i + 8] : minVotage;
                    }
                    ++i;
                    j += 2;
                }
                points[7] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
                points[16] = DataParser.parse2Short((byte[])dataBuffer, (int)95);
                i = 0;
                j = 0;
                while (i < 8) {
                    points[i + 17] = DataParser.parse2Short((byte[])dataBuffer, (int)(j + 61));
                    ++i;
                    j += 2;
                }
            }
            catch (Exception e) {
                Polaron.log.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return points;
    }

    @Override
    public boolean isProcessing(int outletNum, byte[] dataBuffer) {
        if (outletNum == 1) {
            int processingModeOut1 = this.getProcessingMode(dataBuffer);
            int n = processingModeOut1 = processingModeOut1 > 9 ? 0 : processingModeOut1;
            if (Polaron.log.isLoggable(Level.FINE)) {
                Polaron.log.log(Level.FINE, "processingModeOut1 = " + this.PROCESSING_MODE[processingModeOut1]);
            }
            return processingModeOut1 != 0 && processingModeOut1 != 6;
        }
        if (outletNum == 2) {
            short processingModeOut2 = DataParser.parse2Short((byte[])dataBuffer, (int)131);
            short s = processingModeOut2 = processingModeOut2 > 9 ? (short)0 : processingModeOut2;
            if (Polaron.log.isLoggable(Level.FINE)) {
                Polaron.log.log(Level.FINE, "processingModeOut2 = " + this.PROCESSING_MODE[processingModeOut2]);
            }
            return processingModeOut2 != 0 && processingModeOut2 != 6;
        }
        return false;
    }

    @Override
    public boolean isLinkedMode(byte[] dataBuffer) {
        short processingMode1 = DataParser.parse2Short((byte[])dataBuffer, (int)13);
        short processingType1 = DataParser.parse2Short((byte[])dataBuffer, (int)15);
        short processingMode2 = DataParser.parse2Short((byte[])dataBuffer, (int)131);
        short processingType2 = DataParser.parse2Short((byte[])dataBuffer, (int)133);
        short numCells = DataParser.parse2Short((byte[])dataBuffer, (int)43);
        return processingMode1 == 7 && processingMode2 == 0 && numCells > 8 || processingMode1 == processingMode2 && processingType1 == processingType2 && (processingMode1 == 1 && processingType1 == 6 || processingMode1 == 2 && processingType2 == 4);
    }
}

