/*
 * Decompiled with CFR 0.152.
 */
package gde.ui;

import gde.GDE;
import gde.log.Level;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;

public class StatusBar {
    final Logger log = Logger.getLogger(this.getClass().getName());
    final DataExplorer application = DataExplorer.getInstance();
    final Composite statusComposite;
    Composite connectionComposite;
    Label txText;
    Label rxText;
    Label conText;
    CLabel portButton;
    CLabel txButton;
    CLabel rxButton;
    Composite comComposite;
    Label msgLabel;
    Composite progressComposite;
    ProgressBar progressBar;

    public StatusBar(Composite currentStatusComposite) {
        this.statusComposite = currentStatusComposite;
        RowLayout statusCompositeLayout = new RowLayout(256);
        statusCompositeLayout.center = true;
        this.statusComposite.setLayout((Layout)statusCompositeLayout);
        this.statusComposite.setBackground(this.application.COLOR_BACKGROUND);
        this.statusComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                if (StatusBar.this.log.isLoggable(Level.FINER)) {
                    StatusBar.this.log.log(Level.FINER, "statusComposite.paintControl evt=" + evt);
                }
                Point statusCompositeSize = StatusBar.this.statusComposite.getSize();
                Point comCompositeSize = StatusBar.this.comComposite.getSize();
                int offsetX = comCompositeSize.x + 280;
                int offsetY = (statusCompositeSize.y - 20) / 2;
                int width = statusCompositeSize.x - offsetX - 10;
                StatusBar.this.msgLabel.setBounds(offsetX, offsetY, width, 20);
            }
        });
    }

    public void create() {
        this.connectionComposite = new Composite(this.statusComposite, 0);
        this.connectionComposite.setBackground(this.application.COLOR_BACKGROUND);
        GridLayout composite2Layout1 = new GridLayout();
        composite2Layout1.makeColumnsEqualWidth = true;
        this.connectionComposite.setLayout((Layout)composite2Layout1);
        this.connectionComposite.setLayoutData((Object)new RowData(170, 24));
        this.comComposite = new Composite(this.connectionComposite, 0);
        this.comComposite.setBackground(this.application.COLOR_BACKGROUND);
        FillLayout comCompositeLayout = new FillLayout(256);
        GridData comCompositeLData = new GridData();
        comCompositeLData.verticalAlignment = 4;
        comCompositeLData.horizontalAlignment = 4;
        comCompositeLData.grabExcessVerticalSpace = true;
        this.comComposite.setLayoutData((Object)comCompositeLData);
        this.comComposite.setLayout((Layout)comCompositeLayout);
        this.portButton = new CLabel(this.comComposite, 0);
        this.portButton.setBounds(2, 2, 50, 20);
        this.portButton.setForeground(this.application.COLOR_DARK_GREEN);
        this.portButton.setBackground(this.application.COLOR_BACKGROUND);
        this.portButton.setImage(SWTResourceManager.getImage("gde/resource/LEDGreen.gif"));
        this.conText = new Label(this.comComposite, 16384);
        this.conText.setText("CON");
        this.conText.setFont(SWTResourceManager.getFont((Control)this.statusComposite.getParent(), GDE.WIDGET_FONT_SIZE - 2, 0));
        this.conText.setBackground(this.application.COLOR_BACKGROUND);
        this.conText.setForeground(this.application.COLOR_FOREGROUND);
        this.rxButton = new CLabel(this.comComposite, 0x1000000);
        this.rxButton.setBounds(2, 2, 50, 20);
        this.rxButton.setForeground(this.application.COLOR_DARK_GREEN);
        this.rxButton.setBackground(this.application.COLOR_BACKGROUND);
        this.rxButton.setImage(SWTResourceManager.getImage("gde/resource/LEDGreen.gif"));
        this.rxText = new Label(this.comComposite, 16384);
        this.rxText.setBackground(this.application.COLOR_BACKGROUND);
        this.rxText.setForeground(this.application.COLOR_FOREGROUND);
        this.rxText.setFont(SWTResourceManager.getFont((Control)this.statusComposite.getParent(), GDE.WIDGET_FONT_SIZE - 2, 0));
        this.rxText.setText("RX");
        this.txButton = new CLabel(this.comComposite, 0x1000000);
        this.txButton.setBounds(2, 2, 50, 20);
        this.txButton.setBackground(this.application.COLOR_BACKGROUND);
        this.txButton.setImage(SWTResourceManager.getImage("gde/resource/LEDGreen.gif"));
        this.txText = new Label(this.comComposite, 16384);
        this.txText.setBackground(this.application.COLOR_BACKGROUND);
        this.txText.setForeground(this.application.COLOR_FOREGROUND);
        this.txText.setFont(SWTResourceManager.getFont((Control)this.statusComposite.getParent(), GDE.WIDGET_FONT_SIZE - 2, 0));
        this.txText.setText("TX");
        this.comComposite.pack();
        this.progressComposite = new Composite(this.statusComposite, 0);
        this.progressComposite.setBackground(this.application.COLOR_BACKGROUND);
        FillLayout progressCompositeLayout = new FillLayout(256);
        this.progressComposite.setLayout((Layout)progressCompositeLayout);
        this.progressBar = new ProgressBar(this.progressComposite, 0);
        this.progressBar.setBounds(2, 2, 250, 20);
        this.progressBar.setBackground(this.application.COLOR_BACKGROUND);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setSelection(0);
        this.progressComposite.pack();
        this.msgLabel = new Label(this.statusComposite, 16388);
        this.msgLabel.setBackground(this.application.COLOR_BACKGROUND);
        this.msgLabel.setForeground(this.application.COLOR_FOREGROUND);
        this.msgLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
        this.statusComposite.pack();
    }

    public void setMessage(String text, int swtColor) {
        this.msgLabel.setForeground(SWTResourceManager.getColor(swtColor));
        this.msgLabel.setText(text);
    }

    public void setMessage(String text) {
        this.msgLabel.setForeground(DataExplorer.getInstance().COLOR_FOREGROUND);
        this.msgLabel.setText(text);
    }

    public void setProgress(int percentage) {
        this.progressBar.setSelection(percentage);
    }

    public int getProgressPercentage() {
        return this.progressBar.getSelection();
    }

    public void setSerialRxOn() {
        if (!this.rxButton.isDisposed()) {
            this.rxButton.setImage(SWTResourceManager.getImage("gde/resource/LEDHotGreen.gif"));
            this.rxButton.redraw();
        }
    }

    public void setSerialRxOff() {
        if (!this.rxButton.isDisposed()) {
            this.rxButton.setImage(SWTResourceManager.getImage("gde/resource/LEDGreen.gif"));
            this.rxButton.redraw();
        }
    }

    public void setSerialTxOn() {
        if (!this.txButton.isDisposed()) {
            this.txButton.setImage(SWTResourceManager.getImage("gde/resource/LEDHotGreen.gif"));
            this.txButton.redraw();
        }
    }

    public void setSerialTxOff() {
        if (!this.txButton.isDisposed()) {
            this.txButton.setImage(SWTResourceManager.getImage("gde/resource/LEDGreen.gif"));
            this.txButton.redraw();
        }
    }

    public void setSerialPortConnected() {
        if (!this.portButton.isDisposed()) {
            this.portButton.setImage(SWTResourceManager.getImage("gde/resource/LEDHotGreen.gif"));
            this.portButton.redraw();
        }
    }

    public void setSerialPortDisconnected() {
        if (!this.portButton.isDisposed()) {
            this.portButton.setImage(SWTResourceManager.getImage("gde/resource/LEDGreen.gif"));
            this.portButton.redraw();
        }
    }

    public void updateColorSchema() {
        this.statusComposite.setBackground(this.application.COLOR_BACKGROUND);
        this.connectionComposite.setBackground(this.application.COLOR_BACKGROUND);
        this.comComposite.setBackground(this.application.COLOR_BACKGROUND);
        this.portButton.setBackground(this.application.COLOR_BACKGROUND);
        this.conText.setBackground(this.application.COLOR_BACKGROUND);
        this.conText.setForeground(this.application.COLOR_FOREGROUND);
        this.rxButton.setBackground(this.application.COLOR_BACKGROUND);
        this.rxText.setBackground(this.application.COLOR_BACKGROUND);
        this.rxText.setForeground(this.application.COLOR_FOREGROUND);
        this.txButton.setBackground(this.application.COLOR_BACKGROUND);
        this.txText.setBackground(this.application.COLOR_BACKGROUND);
        this.txText.setForeground(this.application.COLOR_FOREGROUND);
        this.progressBar.setBackground(this.application.COLOR_BACKGROUND);
        this.msgLabel.setBackground(this.application.COLOR_BACKGROUND);
    }
}

