/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.Analyzer;
import gde.DataAccess;
import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.device.DeviceConfiguration;
import gde.histo.ui.datasources.SupplementObjectFolder;
import gde.histo.utils.PathUtils;
import gde.io.OsdReaderWriter;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import gde.utils.ObjectKeyScanner;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ObjectKeyCompliance {
    private static final String $CLASS_NAME = ObjectKeyCompliance.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);

    public static void rebuildObjectKeys() {
        ObjectKeyScanner objLnkSearch = new ObjectKeyScanner(true);
        objLnkSearch.start();
        try {
            objLnkSearch.join();
        }
        catch (InterruptedException e1) {
            log.log(Level.WARNING, e1.getMessage(), e1);
        }
        if (!GDE.isWithUi()) {
            ObjectKeyCompliance.removeObjectKeys(objLnkSearch.getObsoleteObjectKeys());
        } else if (!objLnkSearch.getObsoleteObjectKeys().isEmpty()) {
            Collections.sort(objLnkSearch.getObsoleteObjectKeys(), String.CASE_INSENSITIVE_ORDER);
            String message = Messages.getString("GDE_MSGI0063", new Object[]{objLnkSearch.getObsoleteObjectKeys()});
            if (64 == DataExplorer.getInstance().openYesNoMessageDialogSync(message)) {
                ObjectKeyCompliance.removeObjectKeys(objLnkSearch.getObsoleteObjectKeys());
            }
        } else if (GDE.shell.isDisposed()) {
            DataExplorer.getInstance().openMessageDialogAsync(Messages.getString("GDE_MSGI0034"));
        } else {
            DataExplorer.getInstance().openMessageDialogAsync(GDE.shell, Messages.getString("GDE_MSGI0034"));
        }
    }

    public static void addObjectKeys(Collection<String> newObjectKeys) {
        Set<String> objectListClone = Settings.getInstance().getRealObjectKeys().collect(Collectors.toSet());
        if (objectListClone.addAll(newObjectKeys)) {
            for (String tmpObjectKey : newObjectKeys) {
                Path objectKeyDirPath = Paths.get(Settings.getInstance().getDataFilePath(), new String[0]).resolve(tmpObjectKey);
                FileUtils.checkDirectoryAndCreate(objectKeyDirPath.toString());
            }
            Settings.getInstance().setObjectList(objectListClone.toArray(new String[0]), Settings.getInstance().getActiveObject());
            log.log(Level.FINE, "object list updated and directories created for object keys : ", newObjectKeys);
        }
    }

    private static void replaceObjectKey(String oldObjKey, String newObjKey, String[] newObjectKeys) {
        for (int selectionIndex = newObjectKeys.length - 1; selectionIndex >= 0; --selectionIndex) {
            if (!newObjectKeys[selectionIndex].equals(oldObjKey)) continue;
            newObjectKeys[selectionIndex] = newObjKey;
            break;
        }
        Settings.getInstance().setObjectList(newObjectKeys, newObjKey);
    }

    public static void addObjectKey(String newObjKey, String[] objectKeys) {
        String[] newObjectKeys = new String[objectKeys.length + 1];
        System.arraycopy(objectKeys, 0, newObjectKeys, 0, objectKeys.length);
        newObjectKeys[newObjectKeys.length - 1] = newObjKey;
        Settings.getInstance().setObjectList(newObjectKeys, newObjKey);
    }

    public static void renameObjectKey(String oldObjKey, String newObjKey, String[] newObjectKeys) {
        if (!oldObjKey.isEmpty()) {
            int answer = 64;
            if (GDE.isWithUi()) {
                answer = DataExplorer.getInstance().openYesNoMessageDialog(Messages.getString("GDE_MSGI0048", new String[]{oldObjKey, newObjKey}));
            }
            if (answer == 64) {
                OsdReaderWriter.updateObjectKey(oldObjKey, newObjKey);
                DataExplorer.getInstance().updateCurrentObjectData(newObjKey);
                new ObjectKeyScanner(newObjKey).start();
            }
            if (FileUtils.checkDirectoryExist(Settings.getInstance().getDataFilePath() + "/" + oldObjKey) && (!GDE.isWithUi() || 64 == DataExplorer.getInstance().openYesNoMessageDialog(Messages.getString("GDE_MSGW0031")))) {
                FileUtils.deleteDirectory(Settings.getInstance().getDataFilePath() + "/" + oldObjKey);
            }
        }
        ObjectKeyCompliance.replaceObjectKey(oldObjKey, newObjKey, newObjectKeys);
        ObjectKeyCompliance.checkChannelForObjectKeyMissmatch(newObjKey);
    }

    public static void removeObjectKey(String[] newObjectKeys, int removeIndex) {
        ArrayList<String> tmpObjectKeys = new ArrayList<String>(Arrays.asList(newObjectKeys));
        String delObjectKey = ((String)tmpObjectKeys.remove(removeIndex)).trim();
        int index = removeIndex >= 2 && !delObjectKey.isEmpty() ? removeIndex - 1 : (tmpObjectKeys.size() > 1 ? 1 : 0);
        Settings.getInstance().setObjectList(tmpObjectKeys.toArray(new String[1]), (String)tmpObjectKeys.get(index));
        if (!delObjectKey.isEmpty()) {
            FileUtils.deleteDirectory(Settings.getInstance().getDataFilePath() + "/" + delObjectKey);
        }
    }

    public static void removeObjectKeys(Collection<String> obsoleteObjectKeys) {
        List<String> realObjectKeys = Settings.getInstance().getRealObjectKeys().collect(Collectors.toList());
        for (String tmpObjectKey : obsoleteObjectKeys) {
            realObjectKeys.remove(tmpObjectKey);
        }
        Settings.getInstance().setObjectList(realObjectKeys.toArray(new String[0]), Settings.getInstance().getActiveObject());
        if (GDE.isWithUi()) {
            DataExplorer.getInstance().setObjectListElements();
        }
    }

    public static void createObjectKey(String newObjectKey) {
        ObjectKeyCompliance.addObjectKey(newObjectKey, Settings.getInstance().getObjectList());
        ObjectKeyCompliance.checkChannelForObjectKeyMissmatch(newObjectKey);
        DataExplorer.getInstance().setObjectListElements();
        DataExplorer.getInstance().setObjectDescriptionTabVisible(true);
        DataExplorer.getInstance().updateObjectDescriptionWindow();
        FileUtils.checkDirectoryAndCreate(Settings.getInstance().getDataFilePath() + "/" + newObjectKey);
        new ObjectKeyScanner(newObjectKey).start();
    }

    public static String getUpcomingObjectKey(Path filePath) {
        String upcomingObjectKey = "";
        if (GDE.isWithUi()) {
            Path fileSubPath;
            try {
                fileSubPath = Paths.get(Settings.getInstance().getDataFilePath(), new String[0]).relativize(filePath);
            }
            catch (Exception e) {
                return upcomingObjectKey;
            }
            if (fileSubPath.getNameCount() < 1) {
                return upcomingObjectKey;
            }
            String directoryName = fileSubPath.subpath(0, 1).toString();
            if (directoryName.length() < 2 || "..".equals(directoryName)) {
                return upcomingObjectKey;
            }
            if (Settings.getInstance().isHistoActive() && Settings.getInstance().isObjectQueryActive() && !DataExplorer.getInstance().isObjectSelectorEditable() && !Analyzer.getInstance().getDeviceConfigurations().contains(directoryName) && !Settings.getInstance().getValidatedObjectKey(directoryName).isPresent() && 128 != DataExplorer.getInstance().openYesNoMessageDialogSync(Messages.getString("GDE_MSGT0929", new Object[]{directoryName}))) {
                upcomingObjectKey = directoryName;
            }
        }
        return upcomingObjectKey;
    }

    private static ArrayList<Path> getSourcePaths() {
        ArrayList<Path> dirPaths = new ArrayList<Path>();
        String dataFilePath = Settings.getInstance().getDataFilePath();
        if (dataFilePath != null && !dataFilePath.trim().isEmpty() && !dataFilePath.equals("/")) {
            dirPaths.add(Paths.get(dataFilePath, new String[0]));
            log.log(Level.FINE, "data path ", dataFilePath);
        }
        Arrays.stream(Settings.getInstance().getDataFoldersCsv().split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(x$0 -> Paths.get(x$0, new String[0])).forEach(dirPaths::add);
        Arrays.stream(Settings.getInstance().getImportFoldersCsv().split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(x$0 -> Paths.get(x$0, new String[0])).forEach(dirPaths::add);
        return dirPaths;
    }

    public static Set<String> defineObjectKeyCandidates(Map<String, DeviceConfiguration> devices) {
        HashSet<String> excludedLowerCaseNames = new HashSet<String>();
        excludedLowerCaseNames.add(SupplementObjectFolder.getSupplementObjectsPath().getFileName().toString().toLowerCase());
        devices.keySet().stream().map(String::toLowerCase).forEach(excludedLowerCaseNames::add);
        return ObjectKeyCompliance.readSourcePathsObjectKeys(excludedLowerCaseNames);
    }

    public static Set<String> defineObjectKeyNovelties(Map<String, DeviceConfiguration> devices) {
        HashSet<String> excludedLowerCaseNames = new HashSet<String>();
        excludedLowerCaseNames.add(SupplementObjectFolder.getSupplementObjectsPath().getFileName().toString().toLowerCase());
        devices.keySet().stream().map(String::toLowerCase).forEach(excludedLowerCaseNames::add);
        Settings.getInstance().getRealObjectKeys().map(String::toLowerCase).forEach(excludedLowerCaseNames::add);
        return ObjectKeyCompliance.readSourcePathsObjectKeys(excludedLowerCaseNames);
    }

    private static Set<String> readSourcePathsObjectKeys(Set<String> excludedLowerCaseNames) {
        Function<Path, Boolean> isSupplementMirrorRoot = directoryPath -> {
            boolean isRoot = false;
            try {
                Path supplementObjectsPath = SupplementObjectFolder.getSupplementObjectsPath();
                Path subPath = supplementObjectsPath.relativize((Path)directoryPath);
                boolean isFirstLevelSupplement = directoryPath.startsWith(supplementObjectsPath) && subPath.getNameCount() == 1;
                isRoot = isFirstLevelSupplement && subPath.toString().length() > 2 && subPath.toString().substring(0, 2).equals("__");
            }
            catch (IllegalArgumentException e) {
                log.log(Level.FINE, e.getMessage(), SupplementObjectFolder.getSupplementObjectsPath() + " <> other: " + directoryPath);
            }
            return isRoot;
        };
        Function<Path, Boolean> isExcludedName = p -> excludedLowerCaseNames.contains(p.getFileName().toString().toLowerCase());
        Set<String> validLogExtentions = Analyzer.getInstance().getDeviceConfigurations().getValidLogExtentions();
        Function<Path, Boolean> isEmptyFolder = p -> !DataAccess.getInstance().getSourceFolderList((Path)p).map(PathUtils::getFileExtention).map(String::toLowerCase).anyMatch(s -> validLogExtentions.contains(s));
        HashSet<String> directoryNames = new HashSet<String>();
        for (Path dirPath : ObjectKeyCompliance.getSourcePaths()) {
            try {
                Stream<Path> stream = DataAccess.getInstance().getSourceFolders(dirPath);
                try {
                    stream.filter(p -> (Boolean)isSupplementMirrorRoot.apply((Path)p) == false).filter(p -> (Boolean)isExcludedName.apply((Path)p) == false).filter(p -> (Boolean)isEmptyFolder.apply((Path)p) == false).peek(p -> log.log(Level.FINER, "sourcePath =", p)).map(Path::getFileName).map(Path::toString).distinct().forEach(directoryNames::add);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (NoSuchFileException e) {
                log.log(Level.WARNING, "NoSuchFileException", dirPath);
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return directoryNames;
    }

    public static void checkChannelForObjectKeyMissmatch(String newObjectKey) {
        String channelObjKey;
        Channel activeChannel = Channels.getInstance().getActiveChannel();
        if (activeChannel != null && !newObjectKey.equals(channelObjKey = activeChannel.getObjectKey())) {
            int answer = 64;
            if (GDE.isWithUi()) {
                int n = answer = DataExplorer.getInstance().getActiveRecordSet() == null ? 64 : DataExplorer.getInstance().openYesNoMessageDialog(Messages.getString("GDE_MSGT0205", new Object[]{channelObjKey, newObjectKey}));
            }
            if (answer == 64) {
                activeChannel.setObjectKey(newObjectKey);
                String updateFileDescription = activeChannel.getFileDescription();
                if (channelObjKey.length() >= 2 && updateFileDescription.contains(channelObjKey)) {
                    updateFileDescription = newObjectKey.length() >= 2 ? updateFileDescription.substring(0, updateFileDescription.indexOf(channelObjKey)) + newObjectKey + updateFileDescription.substring(updateFileDescription.indexOf(channelObjKey) + channelObjKey.length()) : updateFileDescription.substring(0, updateFileDescription.indexOf(channelObjKey) - 1) + updateFileDescription.substring(updateFileDescription.lastIndexOf(channelObjKey) + channelObjKey.length());
                } else if (newObjectKey.length() >= 2 && !updateFileDescription.contains(newObjectKey)) {
                    updateFileDescription = updateFileDescription.indexOf(" ") == -1 ? updateFileDescription + " " + newObjectKey : updateFileDescription.substring(0, updateFileDescription.indexOf(" ") + 1) + newObjectKey + updateFileDescription.substring(updateFileDescription.indexOf(" "));
                }
                activeChannel.setFileDescription(updateFileDescription);
            }
            if (GDE.isWithUi()) {
                DataExplorer.getInstance().updateAllTabs(false);
            }
        }
    }
}

