/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.transitions;

import gde.data.RecordSet;
import gde.device.ChannelType;
import gde.device.TransitionClassTypes;
import gde.device.TransitionGroupType;
import gde.device.TransitionType;
import gde.histo.transitions.GroupTransitions;
import gde.histo.transitions.PeakDetector;
import gde.histo.transitions.PulseDetector;
import gde.histo.transitions.SlopeDetector;
import gde.histo.transitions.Transition;
import gde.log.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class TransitionCollector {
    private static final String $CLASS_NAME = TransitionCollector.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final RecordSet recordSet;

    public TransitionCollector(RecordSet recordSet) {
        this.recordSet = recordSet;
    }

    public GroupTransitions defineTransitions(int logChannelNumber) {
        GroupTransitions groupTransitions = new GroupTransitions(this.recordSet);
        ChannelType channelType = this.recordSet.getDevice().getDeviceConfiguration().getChannel(logChannelNumber);
        for (TransitionType transitionType : channelType.getTransitions().values()) {
            GroupTransitions.TransitionChronicle transitionsFromRecord = this.findTransitions(this.recordSet, transitionType);
            if (transitionsFromRecord.isEmpty()) continue;
            log.fine(() -> String.format("%d  transitionCount=%d", transitionType.getTransitionId(), 999));
            Iterable iterable = channelType.getTransitionGroups().values().stream().filter(group -> group.getTransitionMapping().stream().anyMatch(mapping -> mapping.getTransitionId() == transitionType.getTransitionId()))::iterator;
            for (TransitionGroupType transitionGroupType : iterable) {
                if (!groupTransitions.containsKey(transitionGroupType.getTransitionGroupId())) {
                    groupTransitions.put(transitionGroupType.getTransitionGroupId(), new GroupTransitions.TransitionChronicle());
                }
                GroupTransitions.TransitionChronicle transitionChronicle = groupTransitions.get(transitionGroupType.getTransitionGroupId());
                transitionChronicle.putAll(this.getSuperiorTransitions(transitionsFromRecord, transitionChronicle));
                List<Long> duplicates = this.getDuplicates(transitionChronicle);
                for (long timeStamp_ms : duplicates) {
                    transitionChronicle.remove(timeStamp_ms);
                }
                if (duplicates.isEmpty()) continue;
                log.fine(() -> String.format("%d  removals due to general overlap:  duplicatesSize=%d", transitionType.getTransitionId(), duplicates.size()));
            }
        }
        return groupTransitions;
    }

    private GroupTransitions.TransitionChronicle findTransitions(RecordSet recordSet, TransitionType transitionType) {
        GroupTransitions.TransitionChronicle transitionsFromRecord;
        if (transitionType.getClassType() == TransitionClassTypes.PEAK) {
            PeakDetector histoTransitions = new PeakDetector(recordSet);
            transitionsFromRecord = histoTransitions.findTransitions(recordSet.get(recordSet.getRecordNames()[transitionType.getRefOrdinal()]), transitionType);
        } else if (transitionType.getClassType() == TransitionClassTypes.PULSE) {
            PulseDetector histoTransitions = new PulseDetector(recordSet);
            transitionsFromRecord = histoTransitions.findTransitions(recordSet.get(recordSet.getRecordNames()[transitionType.getRefOrdinal()]), transitionType);
        } else if (transitionType.getClassType() == TransitionClassTypes.SLOPE) {
            SlopeDetector histoTransitions = new SlopeDetector(recordSet);
            transitionsFromRecord = histoTransitions.findTransitions(recordSet.get(recordSet.getRecordNames()[transitionType.getRefOrdinal()]), transitionType);
        } else {
            throw new UnsupportedOperationException();
        }
        return transitionsFromRecord;
    }

    private List<Long> getDuplicates(GroupTransitions.TransitionChronicle transitionChronicle) {
        ArrayList<Long> duplicates = new ArrayList<Long>();
        Map.Entry<Long, Transition> previousTransitionEntry = null;
        for (Map.Entry<Long, Transition> transitionEntry : transitionChronicle.entrySet()) {
            if (previousTransitionEntry != null) {
                Map.Entry inferiorTransitionEntry = this.getInferiorTransition(previousTransitionEntry, transitionEntry).orElse(null);
                if (inferiorTransitionEntry == null) {
                    previousTransitionEntry = transitionEntry;
                    continue;
                }
                if (previousTransitionEntry.equals(inferiorTransitionEntry)) {
                    duplicates.add(previousTransitionEntry.getKey());
                    previousTransitionEntry = transitionEntry;
                    continue;
                }
                duplicates.add(transitionEntry.getKey());
                continue;
            }
            previousTransitionEntry = transitionEntry;
        }
        return duplicates;
    }

    private GroupTransitions.TransitionChronicle getSuperiorTransitions(GroupTransitions.TransitionChronicle newChronicle, GroupTransitions.TransitionChronicle baseChronicle) {
        GroupTransitions.TransitionChronicle newTransitions = new GroupTransitions.TransitionChronicle(newChronicle);
        if (!baseChronicle.isEmpty()) {
            HashSet<? extends Long> intersection = new HashSet<Long>(newTransitions.keySet());
            intersection.retainAll(baseChronicle.keySet());
            Iterator iterator = intersection.iterator();
            while (iterator.hasNext()) {
                long thresholdStartTimeStamp_ms = (Long)iterator.next();
                Map.Entry<Long, Transition> newTransition = newTransitions.ceilingEntry(thresholdStartTimeStamp_ms);
                this.getInferiorTransition(baseChronicle.ceilingEntry(thresholdStartTimeStamp_ms), newChronicle.ceilingEntry(thresholdStartTimeStamp_ms)).ifPresent(x -> {
                    if (newTransition.equals(x)) {
                        newTransitions.remove(thresholdStartTimeStamp_ms);
                    } else {
                        baseChronicle.remove(thresholdStartTimeStamp_ms);
                    }
                });
            }
            if (!intersection.isEmpty()) {
                log.fine(() -> String.format("removals due to same timestamp:  intersectionSize=%d", intersection.size()));
            }
        }
        return newTransitions;
    }

    private Optional<Map.Entry<Long, Transition>> getInferiorTransition(Map.Entry<Long, Transition> entry1, Map.Entry<Long, Transition> entry2) {
        boolean isTransition2Prioritized;
        Optional<Map.Entry<Object, Object>> inferiorTransition = Optional.empty();
        Transition transition2 = entry2.getValue();
        Transition transition1 = entry1.getValue();
        boolean isOverlap = transition2.getReferenceStartTimeStamp_ms() < transition1.getThresholdEndTimeStamp_ms() && transition1.getReferenceStartTimeStamp_ms() < transition2.getThresholdEndTimeStamp_ms();
        boolean isTransition1Prioritized = transition1.isPeak() && !transition2.isPeak() || transition1.isPulse() && !transition2.isPeak() && !transition2.isPulse();
        boolean bl = isTransition2Prioritized = transition2.isPeak() && !transition1.isPeak() || transition2.isPulse() && !transition1.isPeak() && !transition1.isPulse();
        if (isOverlap) {
            long transition2Duration;
            long transition1Duration;
            inferiorTransition = isTransition1Prioritized ? Optional.of(entry2) : (isTransition2Prioritized ? Optional.of(entry1) : ((transition1Duration = transition1.getThresholdEndTimeStamp_ms() - transition1.getReferenceStartTimeStamp_ms()) < (transition2Duration = transition2.getThresholdEndTimeStamp_ms() - transition2.getReferenceStartTimeStamp_ms()) ? Optional.of(entry2) : (transition2Duration < transition1Duration ? Optional.of(entry1) : Optional.of(entry1))));
        }
        inferiorTransition.ifPresent(x -> log.finer(() -> "discarded due to " + (isTransition1Prioritized || isTransition2Prioritized ? "class:  " : "duration:  ") + x.getValue()));
        return inferiorTransition;
    }
}

