/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.comm.DeviceCommPort;
import gde.config.Settings;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.Library;
import gde.utils.StringHelper;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Logger;

public class WindowsHelper {
    private static final String WINDOWS_SERIAL_PORT_COM = "COM";
    private static final Logger log = Logger.getLogger(WindowsHelper.class.getName());

    public static void main(String[] args) {
        System.out.println(WindowsHelper.findApplicationPath("googleearth.exe"));
        System.out.println(WindowsHelper.findApplicationPath("hugo.exe"));
        System.out.println(WindowsHelper.findApplicationPath("dataexplorer.exe"));
    }

    public static void registerSerialPorts() {
        long startTime = new Date().getTime();
        String[] enumPorts = WindowsHelper.enumerateSerialPorts();
        if (enumPorts[0].startsWith("GDE_MSG")) {
            for (int i = 0; i < enumPorts.length; ++i) {
                log.log(Level.WARNING, enumPorts[i]);
            }
            log.log(Level.WARNING, Messages.getString("GDE_MSGW0035", new Object[]{enumPorts[0].split(";")[1]}));
            return;
        }
        boolean isSkipBlootoothDevices = Settings.getInstance().isSkipBluetoothDevices();
        TreeMap<Integer, String> winPorts = DeviceCommPort.getWindowsPorts();
        winPorts.clear();
        for (String portString : enumPorts) {
            if (portString == null || portString.length() <= 1 || isSkipBlootoothDevices && portString.toLowerCase().contains("bluetooth")) continue;
            try {
                int portNumber = Integer.parseInt(portString.substring(portString.indexOf("(COM") + 4, portString.lastIndexOf(41)));
                String[] tmpDesc = portString.split(";");
                String portDescription = tmpDesc[1].substring(0, tmpDesc[1].indexOf("(COM") - 1);
                String manufacturer = tmpDesc[0].split(" ")[0].replace('.', ' ').trim();
                if (manufacturer.length() > 1 && !manufacturer.startsWith("(") && !portDescription.contains(manufacturer)) {
                    portDescription = manufacturer + " " + portDescription;
                }
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, WINDOWS_SERIAL_PORT_COM + portNumber + " - " + portDescription);
                }
                winPorts.put(portNumber, portDescription);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, portString);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            Iterator<Integer> iterator = winPorts.keySet().iterator();
            while (iterator.hasNext()) {
                int number = (Integer)iterator.next();
                log.log(Level.FINE, WINDOWS_SERIAL_PORT_COM + number + " - " + winPorts.get(number));
            }
        }
        if (winPorts.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int number : winPorts.keySet()) {
                sb.append(WINDOWS_SERIAL_PORT_COM).append(number).append(File.pathSeparator);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "set property gnu.io.rxtx.SerialPorts = " + sb.toString());
            }
            System.setProperty("gnu.io.rxtx.SerialPorts", sb.toString());
        } else {
            System.setProperty("gnu.io.rxtx.SerialPorts", "");
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "enum Windows ports  takes = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
        }
    }

    public static native String createDesktopLink(String var0, String var1, String var2, String var3, String var4, int var5, String var6);

    public static native String getFilePathFromLink(String var0);

    public static native String[] enumerateSerialPorts();

    public static native String findApplicationPath(String var0);

    static {
        try {
            String prop = System.getProperty("sun.arch.data.model");
            if (prop == null) {
                prop = System.getProperty("com.ibm.vm.bitmode");
            }
            log.log(Level.INFO, "bitmode = " + prop);
            Library.loadLibrary("WinHelper" + prop);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, t.getMessage(), t);
            if (t instanceof UnsatisfiedLinkError) {
                DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGE0037", new Object[]{t.getClass().getSimpleName()}) + Messages.getString("GDE_MSGI0033"));
            }
            DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGE0038", new Object[]{t.getLocalizedMessage()}));
        }
    }
}

