/*
 * Decompiled with CFR 0.152.
 */
package gde.device.schulze;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.PropertyType;
import gde.device.schulze.DataParserNext;
import gde.device.schulze.NextGen8;
import gde.device.schulze.NextGenSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.DevicePropertiesInconsistenceException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.WaitTimer;
import java.util.logging.Logger;

public class GathererThread
extends Thread {
    static final String $CLASS_NAME = GathererThread.class.getName();
    static final Logger log = Logger.getLogger(GathererThread.class.getName());
    static final int WAIT_TIME_RETRYS = 3600;
    final DataExplorer application;
    final NextGenSerialPort serialPort;
    final NextGen8 device;
    final Channels channels;
    final DataParserNext parser;
    String recordSetKey1 = Messages.getString((String)"GDE_MSGT0272");
    String recordSetKey2 = Messages.getString((String)"GDE_MSGT0272");
    int retryCounter = 3600;
    boolean isCollectDataStopped = false;
    int channelNumber;
    Channel channel;
    int stateNumber = 1;
    boolean isProgrammExecuting1 = false;
    boolean isProgrammExecuting2 = false;
    boolean[] isAlerted4Finish = new boolean[]{false, false, false, false};
    boolean isContinuousRecordSet = Settings.getInstance().isContinuousRecordSet();

    public GathererThread(DataExplorer currentApplication, NextGen8 useDevice, NextGenSerialPort useSerialPort) throws ApplicationConfigurationException, SerialPortException {
        super("dataGatherer");
        this.application = currentApplication;
        this.device = useDevice;
        this.serialPort = useSerialPort;
        this.channels = Channels.getInstance();
        this.parser = new DataParserNext(this.device, this.device.getDataBlockTimeUnitFactor(), this.device.getDataBlockLeader(), this.device.getDataBlockSeparator().value(), this.device.getDataBlockCheckSumType(), 14, 0);
        if (!this.serialPort.isConnected()) {
            this.serialPort.open();
        }
        this.setPriority(10);
    }

    @Override
    public void run() {
        String $METHOD_NAME = "run";
        RecordSet recordSet1 = null;
        RecordSet recordSet2 = null;
        int[] points1 = new int[this.device.getNumberOfMeasurements(1)];
        int[] points2 = new int[this.device.getNumberOfMeasurements(2)];
        byte[] dataBuffer = null;
        this.isProgrammExecuting1 = false;
        this.isProgrammExecuting2 = false;
        this.isCollectDataStopped = false;
        log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", "====> entry initial time step ms = " + this.device.getTimeStep_ms());
        while (!this.isCollectDataStopped) {
            try {
                dataBuffer = this.serialPort.getData();
                this.parser.parse(new String(dataBuffer), 42);
                this.channelNumber = this.parser.getChannelConfigNumber();
                this.stateNumber = this.parser.getState();
                if (log.isLoggable(Level.INFO)) {
                    log.logp(Level.INFO, $CLASS_NAME, "run", this.device.getChannelCount() + " - data for channel = " + this.channelNumber + " state = " + this.stateNumber);
                }
                if (this.channelNumber == 1) {
                    this.isProgrammExecuting1 = this.stateNumber > 0;
                } else {
                    boolean bl = this.isProgrammExecuting2 = this.stateNumber > 0;
                }
                if (this.isProgrammExecuting1 || this.isProgrammExecuting2) {
                    if (this.isProgrammExecuting1) {
                        Object[] ch1 = this.processDataChannel(1, recordSet1, this.recordSetKey1, dataBuffer, points1);
                        recordSet1 = (RecordSet)ch1[0];
                        this.recordSetKey1 = (String)ch1[1];
                    }
                    if (this.isProgrammExecuting2) {
                        Object[] ch2 = this.processDataChannel(2, recordSet2, this.recordSetKey2, dataBuffer, points2);
                        recordSet2 = (RecordSet)ch2[0];
                        this.recordSetKey2 = (String)ch2[1];
                    }
                    if (!this.isProgrammExecuting1 && recordSet1 != null && recordSet1.getRecordDataSize(true) > 5) {
                        this.finalizeRecordSet(recordSet1.getName());
                        this.isProgrammExecuting1 = false;
                        recordSet1 = null;
                    }
                    if (this.isProgrammExecuting2 || recordSet2 == null || recordSet2.getRecordDataSize(true) <= 5) continue;
                    this.finalizeRecordSet(recordSet2.getName());
                    this.isProgrammExecuting2 = false;
                    recordSet2 = null;
                    continue;
                }
                this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI1702"));
                log.logp(java.util.logging.Level.FINER, $CLASS_NAME, "run", "wait for device activation");
                if (0 == this.setRetryCounter(this.getRetryCounter() - 1)) {
                    log.log(java.util.logging.Level.FINE, "device activation timeout");
                    this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW1700"));
                    this.stopDataGatheringThread(false, null);
                }
                if (recordSet1 != null && recordSet1.getRecordDataSize(true) > 5) {
                    this.finalizeRecordSet(recordSet1.getName());
                    this.isProgrammExecuting1 = false;
                    recordSet1 = null;
                }
                if (recordSet2 == null || recordSet2.getRecordDataSize(true) <= 5) continue;
                this.finalizeRecordSet(recordSet2.getName());
                this.isProgrammExecuting2 = false;
                recordSet2 = null;
            }
            catch (DataInconsitsentException e) {
                String message = Messages.getString((String)"GDE_MSGE0036", (Object[])new Object[]{this.getClass().getSimpleName(), "run"});
                if (recordSet1 != null) {
                    this.cleanup(recordSet1.getName(), message);
                }
                if (recordSet2 != null) {
                    this.cleanup(recordSet2.getName(), message);
                }
                this.stopDataGatheringThread(false, e);
            }
            catch (Throwable e) {
                if (e instanceof TimeOutException) {
                    if (recordSet1 != null) {
                        this.finalizeRecordSet(recordSet1.getName());
                        recordSet1 = null;
                        WaitTimer.delay((long)500L);
                    }
                    if (recordSet2 == null) continue;
                    this.finalizeRecordSet(recordSet2.getName());
                    recordSet2 = null;
                    WaitTimer.delay((long)500L);
                    continue;
                }
                if (e instanceof TimeOutException && !this.isProgrammExecuting1 && !this.isProgrammExecuting2) {
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI1702"));
                    log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", "wait for device activation ...");
                    if (0 != this.setRetryCounter(this.getRetryCounter() - 1)) continue;
                    log.log(java.util.logging.Level.FINE, "device activation timeout");
                    this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW1700"));
                    this.stopDataGatheringThread(false, null);
                    continue;
                }
                log.log(java.util.logging.Level.FINE, "program end detected");
                this.stopDataGatheringThread(true, e);
            }
        }
        this.application.setStatusMessage("");
        log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", "======> exit");
    }

    private synchronized Object[] processDataChannel(int number, RecordSet recordSet, String recordSetKey, byte[] dataBuffer, int[] points) throws DataInconsitsentException, DevicePropertiesInconsistenceException {
        Channel channel;
        String $METHOD_NAME = "processOutlet";
        Object[] result = new Object[2];
        String processName = this.device.getRecordSetStateNameReplacement(0);
        PropertyType stateProperty = this.device.getStateProperty(this.stateNumber);
        if (stateProperty == null) {
            throw new DevicePropertiesInconsistenceException(Messages.getString((String)"GDE_MSGW1702", (Object[])new Object[]{this.stateNumber}));
        }
        processName = this.device.getRecordSetStateNameReplacement(this.stateNumber);
        int processNumber = this.stateNumber;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "processName = " + processName + " " + processNumber);
        }
        if ((channel = (Channel)this.channels.get((Object)number)) != null) {
            if (recordSet == null || !recordSetKey.contains(processName)) {
                this.application.setStatusMessage("");
                this.setRetryCounter(3600);
                recordSetKey = channel.getNextRecordSetNumber() + ") " + (this.isContinuousRecordSet ? processName : processName);
                recordSetKey = recordSetKey.length() <= 40 ? recordSetKey : recordSetKey.substring(0, 40);
                channel.put((Object)recordSetKey, (Object)RecordSet.createRecordSet((String)recordSetKey, (IDevice)this.application.getActiveDevice(), (int)channel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                channel.applyTemplateBasics(recordSetKey);
                log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "processOutlet", recordSetKey + " created for channel " + channel.getName());
                recordSet = (RecordSet)channel.get((Object)recordSetKey);
                recordSet.setAllDisplayable();
                this.channels.switchChannel(channel.getNumber(), recordSetKey);
                channel.switchRecordSet(recordSetKey);
            }
            recordSet.addPoints(this.parser.getValues());
            this.application.updateAllTabs(false);
            if (recordSet.get(0).realSize() < 3 || recordSet.get(0).realSize() % 10 == 0) {
                this.device.updateVisibilityStatus(recordSet, true);
            }
        }
        result[0] = recordSet;
        result[1] = recordSetKey;
        return result;
    }

    void stopDataGatheringThread(boolean enableEndMessage, Throwable throwable) {
        String $METHOD_NAME = "stopDataGatheringThread";
        if (throwable != null) {
            log.logp(java.util.logging.Level.WARNING, $CLASS_NAME, "stopDataGatheringThread", throwable.getMessage(), throwable);
        }
        this.isCollectDataStopped = true;
        if (this.serialPort != null) {
            if (this.serialPort.getXferErrors() > 0) {
                log.log(java.util.logging.Level.WARNING, "During complete data transfer " + this.serialPort.getXferErrors() + " number of errors occured!");
            }
            this.serialPort.close();
        }
    }

    void finalizeRecordSet(String recordSetKey) {
        RecordSet tmpRecordSet = this.channels.getActiveChannel().getActiveRecordSet();
        if (tmpRecordSet != null) {
            this.device.updateVisibilityStatus(tmpRecordSet, true);
            this.device.makeInActiveDisplayable(tmpRecordSet);
            this.application.updateStatisticsData();
            this.application.updateDataTable(recordSetKey, false);
            log.log(Level.TIME, "set average time step msec = " + this.device.getAverageTimeStep_ms());
        }
    }

    void cleanup(String recordSetKey, final String message) {
        RecordSet activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet();
        if (activeRecordSet != null) {
            activeRecordSet.clear();
            this.channels.getActiveChannel().remove(recordSetKey);
            if (Thread.currentThread().getId() == this.application.getThreadId()) {
                this.application.getMenuToolBar().updateRecordSetSelectCombo();
                this.application.updateStatisticsData();
                this.application.updateDataTable(recordSetKey, true);
                this.application.openMessageDialog(message);
            } else {
                final String useRecordSetKey = recordSetKey;
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GathererThread.this.application.getMenuToolBar().updateRecordSetSelectCombo();
                        GathererThread.this.application.updateStatisticsData();
                        GathererThread.this.application.updateDataTable(useRecordSetKey, true);
                        GathererThread.this.application.openMessageDialog(message);
                    }
                });
            }
        } else {
            this.application.openMessageDialog(message);
        }
    }

    void setCollectDataStopped(boolean enabled) {
        this.isCollectDataStopped = enabled;
    }

    boolean isCollectDataStopped() {
        return this.isCollectDataStopped;
    }

    int getRetryCounter() {
        return this.retryCounter;
    }

    int setRetryCounter(int newRetryCounter) {
        this.retryCounter = newRetryCounter;
        return this.retryCounter;
    }
}

