/*
 * Decompiled with CFR 0.152.
 */
package gde.device.igc;

import java.util.HashMap;

public class GpsLap
extends HashMap<String, String> {
    private static final long serialVersionUID = -415113738338117060L;

    public GpsLap(String lapInput) {
        this.add(lapInput);
    }

    public void add(String input) {
        String[] entries;
        for (String entry : entries = input.substring(input.indexOf(123) + 1, input.length() - 1).split(",")) {
            String[] value = entry.split(":");
            if (value.length != 2) continue;
            this.put(value[0].substring(1, value[0].length() - 1), value[1]);
        }
    }

    public int getAlt() {
        return Integer.parseInt((String)this.get("alt"));
    }

    public int getAltGainLos() {
        return Integer.parseInt((String)this.get("altGainLos"));
    }

    public int getIndex() {
        return Integer.parseInt((String)this.get("index"));
    }

    public double getTime() {
        return Double.parseDouble((String)this.get("time"));
    }

    public int getIntTime() {
        return Double.valueOf((String)this.get("time")).intValue();
    }

    public String getFormatedTime(int time) {
        int minutes = time / 60;
        return String.format("%2d:%02d", minutes, time - minutes * 60);
    }

    public String toString(int lap, Double duration, String taskType) {
        double lapFlightSpeed_kmh = 0.0;
        double idealLapSpeed_kmh = 0.0;
        double ratio_m = 0.0;
        switch (taskType) {
            case "Light": {
                double trianglePathLength_km = (400.0 + 200.0 * Math.sqrt(2.0) + 200.0 * Math.sqrt(2.0)) / 1000.0;
                double totalPathLength_km = trianglePathLength_km * (double)this.getIndex() / 100.0;
                lapFlightSpeed_kmh = totalPathLength_km / this.getTime() * 3600.0;
                idealLapSpeed_kmh = trianglePathLength_km / this.getTime() * 3600.0;
                ratio_m = this.getAltGainLos() < -15 && this.getIndex() < 130 ? trianglePathLength_km * 1000.0 / (double)this.getAltGainLos() * -1.0 : 0.0;
                break;
            }
            case "Sport": {
                double trianglePathLength_km = (800.0 + 400.0 * Math.sqrt(2.0) + 400.0 * Math.sqrt(2.0)) / 1000.0;
                double totalPathLength_km = trianglePathLength_km * (double)this.getIndex() / 100.0;
                lapFlightSpeed_kmh = totalPathLength_km / this.getTime() * 3600.0;
                idealLapSpeed_kmh = trianglePathLength_km / this.getTime() * 3600.0;
                ratio_m = this.getAltGainLos() < -20 && this.getIndex() < 130 ? trianglePathLength_km * 1000.0 / (double)this.getAltGainLos() * -1.0 : 0.0;
                break;
            }
            default: {
                double trianglePathLength_km = (1000.0 + 500.0 * Math.sqrt(2.0) + 500.0 * Math.sqrt(2.0)) / 1000.0;
                double totalPathLength_km = trianglePathLength_km * (double)this.getIndex() / 100.0;
                lapFlightSpeed_kmh = totalPathLength_km / this.getTime() * 3600.0;
                idealLapSpeed_kmh = trianglePathLength_km / this.getTime() * 3600.0;
                ratio_m = this.getAltGainLos() < -30 && this.getIndex() < 130 ? trianglePathLength_km * 1000.0 / (double)this.getAltGainLos() * -1.0 : 0.0;
            }
        }
        return String.format("%2d  %4d %7s   %7s  %4d  %4d  %5.1f    %5.1f     %5.1f\n", lap, this.getIndex(), this.getFormatedTime(duration.intValue() + this.getIntTime()), this.getFormatedTime(this.getIntTime()), this.getAlt(), this.getAltGainLos(), idealLapSpeed_kmh, lapFlightSpeed_kmh, ratio_m);
    }
}

