/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.datasources;

import gde.Analyzer;
import gde.GDE;
import gde.histo.cache.VaultCollector;
import gde.histo.datasources.DirectoryScanner;
import gde.histo.datasources.SourceDataSet;
import gde.histo.datasources.SourceFolders;
import gde.histo.datasources.VaultChecker;
import gde.histo.exclusions.ExclusionData;
import gde.log.Logger;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class SourceDataSetExplorer {
    private static final String $CLASS_NAME = SourceDataSetExplorer.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    protected final Analyzer analyzer;
    protected final SourceFolders sourceFolders;
    protected Consumer<String> signaler = s -> {};
    private final LongAdder nonWorkableCount = new LongAdder();
    private final List<Path> excludedFiles = new ArrayList<Path>();
    private final List<SourceDataSet> sourceDataSets = new ArrayList<SourceDataSet>();
    private List<VaultCollector> trusses = new ArrayList<VaultCollector>();

    public SourceDataSetExplorer(Analyzer analyzer, SourceFolders sourceFolders, boolean isStatusMessagesActive) {
        this.analyzer = analyzer;
        this.sourceFolders = sourceFolders;
        this.setStatusMessages(isStatusMessagesActive);
    }

    private void listFiles(Map<Path, Set<SourceFolders.DirectoryType>> pathsWithPermissions) {
        this.sourceDataSets.clear();
        this.nonWorkableCount.reset();
        this.excludedFiles.clear();
        int subDirectoryLevelMax = this.analyzer.getSettings().getSubDirectoryLevelMax();
        for (Map.Entry<Path, Set<SourceFolders.DirectoryType>> entry : pathsWithPermissions.entrySet()) {
            try {
                this.sourceDataSets.addAll(this.getFileListing(entry.getKey(), subDirectoryLevelMax, entry.getValue()));
            }
            catch (FileNotFoundException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private List<SourceDataSet> getFileListing(Path rootDirectory, int recursionDepth, Set<SourceFolders.DirectoryType> directoryTypes) throws FileNotFoundException {
        this.signaler.accept("get file names     " + rootDirectory.toString());
        ArrayList<SourceDataSet> sourceDataSets = new ArrayList<SourceDataSet>();
        ExclusionData exclusionData = new ExclusionData(new DirectoryScanner(this.analyzer).getActiveFolder(), this.analyzer.getDataAccess());
        boolean isSuppressMode = this.analyzer.getSettings().isSuppressMode();
        for (String fileName : (String[])this.analyzer.getDataAccess().getSourceFolderList(rootDirectory).toArray(String[]::new)) {
            Path filePath = rootDirectory.resolve(fileName);
            if (this.analyzer.getDataAccess().existsSourceFile(filePath)) {
                SourceDataSet originFile = SourceDataSet.createSourceDataSet(filePath, this.analyzer);
                if (originFile != null && originFile.isWorkableFile(directoryTypes, this.sourceFolders)) {
                    if (!isSuppressMode || !exclusionData.isExcluded(filePath.getFileName().toString())) {
                        sourceDataSets.add(originFile);
                        continue;
                    }
                    this.excludedFiles.add(filePath);
                    log.log(Level.INFO, "file is excluded              ", filePath);
                    continue;
                }
                this.nonWorkableCount.increment();
                continue;
            }
            if (recursionDepth <= 0) continue;
            List<SourceDataSet> deeperList = this.getFileListing(filePath, recursionDepth - 1, directoryTypes);
            sourceDataSets.addAll(deeperList);
        }
        this.signaler.accept("");
        return sourceDataSets;
    }

    public int getNonWorkableCount() {
        return this.nonWorkableCount.intValue();
    }

    public List<Path> getExcludedFiles() {
        return this.excludedFiles;
    }

    public List<SourceDataSet> getSourceFiles() {
        return this.sourceDataSets;
    }

    public void screen4Trusses(Map<Path, Set<SourceFolders.DirectoryType>> pathsWithPermissions, boolean doListFiles) {
        if (doListFiles) {
            this.listFiles(pathsWithPermissions);
        }
        VaultChecker vaultChecker = new VaultChecker(this.analyzer);
        this.trusses = this.sourceDataSets.parallelStream().peek(d -> this.signaler.accept("get file properties    " + d.getActualFile().toString())).flatMap(d -> d.getSelectedTrusses(vaultChecker)).collect(Collectors.toList());
        this.signaler.accept("");
    }

    public void setStatusMessages(boolean isActive) {
        this.signaler = isActive ? s -> GDE.getUiNotification().setStatusMessage((String)s) : s -> {};
    }

    public List<VaultCollector> getTrusses() {
        return this.trusses;
    }
}

