/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.PropertyType;
import gde.device.smmodellbau.LiPoWatchDialog;
import gde.device.smmodellbau.LiPoWatchLiveGatherer;
import gde.device.smmodellbau.LiPoWatchSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.CalculationThread;
import gde.utils.StringHelper;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public class LiPoWatch
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(LiPoWatch.class.getName());
    public static final String LOV_A1_CHECKED = "A1Checked=";
    public static final String LOV_A1_NAME = "A1Name=";
    public static final String LOV_A1_OFFSET = "A1Offset=";
    public static final String LOV_A1_FACTOR = "A1Faktor=";
    public static final String LOV_A1_UNIT = "A1Einheit=";
    public static final String[] LOV_CONFIG_DATA_KEYS_UNILOG_11 = new String[]{"A1Checked=", "A1Name=", "A1Einheit=", "A1Offset=", "A1Faktor="};
    public static final String A1_FACTOR = "a1_" + IDevice.FACTOR;
    public static final String A1_OFFSET = "a1_" + IDevice.OFFSET;
    public static final String FIRMEWARE_VERSION = "Firmware";
    public static final String SERIAL_NUMBER = "S/N";
    final DataExplorer application;
    final LiPoWatchSerialPort serialPort;
    final LiPoWatchDialog dialog;

    public LiPoWatch(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.smmodellbau.lipowatch.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = new LiPoWatchSerialPort(this, this.application);
        this.dialog = new LiPoWatchDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
    }

    public LiPoWatch(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.smmodellbau.lipowatch.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = new LiPoWatchSerialPort(this, this.application);
        this.dialog = new LiPoWatchDialog(this.application.getShell(), this);
        this.configureSerialPortMenu(1, "", "");
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        lov2osdMap.put(LOV_A1_CHECKED, "_isActive=_BOOLEAN");
        lov2osdMap.put(LOV_A1_NAME, "_name");
        lov2osdMap.put(LOV_A1_UNIT, "_unit");
        lov2osdMap.put(LOV_A1_OFFSET, IDevice.OFFSET + "=_DOUBLE");
        lov2osdMap.put(LOV_A1_FACTOR, IDevice.FACTOR + "=_DOUBLE");
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        String recordSetInfo = "";
        for (int j = 0; j < this.getNumberOfMeasurements(1); ++j) {
            StringBuilder recordConfigData = new StringBuilder();
            if (j == 18) {
                HashMap configData = StringHelper.splitString((String)header.get("logview_config_data"), (String)"||::||", (String[])LOV_CONFIG_DATA_KEYS_UNILOG_11);
                for (String lovKey : LOV_CONFIG_DATA_KEYS_UNILOG_11) {
                    if (!configData.containsKey(lovKey)) continue;
                    recordConfigData.append(lov2osdMap.get(lovKey)).append("=").append((String)configData.get(lovKey)).append("|-|");
                }
            }
            recordSetInfo = recordSetInfo + "RecordProperties : " + recordConfigData.toString() + "|:-:|";
        }
        return recordSetInfo;
    }

    public int getLovDataByteSize() {
        return 37;
    }

    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int[] points = new int[this.getNumberOfMeasurements(1)];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        int offset = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            int length = dataBuffer[offset] & 0x7F;
            byte[] readBuffer = new byte[length];
            System.arraycopy(dataBuffer, offset + 4, readBuffer, 0, length);
            recordSet.addPoints(this.convertDataBytes(points, readBuffer));
            offset += length + 4;
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        int i;
        StringBuilder sb = new StringBuilder();
        int tmpValue = 0;
        int totalVotage = 0;
        int maxVotage = Integer.MIN_VALUE;
        int minVotage = Integer.MAX_VALUE;
        points[1] = (((dataBuffer[6] & 0xFF) << 8) + (dataBuffer[5] & 0xFF) & 0xFFF0) / 16 * 1000;
        if (log.isLoggable(Level.FINE)) {
            sb.append("(1)" + points[16]).append("; ");
        }
        points[2] = (((dataBuffer[8] & 0xFF) << 8) + (dataBuffer[7] & 0xFF) & 0xFFF0) / 16 * 1000;
        if (log.isLoggable(Level.FINE)) {
            sb.append("(2)" + points[17]).append("; ");
        }
        int n = points[3] = (tmpValue = ((dataBuffer[14] & 0xFF) << 8) + (dataBuffer[13] & 0xFF)) <= 32768 ? tmpValue * 10 : (tmpValue - 65536) * 10;
        if (log.isLoggable(Level.FINE)) {
            sb.append("(3)" + points[18]).append("; ");
        }
        int numberCells = dataBuffer[5] & 0xF;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "numberCells = " + numberCells);
        }
        for (i = 0; i < numberCells; ++i) {
            tmpValue = ((dataBuffer[2 * i + 16] & 0xFF) << 8) + (dataBuffer[2 * i + 15] & 0xFF);
            int n2 = points[i + 5] = tmpValue <= 32786 ? tmpValue * 2 : (tmpValue - 65536) * 2;
            if (log.isLoggable(Level.FINE)) {
                sb.append("(" + (i + 4) + ")" + points[1]).append("; ");
            }
            totalVotage += points[i + 5];
            maxVotage = points[i + 5] > maxVotage ? points[i + 5] : maxVotage;
            minVotage = points[i + 5] < minVotage ? points[i + 5] : minVotage;
        }
        boolean isRelative = (dataBuffer[9] & 0xF0) >> 4 == 1;
        int n3 = points[0] = isRelative ? totalVotage : points[i + 4];
        if (log.isLoggable(Level.FINE)) {
            sb.insert(0, "(0)" + points[0] + "; ");
        }
        int n4 = points[4] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
        if (log.isLoggable(Level.FINE)) {
            sb.append("(" + (i + 4) + ")" + points[1]).append("; ");
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, sb.toString());
        }
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
            points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
            points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
            points[2] = ((convertBuffer[8] & 0xFF) << 24) + ((convertBuffer[9] & 0xFF) << 16) + ((convertBuffer[10] & 0xFF) << 8) + ((convertBuffer[11] & 0xFF) << 0);
            points[3] = ((convertBuffer[12] & 0xFF) << 24) + ((convertBuffer[13] & 0xFF) << 16) + ((convertBuffer[14] & 0xFF) << 8) + ((convertBuffer[15] & 0xFF) << 0);
            points[4] = 0;
            int maxVotage = Integer.MIN_VALUE;
            int minVotage = Integer.MAX_VALUE;
            for (int j = 0; j < points.length - 5; ++j) {
                points[j + 5] = ((convertBuffer[16 + j * 4] & 0xFF) << 24) + ((convertBuffer[17 + j * 4] & 0xFF) << 16) + ((convertBuffer[18 + j * 4] & 0xFF) << 8) + ((convertBuffer[19 + j * 4] & 0xFF) << 0);
                if (points[j + 5] <= 0) continue;
                maxVotage = points[j + 5] > maxVotage ? points[j + 5] : maxVotage;
                minVotage = points[j + 5] < minVotage ? points[j + 5] : minVotage;
            }
            points[4] = maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0;
            recordSet.addPoints(points);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            double offset = 0.0;
            double factor = 1.0;
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                switch (record.getOrdinal()) {
                    case 3: {
                        offset = record.getOffset();
                        factor = record.getFactor();
                        dataTableRow[index + 1] = record.getDecimalFormat().format((offset + (double)record.realGet(rowIndex).intValue() / 1000.0) * factor);
                        break;
                    }
                    case 4: {
                        offset = record.getOffset();
                        factor = record.getFactor();
                        dataTableRow[index + 1] = record.getDecimalFormat().format((offset + (double)record.realGet(rowIndex).intValue() / 1000.0) * factor);
                        break;
                    }
                    default: {
                        dataTableRow[index + 1] = index > 4 && record.getUnit().equals("V") ? String.format("%.3f", (double)record.realGet(rowIndex).intValue() / 1000.0) : record.getDecimalFormat().format((double)record.realGet(rowIndex).intValue() / 1000.0);
                    }
                }
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double newValue = value;
        PropertyType property = null;
        if (record.getOrdinal() == 3) {
            property = record.getProperty(A1_FACTOR);
            double factor = property != null ? Double.valueOf(property.getValue()) : 1.0;
            property = record.getProperty(A1_FACTOR);
            double offset = property != null ? Double.valueOf(property.getValue()) : 0.0;
            newValue = value * factor + offset;
        } else if (record.getOrdinal() == 4) {
            double factor = record.getFactor();
            double offset = record.getOffset();
            newValue = value * factor + offset;
        }
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double newValue = value;
        PropertyType property = null;
        if (record.getOrdinal() == 3) {
            property = record.getProperty(A1_FACTOR);
            double factor = property != null ? Double.valueOf(property.getValue()) : 1.0;
            property = record.getProperty(A1_FACTOR);
            double offset = property != null ? Double.valueOf(property.getValue()) : 0.0;
            newValue = (value - offset) / factor;
        } else if (record.getOrdinal() == 4) {
            double factor = record.getFactor();
            double offset = record.getOffset();
            newValue = (value - offset) / factor;
        }
        return newValue;
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        Record record;
        int i;
        int displayableCounter = 0;
        for (i = 0; i < recordSet.size(); ++i) {
            record = recordSet.get(i);
            boolean hasReasonableData = record.hasReasonableData();
            record.setDisplayable(hasReasonableData);
            if (hasReasonableData) {
                ++displayableCounter;
            }
            if (!log.isLoggable(Level.FINER)) continue;
            log.log(Level.FINER, record.getName() + " setDisplayable=" + hasReasonableData);
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
        if (log.isLoggable(Level.FINE)) {
            for (i = 0; i < recordSet.size(); ++i) {
                record = recordSet.get(i);
                if (!log.isLoggable(Level.FINE)) continue;
                log.log(Level.FINE, record.getName() + " isActive=" + record.isActive() + " isVisible=" + record.isVisible() + " isDisplayable=" + record.isDisplayable());
            }
        }
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        int displayableCounter = 0;
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            if (!record.isActive() || !record.isDisplayable()) continue;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "add to displayable counter: " + record.getName());
            }
            ++displayableCounter;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "displayableCounter = " + displayableCounter);
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    public LiPoWatchDialog getDialog() {
        return this.dialog;
    }

    public LiPoWatchSerialPort getCommunicationPort() {
        return this.serialPort;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION, CalculationThread.REGRESSION_INTERVAL_SEC, CalculationThread.REGRESSION_TYPE};
    }

    public void updateInitialRecordSetComment(RecordSet recordSet) {
        recordSet.setRecordSetDescription(String.format("%s; \n%s : %s; %s : %s; ", recordSet.getRecordSetDescription(), SERIAL_NUMBER, this.getDialog().serialNumber, FIRMEWARE_VERSION, this.getDialog().lipoWatchVersion));
    }

    public void open_closeCommPort() {
        if (this.serialPort != null) {
            if (!this.serialPort.isConnected()) {
                try {
                    Channel activChannel = Channels.getInstance().getActiveChannel();
                    if (activChannel != null) {
                        this.getDialog().liveThread = new LiPoWatchLiveGatherer(this.application, this, this.serialPort, this.getDialog());
                        this.getDialog().setButtonStateLiveGatherer(false);
                        this.getDialog().liveThread.start();
                    }
                }
                catch (SerialPortException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                    this.getDialog().setButtonStateLiveGatherer(true);
                }
                catch (ApplicationConfigurationException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                    this.application.getDeviceSelectionDialog().open();
                    this.getDialog().setButtonStateLiveGatherer(true);
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, t.getMessage(), t);
                    this.getDialog().setButtonStateLiveGatherer(true);
                }
            } else {
                if (this.getDialog().liveThread != null) {
                    this.getDialog().liveThread.stopTimerThread();
                }
                if (this.getDialog().gatherThread != null) {
                    this.getDialog().gatherThread.setThreadStop();
                }
                this.serialPort.close();
                this.getDialog().setButtonStateLiveGatherer(true);
            }
        }
    }

    public int[] getCellVoltageOrdinals() {
        return new int[]{0, 3};
    }

    public String[] crossCheckMeasurements(String[] fileRecordsProperties, RecordSet recordSet) {
        String[] recordKeys = recordSet.getRecordNames();
        Vector<String> cleanedRecordNames = new Vector<String>();
        if (!this.containsBalance(fileRecordsProperties)) {
            for (String tmpRecordName : recordKeys) {
                if (tmpRecordName.toLowerCase().contains("balance")) continue;
                cleanedRecordNames.add(tmpRecordName);
            }
            recordKeys = cleanedRecordNames.toArray(new String[1]);
        }
        if (fileRecordsProperties.length != recordKeys.length) {
            for (int j = fileRecordsProperties.length; j < recordKeys.length; ++j) {
                recordSet.remove(recordKeys[j]);
                log.log(Level.FINER, "removed record " + recordKeys[j]);
            }
            recordKeys = this.crossCheckMeasurements(fileRecordsProperties, recordSet);
        }
        return recordKeys;
    }

    private boolean containsBalance(String[] recordsProperties) {
        boolean isContained = false;
        for (String recordProperties : recordsProperties) {
            boolean bl = isContained = recordProperties.toLowerCase().indexOf("balance", 0) > -1;
            if (isContained) break;
        }
        return isContained;
    }
}

