/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.MediaError;
import com.sun.media.jfxmedia.MediaException;
import com.sun.media.jfxmedia.events.MediaErrorListener;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.NativeMediaManager;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.ListIterator;

public class MediaUtils {
    public static final int MAX_FILE_SIGNATURE_LENGTH = 22;
    static final String NATIVE_MEDIA_ERROR_FORMAT = "Internal media error: %d";
    static final String NATIVE_MEDIA_WARNING_FORMAT = "Internal media warning: %d";
    public static final String CONTENT_TYPE_AIFF = "audio/x-aiff";
    public static final String CONTENT_TYPE_MP3 = "audio/mp3";
    public static final String CONTENT_TYPE_MPA = "audio/mpeg";
    public static final String CONTENT_TYPE_WAV = "audio/x-wav";
    public static final String CONTENT_TYPE_JFX = "video/x-javafx";
    public static final String CONTENT_TYPE_FLV = "video/x-flv";
    public static final String CONTENT_TYPE_MP4 = "video/mp4";
    public static final String CONTENT_TYPE_M4A = "audio/x-m4a";
    public static final String CONTENT_TYPE_M4V = "video/x-m4v";
    public static final String CONTENT_TYPE_M3U8 = "application/vnd.apple.mpegurl";
    public static final String CONTENT_TYPE_M3U = "audio/mpegurl";
    private static final String FILE_TYPE_AIF = "aif";
    private static final String FILE_TYPE_AIFF = "aiff";
    private static final String FILE_TYPE_FLV = "flv";
    private static final String FILE_TYPE_FXM = "fxm";
    private static final String FILE_TYPE_MPA = "mp3";
    private static final String FILE_TYPE_WAV = "wav";
    private static final String FILE_TYPE_MP4 = "mp4";
    private static final String FILE_TYPE_M4A = "m4a";
    private static final String FILE_TYPE_M4V = "m4v";
    private static final String FILE_TYPE_M3U8 = "m3u8";
    private static final String FILE_TYPE_M3U = "m3u";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String fileSignatureToContentType(byte[] byArray, int n) throws MediaException {
        String string2 = "application/octet-stream";
        if (n < 22) {
            throw new MediaException("Empty signature!");
        }
        if (byArray.length < 22) {
            return string2;
        }
        if ((byArray[0] & 0xFF) == 70 && (byArray[1] & 0xFF) == 76 && (byArray[2] & 0xFF) == 86) {
            return CONTENT_TYPE_JFX;
        }
        if (((byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF) == 1380533830 && ((byArray[8] & 0xFF) << 24 | (byArray[9] & 0xFF) << 16 | (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF) == 1463899717 && ((byArray[12] & 0xFF) << 24 | (byArray[13] & 0xFF) << 16 | (byArray[14] & 0xFF) << 8 | byArray[15] & 0xFF) == 1718449184) {
            if ((byArray[20] & 0xFF) == 1) {
                if ((byArray[21] & 0xFF) == 0) return CONTENT_TYPE_WAV;
            }
            if ((byArray[20] & 0xFF) != 3) throw new MediaException("Compressed WAVE is not supported!");
            if ((byArray[21] & 0xFF) != 0) throw new MediaException("Compressed WAVE is not supported!");
            return CONTENT_TYPE_WAV;
        }
        if (((byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF) == 1380533830 && ((byArray[8] & 0xFF) << 24 | (byArray[9] & 0xFF) << 16 | (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF) == 1463899717) {
            return CONTENT_TYPE_WAV;
        }
        if (((byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF) == 1179603533 && ((byArray[8] & 0xFF) << 24 | (byArray[9] & 0xFF) << 16 | (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF) == 1095321158 && ((byArray[12] & 0xFF) << 24 | (byArray[13] & 0xFF) << 16 | (byArray[14] & 0xFF) << 8 | byArray[15] & 0xFF) == 1129270605) {
            return CONTENT_TYPE_AIFF;
        }
        if ((byArray[0] & 0xFF) == 73 && (byArray[1] & 0xFF) == 68 && (byArray[2] & 0xFF) == 51) {
            return CONTENT_TYPE_MPA;
        }
        if ((byArray[0] & 0xFF) == 255 && (byArray[1] & 0xE0) == 224 && (byArray[2] & 0x18) != 8 && (byArray[3] & 6) != 0) {
            return CONTENT_TYPE_MPA;
        }
        if (((byArray[4] & 0xFF) << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF) != 1718909296) throw new MediaException("Unrecognized file signature!");
        if ((byArray[8] & 0xFF) == 77 && (byArray[9] & 0xFF) == 52 && (byArray[10] & 0xFF) == 65 && (byArray[11] & 0xFF) == 32) {
            return CONTENT_TYPE_M4A;
        }
        if ((byArray[8] & 0xFF) == 77 && (byArray[9] & 0xFF) == 52 && (byArray[10] & 0xFF) == 86 && (byArray[11] & 0xFF) == 32) {
            return CONTENT_TYPE_M4V;
        }
        if ((byArray[8] & 0xFF) == 109 && (byArray[9] & 0xFF) == 112 && (byArray[10] & 0xFF) == 52 && (byArray[11] & 0xFF) == 50) {
            return CONTENT_TYPE_MP4;
        }
        if ((byArray[8] & 0xFF) == 105 && (byArray[9] & 0xFF) == 115 && (byArray[10] & 0xFF) == 111 && (byArray[11] & 0xFF) == 109) {
            return CONTENT_TYPE_MP4;
        }
        if ((byArray[8] & 0xFF) != 77) return string2;
        if ((byArray[9] & 0xFF) != 80) return string2;
        if ((byArray[10] & 0xFF) != 52) return string2;
        if ((byArray[11] & 0xFF) != 32) return string2;
        return CONTENT_TYPE_MP4;
    }

    public static String filenameToContentType(String string2) {
        String string3 = "application/octet-stream";
        int n = string2.lastIndexOf(".");
        if (n != -1) {
            String string4 = string2.toLowerCase().substring(n + 1);
            if (string4.equals(FILE_TYPE_AIF) || string4.equals(FILE_TYPE_AIFF)) {
                string3 = CONTENT_TYPE_AIFF;
            } else if (string4.equals(FILE_TYPE_FLV) || string4.equals(FILE_TYPE_FXM)) {
                string3 = CONTENT_TYPE_JFX;
            } else if (string4.equals(FILE_TYPE_MPA)) {
                string3 = CONTENT_TYPE_MPA;
            } else if (string4.equals(FILE_TYPE_WAV)) {
                string3 = CONTENT_TYPE_WAV;
            } else if (string4.equals(FILE_TYPE_MP4)) {
                string3 = CONTENT_TYPE_MP4;
            } else if (string4.equals(FILE_TYPE_M4A)) {
                string3 = CONTENT_TYPE_M4A;
            } else if (string4.equals(FILE_TYPE_M4V)) {
                string3 = CONTENT_TYPE_M4V;
            } else if (string4.equals(FILE_TYPE_M3U8)) {
                string3 = CONTENT_TYPE_M3U8;
            } else if (string4.equals(FILE_TYPE_M3U)) {
                string3 = CONTENT_TYPE_M3U;
            }
        }
        return string3;
    }

    public static void warning(Object object, String string2) {
        if (object != null & string2 != null) {
            Logger.logMsg(3, object.getClass().getName() + ": " + string2);
        }
    }

    public static void error(Object object, int n, String string2, Throwable throwable) {
        Object object2;
        Object object3;
        if (throwable != null && (object3 = throwable.getStackTrace()) != null && ((Object)object3).length > 0) {
            object2 = object3[0];
            Logger.logMsg(4, ((StackTraceElement)object2).getClassName(), ((StackTraceElement)object2).getMethodName(), "( " + ((StackTraceElement)object2).getLineNumber() + ") " + string2);
        }
        if (!(object3 = NativeMediaManager.getDefaultInstance().getMediaErrorListeners()).isEmpty()) {
            object2 = object3.listIterator();
            while (object2.hasNext()) {
                MediaErrorListener mediaErrorListener = (MediaErrorListener)((WeakReference)object2.next()).get();
                if (mediaErrorListener != null) {
                    mediaErrorListener.onError(object, n, string2);
                    continue;
                }
                object2.remove();
            }
        } else {
            object2 = throwable instanceof MediaException ? (MediaException)throwable : new MediaException(string2, throwable);
            throw object2;
        }
    }

    public static void nativeWarning(Object object, int n, String string2) {
        Object object2 = String.format(NATIVE_MEDIA_WARNING_FORMAT, n);
        if (string2 != null) {
            object2 = (String)object2 + ": " + string2;
        }
        Logger.logMsg(3, (String)object2);
    }

    public static void nativeError(Object object, MediaError mediaError) {
        Logger.logMsg(4, mediaError.description());
        List<WeakReference<MediaErrorListener>> list2 = NativeMediaManager.getDefaultInstance().getMediaErrorListeners();
        if (!list2.isEmpty()) {
            ListIterator<WeakReference<MediaErrorListener>> listIterator = list2.listIterator();
            while (listIterator.hasNext()) {
                MediaErrorListener mediaErrorListener = (MediaErrorListener)listIterator.next().get();
                if (mediaErrorListener != null) {
                    mediaErrorListener.onError(object, mediaError.code(), mediaError.description());
                    continue;
                }
                listIterator.remove();
            }
        } else {
            throw new MediaException(mediaError.description(), null, mediaError);
        }
    }
}

