/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.io.Serializable;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.AbstractFieldMatrix;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.FieldMatrixChangingVisitor;
import org.apache.commons.math3.linear.FieldMatrixPreservingVisitor;
import org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Array2DRowFieldMatrix<T extends FieldElement<T>>
extends AbstractFieldMatrix<T>
implements Serializable {
    private static final long serialVersionUID = 7260756672015356458L;
    private T[][] data;

    public Array2DRowFieldMatrix(Field<T> field2) {
        super(field2);
    }

    public Array2DRowFieldMatrix(Field<T> field2, int rowDimension, int columnDimension) throws NotStrictlyPositiveException {
        super(field2, rowDimension, columnDimension);
        this.data = (FieldElement[][])MathArrays.buildArray(field2, rowDimension, columnDimension);
    }

    public Array2DRowFieldMatrix(T[][] d) throws DimensionMismatchException, NullArgumentException, NoDataException {
        this(Array2DRowFieldMatrix.extractField(d), (FieldElement[][])d);
    }

    public Array2DRowFieldMatrix(Field<T> field2, T[][] d) throws DimensionMismatchException, NullArgumentException, NoDataException {
        super(field2);
        this.copyIn((FieldElement[][])d);
    }

    public Array2DRowFieldMatrix(T[][] d, boolean copyArray) throws DimensionMismatchException, NoDataException, NullArgumentException {
        this(Array2DRowFieldMatrix.extractField(d), (FieldElement[][])d, copyArray);
    }

    public Array2DRowFieldMatrix(Field<T> field2, T[][] d, boolean copyArray) throws DimensionMismatchException, NoDataException, NullArgumentException {
        super(field2);
        if (copyArray) {
            this.copyIn((FieldElement[][])d);
        } else {
            MathUtils.checkNotNull(d);
            int nRows = d.length;
            if (nRows == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
            }
            int nCols = d[0].length;
            if (nCols == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
            }
            for (int r = 1; r < nRows; ++r) {
                if (d[r].length == nCols) continue;
                throw new DimensionMismatchException(nCols, d[r].length);
            }
            this.data = d;
        }
    }

    public Array2DRowFieldMatrix(T[] v) throws NoDataException {
        this(Array2DRowFieldMatrix.extractField(v), (FieldElement[])v);
    }

    public Array2DRowFieldMatrix(Field<T> field2, T[] v) {
        super(field2);
        int nRows = v.length;
        this.data = (FieldElement[][])MathArrays.buildArray(this.getField(), nRows, 1);
        for (int row2 = 0; row2 < nRows; ++row2) {
            this.data[row2][0] = v[row2];
        }
    }

    @Override
    public FieldMatrix<T> createMatrix(int rowDimension, int columnDimension) throws NotStrictlyPositiveException {
        return new Array2DRowFieldMatrix(this.getField(), rowDimension, columnDimension);
    }

    @Override
    public FieldMatrix<T> copy() {
        return new Array2DRowFieldMatrix(this.getField(), this.copyOut(), false);
    }

    @Override
    public Array2DRowFieldMatrix<T> add(Array2DRowFieldMatrix<T> m) throws MatrixDimensionMismatchException {
        this.checkAdditionCompatible(m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldElement[][] outData = (FieldElement[][])MathArrays.buildArray(this.getField(), rowCount, columnCount);
        for (int row2 = 0; row2 < rowCount; ++row2) {
            T[] dataRow = this.data[row2];
            T[] mRow = m.data[row2];
            FieldElement[] outDataRow = outData[row2];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = (FieldElement)dataRow[col].add(mRow[col]);
            }
        }
        return new Array2DRowFieldMatrix(this.getField(), outData, false);
    }

    @Override
    public Array2DRowFieldMatrix<T> subtract(Array2DRowFieldMatrix<T> m) throws MatrixDimensionMismatchException {
        this.checkSubtractionCompatible(m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldElement[][] outData = (FieldElement[][])MathArrays.buildArray(this.getField(), rowCount, columnCount);
        for (int row2 = 0; row2 < rowCount; ++row2) {
            T[] dataRow = this.data[row2];
            T[] mRow = m.data[row2];
            FieldElement[] outDataRow = outData[row2];
            for (int col = 0; col < columnCount; ++col) {
                outDataRow[col] = (FieldElement)dataRow[col].subtract(mRow[col]);
            }
        }
        return new Array2DRowFieldMatrix(this.getField(), outData, false);
    }

    @Override
    public Array2DRowFieldMatrix<T> multiply(Array2DRowFieldMatrix<T> m) throws DimensionMismatchException {
        this.checkMultiplicationCompatible(m);
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        FieldElement[][] outData = (FieldElement[][])MathArrays.buildArray(this.getField(), nRows, nCols);
        for (int row2 = 0; row2 < nRows; ++row2) {
            T[] dataRow = this.data[row2];
            FieldElement[] outDataRow = outData[row2];
            for (int col = 0; col < nCols; ++col) {
                FieldElement sum = (FieldElement)this.getField().getZero();
                for (int i2 = 0; i2 < nSum; ++i2) {
                    sum = (FieldElement)sum.add(dataRow[i2].multiply(m.data[i2][col]));
                }
                outDataRow[col] = sum;
            }
        }
        return new Array2DRowFieldMatrix(this.getField(), outData, false);
    }

    @Override
    public T[][] getData() {
        return this.copyOut();
    }

    public T[][] getDataRef() {
        return this.data;
    }

    @Override
    public void setSubMatrix(T[][] subMatrix, int row2, int column2) throws OutOfRangeException, NullArgumentException, NoDataException, DimensionMismatchException {
        if (this.data == null) {
            if (row2 > 0) {
                throw new MathIllegalStateException(LocalizedFormats.FIRST_ROWS_NOT_INITIALIZED_YET, row2);
            }
            if (column2 > 0) {
                throw new MathIllegalStateException(LocalizedFormats.FIRST_COLUMNS_NOT_INITIALIZED_YET, column2);
            }
            int nRows = subMatrix.length;
            if (nRows == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
            }
            int nCols = subMatrix[0].length;
            if (nCols == 0) {
                throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
            }
            this.data = (FieldElement[][])MathArrays.buildArray(this.getField(), subMatrix.length, nCols);
            for (int i2 = 0; i2 < this.data.length; ++i2) {
                if (subMatrix[i2].length != nCols) {
                    throw new DimensionMismatchException(nCols, subMatrix[i2].length);
                }
                System.arraycopy(subMatrix[i2], 0, this.data[i2 + row2], column2, nCols);
            }
        } else {
            super.setSubMatrix(subMatrix, row2, column2);
        }
    }

    @Override
    public T getEntry(int row2, int column2) throws OutOfRangeException {
        this.checkRowIndex(row2);
        this.checkColumnIndex(column2);
        return this.data[row2][column2];
    }

    @Override
    public void setEntry(int row2, int column2, T value) throws OutOfRangeException {
        this.checkRowIndex(row2);
        this.checkColumnIndex(column2);
        this.data[row2][column2] = value;
    }

    @Override
    public void addToEntry(int row2, int column2, T increment) throws OutOfRangeException {
        this.checkRowIndex(row2);
        this.checkColumnIndex(column2);
        this.data[row2][column2] = (FieldElement)this.data[row2][column2].add(increment);
    }

    @Override
    public void multiplyEntry(int row2, int column2, T factor) throws OutOfRangeException {
        this.checkRowIndex(row2);
        this.checkColumnIndex(column2);
        this.data[row2][column2] = (FieldElement)this.data[row2][column2].multiply(factor);
    }

    @Override
    public int getRowDimension() {
        return this.data == null ? 0 : this.data.length;
    }

    @Override
    public int getColumnDimension() {
        return this.data == null || this.data[0] == null ? 0 : this.data[0].length;
    }

    @Override
    public T[] operate(T[] v) throws DimensionMismatchException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nCols) {
            throw new DimensionMismatchException(v.length, nCols);
        }
        FieldElement[] out = (FieldElement[])MathArrays.buildArray(this.getField(), nRows);
        for (int row2 = 0; row2 < nRows; ++row2) {
            T[] dataRow = this.data[row2];
            FieldElement sum = (FieldElement)this.getField().getZero();
            for (int i2 = 0; i2 < nCols; ++i2) {
                sum = (FieldElement)sum.add(dataRow[i2].multiply(v[i2]));
            }
            out[row2] = sum;
        }
        return out;
    }

    @Override
    public T[] preMultiply(T[] v) throws DimensionMismatchException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nRows) {
            throw new DimensionMismatchException(v.length, nRows);
        }
        FieldElement[] out = (FieldElement[])MathArrays.buildArray(this.getField(), nCols);
        for (int col = 0; col < nCols; ++col) {
            FieldElement sum = (FieldElement)this.getField().getZero();
            for (int i2 = 0; i2 < nRows; ++i2) {
                sum = (FieldElement)sum.add(this.data[i2][col].multiply(v[i2]));
            }
            out[col] = sum;
        }
        return out;
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor2) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor2.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i2 = 0; i2 < rows; ++i2) {
            T[] rowI = this.data[i2];
            for (int j = 0; j < columns; ++j) {
                rowI[j] = visitor2.visit(i2, j, rowI[j]);
            }
        }
        return visitor2.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor2) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor2.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int i2 = 0; i2 < rows; ++i2) {
            T[] rowI = this.data[i2];
            for (int j = 0; j < columns; ++j) {
                visitor2.visit(i2, j, rowI[j]);
            }
        }
        return visitor2.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor2, int startRow, int endRow, int startColumn, int endColumn) throws OutOfRangeException, NumberIsTooSmallException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor2.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i2 = startRow; i2 <= endRow; ++i2) {
            T[] rowI = this.data[i2];
            for (int j = startColumn; j <= endColumn; ++j) {
                rowI[j] = visitor2.visit(i2, j, rowI[j]);
            }
        }
        return visitor2.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor2, int startRow, int endRow, int startColumn, int endColumn) throws OutOfRangeException, NumberIsTooSmallException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor2.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int i2 = startRow; i2 <= endRow; ++i2) {
            T[] rowI = this.data[i2];
            for (int j = startColumn; j <= endColumn; ++j) {
                visitor2.visit(i2, j, rowI[j]);
            }
        }
        return visitor2.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor2) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor2.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j = 0; j < columns; ++j) {
            for (int i2 = 0; i2 < rows; ++i2) {
                T[] rowI = this.data[i2];
                rowI[j] = visitor2.visit(i2, j, rowI[j]);
            }
        }
        return visitor2.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor2) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor2.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int j = 0; j < columns; ++j) {
            for (int i2 = 0; i2 < rows; ++i2) {
                visitor2.visit(i2, j, this.data[i2][j]);
            }
        }
        return visitor2.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor2, int startRow, int endRow, int startColumn, int endColumn) throws OutOfRangeException, NumberIsTooSmallException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor2.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j = startColumn; j <= endColumn; ++j) {
            for (int i2 = startRow; i2 <= endRow; ++i2) {
                T[] rowI = this.data[i2];
                rowI[j] = visitor2.visit(i2, j, rowI[j]);
            }
        }
        return visitor2.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor2, int startRow, int endRow, int startColumn, int endColumn) throws OutOfRangeException, NumberIsTooSmallException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor2.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int j = startColumn; j <= endColumn; ++j) {
            for (int i2 = startRow; i2 <= endRow; ++i2) {
                visitor2.visit(i2, j, this.data[i2][j]);
            }
        }
        return visitor2.end();
    }

    private T[][] copyOut() {
        int nRows = this.getRowDimension();
        FieldElement[][] out = (FieldElement[][])MathArrays.buildArray(this.getField(), nRows, this.getColumnDimension());
        for (int i2 = 0; i2 < nRows; ++i2) {
            System.arraycopy(this.data[i2], 0, out[i2], 0, this.data[i2].length);
        }
        return out;
    }

    private void copyIn(T[][] in) throws NullArgumentException, NoDataException, DimensionMismatchException {
        this.setSubMatrix((FieldElement[][])in, 0, 0);
    }
}

