/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.twod.util;

import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.neuralnet.MapUtils;
import org.apache.commons.math3.ml.neuralnet.Neuron;
import org.apache.commons.math3.ml.neuralnet.twod.NeuronSquareMesh2D;
import org.apache.commons.math3.ml.neuralnet.twod.util.LocationFinder;
import org.apache.commons.math3.ml.neuralnet.twod.util.MapDataVisualization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmoothedDataHistogram
implements MapDataVisualization {
    private final int smoothingBins;
    private final DistanceMeasure distance;
    private final double membershipNormalization;

    public SmoothedDataHistogram(int smoothingBins, DistanceMeasure distance) {
        this.smoothingBins = smoothingBins;
        this.distance = distance;
        double sum = 0.0;
        for (int i2 = 0; i2 < smoothingBins; ++i2) {
            sum += (double)(smoothingBins - i2);
        }
        this.membershipNormalization = 1.0 / sum;
    }

    @Override
    public double[][] computeImage(NeuronSquareMesh2D map2, Iterable<double[]> data2) {
        int nC;
        int nR = map2.getNumberOfRows();
        int mapSize = nR * (nC = map2.getNumberOfColumns());
        if (mapSize < this.smoothingBins) {
            throw new NumberIsTooSmallException(mapSize, (Number)this.smoothingBins, true);
        }
        LocationFinder finder = new LocationFinder(map2);
        double[][] histo = new double[nR][nC];
        for (double[] sample : data2) {
            Neuron[] sorted2 = MapUtils.sort(sample, map2.getNetwork(), this.distance);
            for (int i2 = 0; i2 < this.smoothingBins; ++i2) {
                LocationFinder.Location loc = finder.getLocation(sorted2[i2]);
                int row2 = loc.getRow();
                int col = loc.getColumn();
                double[] dArray = histo[row2];
                int n = col;
                dArray[n] = dArray[n] + (double)(this.smoothingBins - i2) * this.membershipNormalization;
            }
        }
        return histo;
    }
}

