/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.utils;

import gde.config.Settings;
import gde.histo.datasources.HistoSet;
import gde.histo.utils.Spot;
import gde.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;

public class ElementaryQuantile<T extends Number> {
    private static final String $CLASS_NAME = ElementaryQuantile.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    public static final double INTER_QUARTILE_SIGMA_FACTOR = 0.674489694;
    private final Settings settings;
    protected final boolean isSample;
    protected final List<T> trunk;
    protected StatsHelper statsHelper;

    public static ElementaryQuantile<Double> createElementarySpotQuantile(Collection<Spot<Double>> population, Settings settings) {
        ArrayList<Double> trunk = new ArrayList<Double>();
        for (Spot<Double> spot : population) {
            trunk.add(spot.y());
        }
        boolean isSample = true;
        return new ElementaryQuantile<Double>(trunk, isSample, settings);
    }

    public ElementaryQuantile(List<T> population, boolean isSample, Settings settings) {
        this.settings = settings;
        this.trunk = population;
        this.isSample = isSample;
        Collections.sort(this.trunk);
        log.finest(() -> "" + population.size() + Arrays.toString(population.toArray()));
        log.finest(() -> "" + this.trunk.size() + Arrays.toString(this.trunk.toArray()));
    }

    public int getOrFigure() {
        if (this.statsHelper == null) {
            this.setStats();
        }
        return this.statsHelper.getOr();
    }

    public double getSumFigure() {
        if (this.statsHelper == null) {
            this.setStats();
        }
        return this.statsHelper.getSum();
    }

    public double getAvgOBS() {
        double avg = 0.0;
        for (int i = 0; i < this.trunk.size(); ++i) {
            double value = ((Number)this.trunk.get(i)).doubleValue();
            avg += (value - avg) / (double)(i + 1);
        }
        return avg;
    }

    public double getAvgFigure() {
        if (this.statsHelper == null) {
            this.setStats();
        }
        return this.statsHelper.getAvg();
    }

    public double getSigmaOBS() {
        double avg = this.getAvgFigure();
        double varTimesN = 0.0;
        for (int i = 0; i < this.trunk.size(); ++i) {
            double value = ((Number)this.trunk.get(i)).doubleValue();
            varTimesN += (value - avg) * (value - avg);
        }
        return this.trunk.size() > 0 ? Math.sqrt(varTimesN / (double)(this.isSample ? this.trunk.size() - 1 : this.trunk.size())) : 0.0;
    }

    public double getSigmaRunningOBS() {
        double avg = 0.0;
        double varTimesN = 0.0;
        int count = 0;
        for (int i = 0; i < this.trunk.size(); ++i) {
            double value = ((Number)this.trunk.get(i)).doubleValue();
            varTimesN += (value - avg) * (value - avg) * (double)count / (double)(++count);
            avg += (value - avg) / (double)count;
        }
        return this.trunk.size() > 0 ? Math.sqrt(varTimesN / (double)(this.isSample ? this.trunk.size() - 1 : this.trunk.size())) : 0.0;
    }

    public double getSigmaFigure() {
        if (this.statsHelper == null) {
            this.setStats();
        }
        return this.statsHelper.getSigma(this.isSample);
    }

    protected void setStats() {
        this.statsHelper = !this.trunk.isEmpty() && (this.trunk.get(0) instanceof Integer || this.trunk.get(0) instanceof Short) ? (StatsHelper)this.trunk.parallelStream().mapToInt(rec$ -> ((Number)rec$).intValue()).collect(() -> new StatsIntHelper(), StatsIntHelper::accept, StatsIntHelper::combine) : (StatsHelper)this.trunk.parallelStream().mapToDouble(rec$ -> ((Number)rec$).doubleValue()).collect(() -> new StatsDoubleHelper(), StatsDoubleHelper::accept, StatsDoubleHelper::combine);
    }

    public double getQuantile(double probabilityCutPoint) {
        int pSize = this.trunk.size();
        if (pSize > 0) {
            if (this.isSample) {
                if (probabilityCutPoint >= 1.0 / (double)(pSize + 1) && probabilityCutPoint < (double)pSize / (double)(pSize + 1)) {
                    double position = (double)(pSize + 1) * probabilityCutPoint;
                    return ((Number)this.trunk.get((int)position - 1)).doubleValue() + (position - (double)((int)position)) * (((Number)this.trunk.get((int)position)).doubleValue() - ((Number)this.trunk.get((int)position - 1)).doubleValue());
                }
                if (probabilityCutPoint < 1.0 / (double)(pSize + 1)) {
                    return ((Number)this.trunk.get(0)).doubleValue();
                }
                return ((Number)this.trunk.get(pSize - 1)).doubleValue();
            }
            if (probabilityCutPoint > 0.0 && probabilityCutPoint < 1.0) {
                double position = (double)pSize * probabilityCutPoint;
                if (position % 2.0 == 0.0) {
                    return (((Number)this.trunk.get((int)position)).doubleValue() + ((Number)this.trunk.get((int)(position + 1.0))).doubleValue()) / 2.0;
                }
                return ((Number)this.trunk.get((int)position)).doubleValue();
            }
            if (probabilityCutPoint == 0.0) {
                return ((Number)this.trunk.get(0)).doubleValue();
            }
            return ((Number)this.trunk.get(pSize - 1)).doubleValue();
        }
        return 1.0;
    }

    public double getQuartile0() {
        return ((Number)this.trunk.get(0)).doubleValue();
    }

    public double getQuartile1() {
        return this.getQuantile(0.25);
    }

    public double getQuartile2() {
        return this.getQuantile(0.5);
    }

    public double getQuartile3() {
        return this.getQuantile(0.75);
    }

    public double getQuartile4() {
        return ((Number)this.trunk.get(this.trunk.size() - 1)).doubleValue();
    }

    public double getInterQuartileRangeOBS() {
        return this.getQuantile(0.75) - this.getQuantile(0.25);
    }

    public double[] getQuantileToleranceLowerUpper(double sigmaFactor) {
        double outlierProbability1 = (1.0 - ErrorFunction.getProbability(sigmaFactor)) / 2.0;
        double q1 = this.getQuantile(outlierProbability1);
        double q2 = this.getQuartile2();
        double q3 = this.getQuantile(1.0 - outlierProbability1);
        if (this.settings.isCanonicalQuantiles()) {
            double halfTolerance = (q3 - q1) / 2.0;
            return new double[]{halfTolerance, halfTolerance};
        }
        if (this.settings.isSymmetricToleranceInterval()) {
            if (HistoSet.fuzzyEquals(q3 - q1, 0.0) && !HistoSet.fuzzyEquals(q3, 0.0) && !HistoSet.fuzzyEquals(q1, 0.0)) {
                double halfTolerance = this.getSigmaFigure() * sigmaFactor;
                log.finer(() -> "avg=" + this.getAvgFigure() + "  sigma=" + this.getSigmaFigure());
                return new double[]{halfTolerance, halfTolerance};
            }
            double halfTolerance = (q3 - q1) / 2.0;
            return new double[]{halfTolerance, halfTolerance};
        }
        if ((HistoSet.fuzzyEquals(q3 - q1, 0.0) || HistoSet.fuzzyEquals(q2 - q1, 0.0) || HistoSet.fuzzyEquals(q3 - q2, 0.0)) && !HistoSet.fuzzyEquals(q3, 0.0) && !HistoSet.fuzzyEquals(q1, 0.0)) {
            double halfTolerance = this.getSigmaFigure() * sigmaFactor;
            log.finer(() -> "avg=" + this.getAvgFigure() + "  sigma=" + this.getSigmaFigure());
            return new double[]{halfTolerance, halfTolerance};
        }
        return new double[]{q2 - q1, q3 - q2};
    }

    public double[] getQuartileToleranceLowerUpper() {
        return this.getQuantileToleranceLowerUpper(0.674489694);
    }

    public double getExtremumFromRange(double sigmaFactor, double outlierFactor) {
        if (outlierFactor == 0.0) {
            throw new IllegalArgumentException();
        }
        double[] toleranceLowerUpper = this.getQuantileToleranceLowerUpper(sigmaFactor);
        if (HistoSet.fuzzyEquals(toleranceLowerUpper[0] + toleranceLowerUpper[1], 0.0)) {
            return this.getQuartile2();
        }
        if (outlierFactor < 0.0) {
            double minLimit = this.getQuartile1() + outlierFactor * 2.0 * toleranceLowerUpper[0];
            ListIterator<T> iterator = this.trunk.listIterator();
            while (iterator.hasNext()) {
                double trunkValue = ((Number)iterator.next()).doubleValue();
                if (!(trunkValue >= minLimit)) continue;
                return trunkValue;
            }
            throw new UnsupportedOperationException("outlier factor < 0");
        }
        double maxLimit = this.getQuartile3() + outlierFactor * 2.0 * toleranceLowerUpper[1];
        ListIterator<T> iterator = this.trunk.listIterator(this.trunk.size());
        while (iterator.hasPrevious()) {
            double trunkValue = ((Number)iterator.previous()).doubleValue();
            if (!(trunkValue <= maxLimit)) continue;
            return trunkValue;
        }
        throw new UnsupportedOperationException();
    }

    public double getQuantileLowerWhisker() {
        double probabilityCutPoint = 0.25;
        double whiskerStartValue = this.getQuantile(0.25);
        double whiskerLimitValue = whiskerStartValue - this.getQuartileToleranceLowerUpper()[0] * 2.0 * 1.5;
        double value = whiskerStartValue;
        int i = 0;
        while ((double)i < (double)this.trunk.size() * 0.25) {
            if (((Number)this.trunk.get(i)).doubleValue() >= whiskerLimitValue) {
                value = this.getQuantile((0.5 + (double)i) / (double)this.trunk.size());
                value = value < whiskerLimitValue ? whiskerLimitValue : value;
                break;
            }
            ++i;
        }
        return value;
    }

    public double getQuantileUpperWhisker() {
        double probabilityCutPoint = 0.75;
        double whiskerStartValue = this.getQuantile(0.75);
        double whiskerLimitValue = whiskerStartValue + this.getQuartileToleranceLowerUpper()[1] * 2.0 * 1.5;
        double value = whiskerStartValue;
        int i = this.trunk.size() - 1;
        while ((double)i >= (double)this.trunk.size() * 0.75) {
            if (((Number)this.trunk.get(i)).doubleValue() <= whiskerLimitValue) {
                value = this.getQuantile((0.5 + (double)i) / (double)this.trunk.size());
                value = value > whiskerLimitValue ? whiskerLimitValue : value;
                break;
            }
            --i;
        }
        return value;
    }

    public double[] getTukeyBoxPlot() {
        double[] values = new double[7];
        values[BoxplotItems.QUARTILE0.ordinal()] = this.getQuartile0();
        values[BoxplotItems.LOWER_WHISKER.ordinal()] = this.getQuantileLowerWhisker();
        values[BoxplotItems.QUARTILE1.ordinal()] = this.getQuartile1();
        values[BoxplotItems.QUARTILE2.ordinal()] = this.getQuartile2();
        values[BoxplotItems.QUARTILE3.ordinal()] = this.getQuartile3();
        values[BoxplotItems.UPPER_WHISKER.ordinal()] = this.getQuantileUpperWhisker();
        values[BoxplotItems.QUARTILE4.ordinal()] = this.getQuartile4();
        return values;
    }

    public double[] getTukeyWithQuartileTolerances() {
        double[] values = new double[9];
        values[BoxplotItems.QUARTILE0.ordinal()] = this.getQuartile0();
        values[BoxplotItems.LOWER_WHISKER.ordinal()] = this.getQuantileLowerWhisker();
        values[BoxplotItems.QUARTILE1.ordinal()] = this.getQuartile1();
        values[BoxplotItems.QUARTILE2.ordinal()] = this.getQuartile2();
        values[BoxplotItems.QUARTILE3.ordinal()] = this.getQuartile3();
        values[BoxplotItems.UPPER_WHISKER.ordinal()] = this.getQuantileUpperWhisker();
        values[BoxplotItems.QUARTILE4.ordinal()] = this.getQuartile4();
        double[] toleranceInterval = this.getQuartileToleranceLowerUpper();
        values[BoxplotItems.LQT.ordinal()] = toleranceInterval[0];
        values[BoxplotItems.UQT.ordinal()] = toleranceInterval[1];
        return values;
    }

    public int getSize() {
        return this.trunk.size();
    }

    public String toString() {
        return "isSample=" + this.isSample + ", size=" + this.getSize() + ", sumFigure=" + this.getSumFigure() + ", avgFigure=" + this.getAvgFigure() + ", sigmaFigure=" + this.getSigmaFigure() + "";
    }

    static interface StatsHelper {
        public int getOr();

        public double getSum();

        public double getAvg();

        public double getSigma(boolean var1);

        public int getCount();
    }

    protected static class ErrorFunction {
        protected ErrorFunction() {
        }

        public static double erf(double z) {
            double t = 1.0 / (1.0 + 0.5 * Math.abs(z));
            double ans = 1.0 - t * Math.exp(-z * z - 1.26551223 + t * (1.00002368 + t * (0.37409196 + t * (0.09678418 + t * (-0.18628806 + t * (0.27886807 + t * (-1.13520398 + t * (1.48851587 + t * (-0.82215223 + t * 0.17087277)))))))));
            if (z >= 0.0) {
                return ans;
            }
            return -ans;
        }

        public static double erf2(double z) {
            double t = 1.0 / (1.0 + 0.47047 * Math.abs(z));
            double poly = t * (0.3480242 + t * (-0.0958798 + t * 0.7478556));
            double ans = 1.0 - poly * Math.exp(-z * z);
            if (z >= 0.0) {
                return ans;
            }
            return -ans;
        }

        public static double Phi(double z) {
            return 0.5 * (1.0 + ErrorFunction.erf(z / Math.sqrt(2.0)));
        }

        public static double getProbability(double sigmaFactor) {
            return ErrorFunction.erf(sigmaFactor / Math.sqrt(2.0));
        }

        public static void simpleTest(String[] args) {
            double x = Double.parseDouble(args[0]);
            System.out.println(String.format("erf(%f)  = %f", x, ErrorFunction.erf(x)));
            System.out.println(String.format("erf2(%f)  = %f", x, ErrorFunction.erf2(x)));
            System.out.println(String.format("Phi(%f)  = %f", x, ErrorFunction.Phi(x)));
            System.out.println();
        }
    }

    public static enum BoxplotItems {
        QUARTILE0,
        LOWER_WHISKER,
        QUARTILE1,
        QUARTILE2,
        QUARTILE3,
        UPPER_WHISKER,
        QUARTILE4,
        LQT,
        UQT;

    }

    class StatsDoubleHelper
    implements DoubleConsumer,
    StatsHelper {
        private double avg = 0.0;
        private double varTimesN = 0.0;
        private int count = 0;

        StatsDoubleHelper() {
        }

        @Override
        public int getOr() {
            return 0;
        }

        @Override
        public double getSum() {
            return this.avg * (double)this.count;
        }

        @Override
        public double getAvg() {
            return this.count > 0 ? this.avg : 0.0;
        }

        @Override
        public double getSigma(boolean isSample) {
            if (isSample) {
                return this.count > 1 ? Math.sqrt(this.varTimesN / (double)(isSample ? this.count - 1 : this.count)) : 0.0;
            }
            return this.count > 0 ? Math.sqrt(this.varTimesN / (double)(isSample ? this.count - 1 : this.count)) : 0.0;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public void accept(double value) {
            this.varTimesN += (value - this.avg) * (value - this.avg) * (double)this.count / (double)(++this.count);
            this.avg += (value - this.avg) / (double)this.count;
        }

        public void combine(StatsDoubleHelper other) {
            double tmpAvg = this.avg * (double)this.count / (double)(this.count + other.count) + other.avg * (double)other.count / (double)(this.count + other.count);
            this.varTimesN += other.varTimesN + (double)this.count * (this.avg - tmpAvg) * (this.avg - tmpAvg) + (double)other.count * (other.avg - tmpAvg) * (other.avg - tmpAvg);
            this.avg = tmpAvg;
            this.count += other.count;
        }
    }

    class StatsIntHelper
    implements IntConsumer,
    StatsHelper {
        private int or = 0;
        private double avg = 0.0;
        private double varTimesN = 0.0;
        private int count = 0;

        StatsIntHelper() {
        }

        @Override
        public int getOr() {
            return this.or;
        }

        @Override
        public double getSum() {
            return this.avg * (double)this.count;
        }

        @Override
        public double getAvg() {
            return this.count > 0 ? this.avg : 0.0;
        }

        @Override
        public double getSigma(boolean isSample) {
            if (isSample) {
                return this.count > 1 ? Math.sqrt(this.varTimesN / (double)(isSample ? this.count - 1 : this.count)) : 0.0;
            }
            return this.count > 0 ? Math.sqrt(this.varTimesN / (double)(isSample ? this.count - 1 : this.count)) : 0.0;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public void accept(int value) {
            this.or |= value;
            this.varTimesN += ((double)value - this.avg) * ((double)value - this.avg) * (double)this.count / (double)(++this.count);
            this.avg += ((double)value - this.avg) / (double)this.count;
        }

        public void combine(StatsIntHelper other) {
            this.or |= other.or;
            double tmpAvg = this.avg * (double)this.count / (double)(this.count + other.count) + other.avg * (double)other.count / (double)(this.count + other.count);
            this.varTimesN += other.varTimesN + (double)this.count * (this.avg - tmpAvg) * (this.avg - tmpAvg) + (double)other.count * (other.avg - tmpAvg) * (other.avg - tmpAvg);
            this.avg = tmpAvg;
            this.count += other.count;
        }
    }
}

