/*
 * Decompiled with CFR 0.152.
 */
package gde.messages;

import gde.config.Settings;
import gde.log.Level;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class Messages {
    static final Logger log = Logger.getLogger(Messages.class.getName());
    static final String BUNDLE_NAME = "gde.messages.messages";
    static ResourceBundle mainResourceBundle = ResourceBundle.getBundle("gde.messages.messages", Settings.getInstance().getLocale());
    static ResourceBundle deviceResourceBundle = ResourceBundle.getBundle("gde.messages.messages", Settings.getInstance().getLocale());

    private Messages() {
    }

    public static String getString(String key, Object[] params) {
        try {
            String result = Integer.valueOf(key.substring(key.length() - 4)) <= 1000 ? mainResourceBundle.getString(key) : deviceResourceBundle.getString(key);
            String[] array = result.split("[{}]");
            StringBuilder sb = new StringBuilder();
            if (array.length > 1) {
                int j = 0;
                for (int i = 0; i < array.length; ++i) {
                    if (i != 0 && i % 2 != 0) {
                        sb.append(params.length >= j + 1 ? params[j++] : "?");
                        continue;
                    }
                    sb.append(array[i]);
                }
                result = sb.toString();
            }
            return result;
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static String getString(String key) {
        try {
            if (Integer.valueOf(key.substring(key.length() - 4)) <= 1000) {
                return mainResourceBundle.getString(key);
            }
            return deviceResourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public static void setMainResourceBundleLocale(Locale newLocale) {
        mainResourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, newLocale);
    }

    public static void setDeviceResourceBundle(String newBundleName, Locale newLocale, ClassLoader loader) {
        try {
            deviceResourceBundle = ResourceBundle.getBundle(newBundleName, newLocale, loader);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, newBundleName, e);
        }
    }

    public static char getAcceleratorChar(String key) {
        try {
            String resourceString = Integer.valueOf(key.substring(key.length() - 4)) <= 1000 ? mainResourceBundle.getString(key) : deviceResourceBundle.getString(key);
            return resourceString.charAt(resourceString.length() - 1);
        }
        catch (MissingResourceException e) {
            return '?';
        }
    }

    public static void reloadResources() {
        mainResourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, Settings.getInstance().getLocale());
        deviceResourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, Settings.getInstance().getLocale());
    }
}

