/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.dialog;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.histo.ui.HistoSummaryWindow;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.tab.GraphicsWindow;
import gde.ui.tab.ObjectDescriptionWindow;
import gde.ui.tab.StatisticsWindow;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.EnumSet;
import java.util.Optional;
import java.util.logging.Logger;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.OrientationRequested;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class PrintSelectionDialog
extends Dialog {
    static final Logger log = Logger.getLogger(PrintSelectionDialog.class.getName());
    Shell dialogShell;
    Button printButton;
    Group configurationGroup;
    Button portraitButton;
    Button landscapeReverseButton;
    Button cancelButton;
    Button objectButton;
    Button statisticsButton;
    Button graphicsButton;
    Button curveCompareButton;
    Button histoSummaryButton;
    Group orientationGroup;
    Button landscapeButton;
    final DataExplorer application = DataExplorer.getInstance();
    private Button headerButton;

    public static void main(String[] args) {
        try {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            PrintSelectionDialog inst = new PrintSelectionDialog(shell, 0);
            inst.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PrintSelectionDialog(Shell parent, int style) {
        super(parent, style);
    }

    public void open() {
        try {
            Shell parent = this.getParent();
            this.dialogShell = new Shell(parent, 67680);
            SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
            this.dialogShell.setLayout(null);
            this.dialogShell.setImage(SWTResourceManager.getImage("gde/resource/Print.gif"));
            this.dialogShell.setText(Messages.getString("GDE_MSGT0441"));
            this.dialogShell.layout();
            this.dialogShell.pack();
            this.dialogShell.setSize(400, 400);
            this.dialogShell.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    switch (event.detail) {
                        case 2: {
                            PrintSelectionDialog.this.dialogShell.close();
                            event.detail = 0;
                            event.doit = false;
                        }
                    }
                }
            });
            this.dialogShell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent arg0) {
                    PrintSelectionDialog.this.application.resetShellIcon();
                }
            });
            this.headerButton = new Button((Composite)this.dialogShell, 16416);
            this.headerButton.setText(Messages.getString("GDE_MSGT0456"));
            this.headerButton.setToolTipText(Messages.getString("GDE_MSGT0457"));
            this.headerButton.setBounds(14, 7, 366, 27);
            this.headerButton.setSelection(true);
            this.configurationGroup = new Group((Composite)this.dialogShell, 0);
            this.configurationGroup.setLayout(null);
            this.configurationGroup.setText(Messages.getString("GDE_MSGT0448"));
            this.configurationGroup.setBounds(7, 36, 168, 286);
            this.configurationGroup.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent evt) {
                    RecordSet activeRecordSet;
                    log.log(Level.FINEST, "configurationGroup.paintControl, event=" + evt);
                    Channel activeChannel = Channels.getInstance().getActiveChannel();
                    boolean isRecordSetGraphicsPrintable = false;
                    if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
                        isRecordSetGraphicsPrintable = activeRecordSet.size() > 0;
                    }
                    PrintSelectionDialog.this.graphicsButton.setEnabled(isRecordSetGraphicsPrintable);
                    PrintSelectionDialog.this.graphicsButton.setSelection(isRecordSetGraphicsPrintable);
                    PrintSelectionDialog.this.statisticsButton.setEnabled(isRecordSetGraphicsPrintable);
                    PrintSelectionDialog.this.statisticsButton.setSelection(isRecordSetGraphicsPrintable);
                    boolean isObjectOriented = PrintSelectionDialog.this.application.isObjectoriented();
                    PrintSelectionDialog.this.objectButton.setEnabled(isObjectOriented);
                    PrintSelectionDialog.this.objectButton.setSelection(isObjectOriented);
                    boolean isCopareWindowPrintable = PrintSelectionDialog.this.application.isWithCompareSet();
                    PrintSelectionDialog.this.curveCompareButton.setEnabled(isCopareWindowPrintable);
                    PrintSelectionDialog.this.curveCompareButton.setSelection(isCopareWindowPrintable);
                    boolean isHistoWindowPrintable = activeChannel != null ? DataExplorer.getInstance().getHistoExplorer().map(h -> h.hasRecords()).orElse(false) : false;
                    PrintSelectionDialog.this.histoSummaryButton.setEnabled(isHistoWindowPrintable);
                    PrintSelectionDialog.this.histoSummaryButton.setSelection(isHistoWindowPrintable);
                }
            });
            this.graphicsButton = new Button((Composite)this.configurationGroup, 16416);
            this.graphicsButton.setText(Messages.getString("GDE_MSGT0453"));
            this.graphicsButton.setToolTipText(Messages.getString("GDE_MSGT0458"));
            this.graphicsButton.setImage(SWTResourceManager.getImage("gde/resource/Graphics.gif"));
            this.graphicsButton.setSelection(true);
            this.graphicsButton.setBounds(8, 12, 148, 45);
            this.statisticsButton = new Button((Composite)this.configurationGroup, 16416);
            this.statisticsButton.setText(Messages.getString("GDE_MSGT0350"));
            this.statisticsButton.setToolTipText(Messages.getString("GDE_MSGT0459"));
            this.statisticsButton.setImage(SWTResourceManager.getImage("gde/resource/Statistics.gif"));
            this.statisticsButton.setSelection(true);
            this.statisticsButton.setBounds(8, 57, 148, 45);
            this.objectButton = new Button((Composite)this.configurationGroup, 16416);
            this.objectButton.setText(Messages.getString("GDE_MSGT0455"));
            this.objectButton.setToolTipText(Messages.getString("GDE_MSGT0460"));
            this.objectButton.setImage(SWTResourceManager.getImage("gde/resource/Object.gif"));
            this.objectButton.setBounds(8, 102, 148, 45);
            this.curveCompareButton = new Button((Composite)this.configurationGroup, 16416);
            this.curveCompareButton.setText(Messages.getString("GDE_MSGT0442"));
            this.curveCompareButton.setToolTipText(Messages.getString("GDE_MSGT0461"));
            this.curveCompareButton.setImage(SWTResourceManager.getImage("gde/resource/Graphics.gif"));
            this.curveCompareButton.setSelection(false);
            this.curveCompareButton.setBounds(8, 147, 148, 45);
            this.histoSummaryButton = new Button((Composite)this.configurationGroup, 16416);
            this.histoSummaryButton.setText(Messages.getString("GDE_MSGT0865"));
            this.histoSummaryButton.setToolTipText(Messages.getString("GDE_MSGT0866"));
            this.histoSummaryButton.setImage(SWTResourceManager.getImage("gde/resource/HistoSummary.gif"));
            this.histoSummaryButton.setSelection(false);
            this.histoSummaryButton.setBounds(8, 192, 148, 45);
            this.orientationGroup = new Group((Composite)this.dialogShell, 0);
            this.orientationGroup.setLayout(null);
            this.orientationGroup.setBounds(181, 36, 203, 206);
            this.orientationGroup.setText(Messages.getString("GDE_MSGT0443"));
            this.portraitButton = new Button((Composite)this.orientationGroup, 16400);
            this.portraitButton.setText(Messages.getString("GDE_MSGT0444"));
            this.portraitButton.setToolTipText(Messages.getString("GDE_MSGT0445"));
            this.portraitButton.setImage(SWTResourceManager.getImage("gde/resource/Portrait.gif"));
            this.portraitButton.setSelection(true);
            this.portraitButton.setBounds(8, 16, 183, 65);
            this.portraitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "portraitButton.widgetSelected, event=" + evt);
                    PrintSelectionDialog.this.portraitButton.setSelection(true);
                    PrintSelectionDialog.this.landscapeReverseButton.setSelection(false);
                    PrintSelectionDialog.this.landscapeButton.setSelection(false);
                }
            });
            this.landscapeButton = new Button((Composite)this.orientationGroup, 16400);
            this.landscapeButton.setText(Messages.getString("GDE_MSGT0446"));
            this.landscapeButton.setToolTipText(Messages.getString("GDE_MSGT0447"));
            this.landscapeButton.setImage(SWTResourceManager.getImage("gde/resource/Landscape.gif"));
            this.landscapeButton.setSelection(false);
            this.landscapeButton.setBounds(8, 74, 183, 65);
            this.landscapeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "landscapeButton.widgetSelected, event=" + evt);
                    PrintSelectionDialog.this.portraitButton.setSelection(false);
                    PrintSelectionDialog.this.landscapeReverseButton.setSelection(false);
                    PrintSelectionDialog.this.landscapeButton.setSelection(true);
                }
            });
            this.landscapeReverseButton = new Button((Composite)this.orientationGroup, 16400);
            this.landscapeReverseButton.setText(Messages.getString("GDE_MSGT0449"));
            this.landscapeReverseButton.setToolTipText(Messages.getString("GDE_MSGT0450"));
            this.landscapeReverseButton.setImage(SWTResourceManager.getImage("gde/resource/LandscapeReverse.gif"));
            this.landscapeReverseButton.setSelection(false);
            this.landscapeReverseButton.setBounds(8, 134, 183, 65);
            this.landscapeReverseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "portraitAllButton.widgetSelected, event=" + evt);
                    PrintSelectionDialog.this.landscapeReverseButton.setSelection(true);
                    PrintSelectionDialog.this.portraitButton.setSelection(false);
                    PrintSelectionDialog.this.landscapeButton.setSelection(false);
                }
            });
            this.printButton = new Button((Composite)this.dialogShell, 0x1000008);
            this.printButton.setText(Messages.getString("GDE_MSGT0451"));
            this.printButton.setBounds(212, 330, 149, 30);
            this.printButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "okButton.widgetSelected, event=" + evt);
                    int orientation = PrintSelectionDialog.this.landscapeButton.getSelection() ? 2 : (PrintSelectionDialog.this.portraitButton.getSelection() ? 1 : 0);
                    EnumSet<Artefact> artefacts = EnumSet.noneOf(Artefact.class);
                    if (PrintSelectionDialog.this.graphicsButton.getSelection()) {
                        artefacts.add(Artefact.GRAPHICS);
                    }
                    if (PrintSelectionDialog.this.curveCompareButton.getSelection()) {
                        artefacts.add(Artefact.COMPARE);
                    }
                    if (PrintSelectionDialog.this.statisticsButton.getSelection()) {
                        artefacts.add(Artefact.STATISTICS);
                    }
                    if (PrintSelectionDialog.this.objectButton.getSelection()) {
                        artefacts.add(Artefact.OBJECT);
                    }
                    if (PrintSelectionDialog.this.histoSummaryButton.getSelection()) {
                        artefacts.add(Artefact.HISTOSUMMARY);
                    }
                    PrintSelectionDialog.this.initiatePrinting(PrintSelectionDialog.this.headerButton.getSelection(), orientation, artefacts);
                    PrintSelectionDialog.this.dialogShell.dispose();
                }
            });
            this.cancelButton = new Button((Composite)this.dialogShell, 0x1000008);
            this.cancelButton.setText(Messages.getString("GDE_MSGT0452"));
            this.cancelButton.setBounds(29, 330, 149, 30);
            this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "cancelButton.widgetSelected, event=" + evt);
                    PrintSelectionDialog.this.dialogShell.dispose();
                }
            });
            this.dialogShell.setLocation(this.getParent().toDisplay(100, 100));
            this.dialogShell.open();
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void initiatePrinting(final boolean isPrintRequestHeader, final int orientation, final EnumSet<Artefact> artefacts) {
        BufferedImage histoSummaryImageAWT;
        BufferedImage compareImageAWT;
        BufferedImage objectImageAWT;
        BufferedImage statisticsImageAWT;
        BufferedImage graphicsImageAWT;
        int currentTabIndex = this.application.getTabSelectionIndex();
        if (artefacts.contains((Object)Artefact.GRAPHICS) && this.application.getGraphicsPrintImage() != null) {
            this.application.selectTab(c -> c instanceof GraphicsWindow && ((GraphicsWindow)((Object)c)).getGraphicsType().equals((Object)GraphicsWindow.GraphicsType.NORMAL));
            WaitTimer.delay(250L);
            org.eclipse.swt.graphics.Image graphicsImageSWT = this.application.getGraphicsTabContentAsImage();
            graphicsImageAWT = this.convertToAWT(graphicsImageSWT.getImageData());
            graphicsImageSWT.dispose();
        } else {
            graphicsImageAWT = null;
        }
        if (artefacts.contains((Object)Artefact.STATISTICS) && this.application.getStatisticsTabContentAsImage() != null) {
            this.application.selectTab(c -> c instanceof StatisticsWindow);
            WaitTimer.delay(250L);
            org.eclipse.swt.graphics.Image statisticsImageSWT = this.application.getStatisticsTabContentAsImage();
            statisticsImageAWT = this.convertToAWT(statisticsImageSWT.getImageData());
            statisticsImageSWT.dispose();
        } else {
            statisticsImageAWT = null;
        }
        if (this.application.isObjectoriented() && artefacts.contains((Object)Artefact.OBJECT) && this.application.getObjectTabContentAsImage() != null) {
            this.application.selectTab(c -> c instanceof ObjectDescriptionWindow);
            WaitTimer.delay(250L);
            org.eclipse.swt.graphics.Image objectImageSWT = this.application.getObjectTabContentAsImage();
            objectImageAWT = this.convertToAWT(objectImageSWT.getImageData());
            objectImageSWT.dispose();
        } else {
            objectImageAWT = null;
        }
        if (artefacts.contains((Object)Artefact.COMPARE) && this.application.getGraphicsPrintImage() != null) {
            this.application.selectTab(c -> c instanceof GraphicsWindow && ((GraphicsWindow)((Object)c)).getGraphicsType().equals((Object)GraphicsWindow.GraphicsType.COMPARE));
            WaitTimer.delay(250L);
            org.eclipse.swt.graphics.Image compareImageSWT = this.application.getGraphicsPrintImage();
            compareImageAWT = this.convertToAWT(compareImageSWT.getImageData());
            compareImageSWT.dispose();
        } else {
            compareImageAWT = null;
        }
        if (artefacts.contains((Object)Artefact.HISTOSUMMARY)) {
            Optional<org.eclipse.swt.graphics.Image> image = this.application.getHistoExplorer().map(h -> h.getHistoSummaryContentAsImage());
            if (image.isPresent()) {
                this.application.selectTab(c -> c instanceof HistoSummaryWindow);
                WaitTimer.delay(250L);
                org.eclipse.swt.graphics.Image histoSummaryImageSWT = image.orElse(null);
                histoSummaryImageAWT = this.convertToAWT(histoSummaryImageSWT.getImageData());
                histoSummaryImageSWT.dispose();
            } else {
                histoSummaryImageAWT = null;
            }
        } else {
            histoSummaryImageAWT = null;
        }
        this.application.selectTab(currentTabIndex);
        Thread printThread = new Thread(){

            @Override
            public void run() {
                Book book = new Book();
                PrinterJob printJob = PrinterJob.getPrinterJob();
                printJob.setPageable(book);
                HashPrintRequestAttributeSet printAttrSet = new HashPrintRequestAttributeSet();
                printAttrSet.add(new JobName("DataExplorer", Settings.getInstance().getLocale()));
                switch (orientation) {
                    case 0: {
                        printAttrSet.add(OrientationRequested.LANDSCAPE);
                        break;
                    }
                    case 2: {
                        printAttrSet.add(OrientationRequested.REVERSE_LANDSCAPE);
                        break;
                    }
                    default: {
                        printAttrSet.add(OrientationRequested.PORTRAIT);
                    }
                }
                if (printJob.printDialog(printAttrSet)) {
                    String fileName;
                    PageFormat documentPageFormat = printJob.getPageFormat(printAttrSet);
                    log.log(Level.FINE, "documentPageFormat width = " + documentPageFormat.getWidth());
                    log.log(Level.FINE, "documentPageFormat height = " + documentPageFormat.getHeight());
                    log.log(Level.FINE, "documentPageFormat orientation = " + documentPageFormat.getOrientation());
                    log.log(Level.FINE, "pageFormat.getImageableWidth() = " + documentPageFormat.getImageableWidth());
                    log.log(Level.FINE, "pageFormat.getImageableHeight() = " + documentPageFormat.getImageableHeight());
                    Channel activeChannel = Channels.getInstance().getActiveChannel();
                    fileName = activeChannel != null ? ((fileName = activeChannel.getFileName()) == null ? "DataExplorer - " : fileName + " - ") : "DataExplorer - ";
                    if (documentPageFormat.getOrientation() == 2) {
                        if (artefacts.contains((Object)Artefact.GRAPHICS)) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0143") : "", graphicsImageAWT), documentPageFormat);
                        }
                        if (artefacts.contains((Object)Artefact.STATISTICS)) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0350") : "", statisticsImageAWT), documentPageFormat);
                        }
                        if (artefacts.contains((Object)Artefact.OBJECT)) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0403") : "", objectImageAWT), documentPageFormat);
                        }
                        if (artefacts.contains((Object)Artefact.COMPARE)) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0144") : "", compareImageAWT), documentPageFormat);
                        }
                        if (artefacts.contains((Object)Artefact.HISTOSUMMARY)) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0867") : "", histoSummaryImageAWT), documentPageFormat);
                        }
                    } else if (documentPageFormat.getOrientation() == 0) {
                        if (artefacts.contains((Object)Artefact.GRAPHICS)) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0143") : "", graphicsImageAWT), documentPageFormat);
                        }
                        if (artefacts.contains((Object)Artefact.STATISTICS)) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0350") : "", statisticsImageAWT), documentPageFormat);
                        }
                        if (artefacts.contains((Object)Artefact.OBJECT)) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0403") : "", objectImageAWT), documentPageFormat);
                        }
                        if (artefacts.contains((Object)Artefact.COMPARE)) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0144") : "", compareImageAWT), documentPageFormat);
                        }
                        if (artefacts.contains((Object)Artefact.HISTOSUMMARY)) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0867") : "", histoSummaryImageAWT), documentPageFormat);
                        }
                    } else if (documentPageFormat.getOrientation() == 1) {
                        Object printJobs = artefacts.clone();
                        if (((AbstractCollection)printJobs).containsAll(EnumSet.of(Artefact.GRAPHICS, Artefact.STATISTICS))) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0143") : "", graphicsImageAWT, isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0350") : "", statisticsImageAWT), documentPageFormat);
                            ((AbstractSet)printJobs).removeAll(EnumSet.of(Artefact.GRAPHICS, Artefact.STATISTICS));
                        } else if (((AbstractCollection)printJobs).containsAll(EnumSet.of(Artefact.GRAPHICS, Artefact.OBJECT))) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0143") : "", graphicsImageAWT, isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0403") : "", objectImageAWT), documentPageFormat);
                            ((AbstractSet)printJobs).removeAll(EnumSet.of(Artefact.GRAPHICS, Artefact.OBJECT));
                        } else if (((AbstractCollection)printJobs).containsAll(EnumSet.of(Artefact.GRAPHICS, Artefact.COMPARE))) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0143") : "", graphicsImageAWT, isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0144") : "", compareImageAWT), documentPageFormat);
                            ((AbstractSet)printJobs).removeAll(EnumSet.of(Artefact.GRAPHICS, Artefact.COMPARE));
                        } else if (((AbstractCollection)printJobs).containsAll(EnumSet.of(Artefact.GRAPHICS, Artefact.HISTOSUMMARY))) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0143") : "", graphicsImageAWT, isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0867") : "", histoSummaryImageAWT), documentPageFormat);
                            ((AbstractSet)printJobs).removeAll(EnumSet.of(Artefact.GRAPHICS, Artefact.HISTOSUMMARY));
                        } else if (((AbstractCollection)printJobs).containsAll(EnumSet.of(Artefact.GRAPHICS))) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0143") : "", graphicsImageAWT), documentPageFormat);
                            ((AbstractSet)printJobs).removeAll(EnumSet.of(Artefact.GRAPHICS));
                        }
                        if (((AbstractCollection)printJobs).containsAll(EnumSet.of(Artefact.STATISTICS, Artefact.OBJECT))) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0350") : "", statisticsImageAWT, isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0403") : "", objectImageAWT), documentPageFormat);
                            ((AbstractSet)printJobs).removeAll(EnumSet.of(Artefact.STATISTICS, Artefact.OBJECT));
                        } else if (((AbstractCollection)printJobs).containsAll(EnumSet.of(Artefact.STATISTICS, Artefact.COMPARE))) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0350") : "", statisticsImageAWT, isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0144") : "", compareImageAWT), documentPageFormat);
                            ((AbstractSet)printJobs).removeAll(EnumSet.of(Artefact.STATISTICS, Artefact.COMPARE));
                        } else if (((AbstractCollection)printJobs).containsAll(EnumSet.of(Artefact.STATISTICS, Artefact.HISTOSUMMARY))) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0350") : "", statisticsImageAWT, isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0867") : "", histoSummaryImageAWT), documentPageFormat);
                            ((AbstractSet)printJobs).removeAll(EnumSet.of(Artefact.STATISTICS, Artefact.HISTOSUMMARY));
                        } else if (((AbstractCollection)printJobs).containsAll(EnumSet.of(Artefact.STATISTICS))) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0350") : "", statisticsImageAWT), documentPageFormat);
                            ((AbstractSet)printJobs).removeAll(EnumSet.of(Artefact.STATISTICS));
                        }
                        if (((AbstractCollection)printJobs).containsAll(EnumSet.of(Artefact.OBJECT, Artefact.COMPARE))) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0403") : "", objectImageAWT, isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0144") : "", compareImageAWT), documentPageFormat);
                            ((AbstractSet)printJobs).removeAll(EnumSet.of(Artefact.OBJECT, Artefact.COMPARE));
                        } else if (((AbstractCollection)printJobs).containsAll(EnumSet.of(Artefact.OBJECT, Artefact.HISTOSUMMARY))) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0403") : "", objectImageAWT, isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0867") : "", histoSummaryImageAWT), documentPageFormat);
                            ((AbstractSet)printJobs).removeAll(EnumSet.of(Artefact.OBJECT, Artefact.HISTOSUMMARY));
                        } else if (((AbstractCollection)printJobs).containsAll(EnumSet.of(Artefact.OBJECT))) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0403") : "", objectImageAWT), documentPageFormat);
                            ((AbstractSet)printJobs).removeAll(EnumSet.of(Artefact.OBJECT));
                        }
                        if (((AbstractCollection)printJobs).containsAll(EnumSet.of(Artefact.COMPARE, Artefact.HISTOSUMMARY))) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0144") : "", compareImageAWT, isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0867") : "", histoSummaryImageAWT), documentPageFormat);
                            ((AbstractSet)printJobs).removeAll(EnumSet.of(Artefact.COMPARE, Artefact.HISTOSUMMARY));
                        } else if (((AbstractCollection)printJobs).containsAll(EnumSet.of(Artefact.COMPARE))) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0144") : "", compareImageAWT), documentPageFormat);
                            ((AbstractSet)printJobs).removeAll(EnumSet.of(Artefact.COMPARE));
                        }
                        if (((AbstractCollection)printJobs).containsAll(EnumSet.of(Artefact.HISTOSUMMARY))) {
                            book.append(new Document(isPrintRequestHeader ? fileName + Messages.getString("GDE_MSGT0867") : "", histoSummaryImageAWT), documentPageFormat);
                            ((AbstractSet)printJobs).removeAll(EnumSet.of(Artefact.HISTOSUMMARY));
                        }
                    }
                    try {
                        printJob.print();
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        PrintSelectionDialog.this.application.openMessageDialog(GDE.shell, e.getClass().getSimpleName() + " - " + e.getMessage());
                    }
                }
            }
        };
        printThread.start();
    }

    BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            for (int y = 0; y < data.height; ++y) {
                for (int x = 0; x < data.width; ++x) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    pixelArray[0] = rgb.red;
                    pixelArray[1] = rgb.green;
                    pixelArray[2] = rgb.blue;
                    raster.setPixels(x, y, 1, 1, pixelArray);
                }
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        for (int i = 0; i < rgbs.length; ++i) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        for (int y = 0; y < data.height; ++y) {
            for (int x = 0; x < data.width; ++x) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
            }
        }
        return bufferedImage;
    }

    private static enum Artefact {
        GRAPHICS,
        COMPARE,
        STATISTICS,
        OBJECT,
        HISTOSUMMARY;

    }

    static class Document
    extends Component
    implements Printable {
        private static final long serialVersionUID = 1L;
        final boolean isPrintRequestHeader;
        final Image awtBufferedImage1;
        final Image awtBufferedImage2;
        final String docType1;
        final String docType2;

        Document(String documentType, Image awtImage) {
            this.docType1 = documentType;
            this.awtBufferedImage1 = awtImage;
            this.docType2 = "";
            this.awtBufferedImage2 = null;
            this.isPrintRequestHeader = this.docType1 != null && this.docType1.length() > 1;
        }

        Document(String documentType1, Image awtImage1, String documentType2, Image awtImage2) {
            this.docType1 = documentType1;
            this.awtBufferedImage1 = awtImage1;
            this.docType2 = documentType2;
            this.awtBufferedImage2 = awtImage2;
            this.isPrintRequestHeader = this.docType1 != null && this.docType1.length() > 1;
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int page) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            g2d.setPaint(Color.black);
            g2d.setFont(new Font("SansSerif", 0, GDE.WIDGET_FONT_SIZE));
            String date = StringHelper.getDate();
            Rectangle2D rectDate = g2d.getFontMetrics().getStringBounds(date, g2d);
            log.log(Level.FINE, "this.awtBufferedImage.getWidth(this) = " + this.awtBufferedImage1.getWidth(this));
            log.log(Level.FINE, "this.awtBufferedImage.getHeight(this) = " + this.awtBufferedImage1.getHeight(this));
            if (this.isPrintRequestHeader) {
                g2d.drawString(this.docType1, 2, 10);
                g2d.drawString(date, (int)(pageFormat.getImageableWidth() - rectDate.getWidth()), 10);
            }
            int offsetY = this.isPrintRequestHeader ? 20 : 0;
            double usableImageHeight = (this.awtBufferedImage2 == null ? pageFormat.getImageableHeight() : pageFormat.getImageableHeight() / 2.0) - (double)offsetY;
            double scaleFactor1 = pageFormat.getImageableWidth() / (double)this.awtBufferedImage1.getWidth(this);
            if (scaleFactor1 * (double)this.awtBufferedImage1.getHeight(this) < usableImageHeight - (double)offsetY) {
                g2d.drawImage(this.awtBufferedImage1, 0, offsetY, (int)pageFormat.getImageableWidth(), (int)(scaleFactor1 * (double)this.awtBufferedImage1.getHeight(this)), this);
            } else {
                scaleFactor1 = usableImageHeight / (double)this.awtBufferedImage1.getHeight(this);
                int printWidth = (int)(scaleFactor1 * (double)this.awtBufferedImage1.getWidth(this));
                int printHeight = (int)usableImageHeight;
                int offsetX = (int)((pageFormat.getImageableWidth() - (double)printWidth) / 2.0);
                g2d.drawImage(this.awtBufferedImage1, offsetX, offsetY, printWidth, printHeight, this);
            }
            if (this.awtBufferedImage2 != null) {
                if (this.isPrintRequestHeader) {
                    g2d.drawString(this.docType2, 2, (int)(pageFormat.getImageableHeight() / 2.0 + 10.0));
                    g2d.drawString(date, (int)(pageFormat.getImageableWidth() - rectDate.getWidth()), (int)(pageFormat.getImageableHeight() / 2.0 + 10.0));
                }
                offsetY = (int)(pageFormat.getImageableHeight() / 2.0 + (double)(this.isPrintRequestHeader ? 20 : 0));
                usableImageHeight = pageFormat.getImageableHeight() / 2.0 - (double)(this.isPrintRequestHeader ? 20 : 0);
                double scaleFactor2 = pageFormat.getImageableWidth() / (double)this.awtBufferedImage2.getWidth(this);
                if (scaleFactor2 * (double)this.awtBufferedImage2.getHeight(this) < usableImageHeight) {
                    g2d.drawImage(this.awtBufferedImage2, 0, offsetY, (int)pageFormat.getImageableWidth(), (int)(scaleFactor2 * (double)this.awtBufferedImage2.getHeight(this)), this);
                } else {
                    scaleFactor2 = usableImageHeight / (double)this.awtBufferedImage2.getHeight(this);
                    int printWidth = (int)(scaleFactor2 * (double)this.awtBufferedImage2.getWidth(this));
                    int printHeight = (int)usableImageHeight;
                    int offsetX = (int)((pageFormat.getImageableWidth() - (double)printWidth) / 2.0);
                    g2d.drawImage(this.awtBufferedImage2, offsetX, offsetY, printWidth, printHeight, this);
                }
            }
            return 0;
        }
    }
}

